/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.util.Iterator;
import org.apache.directory.server.core.api.entry.ClonedServerEntry;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.ClosureMonitor;
import org.apache.directory.shared.ldap.model.cursor.Cursor;
import org.apache.directory.shared.ldap.model.cursor.SearchCursor;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.Response;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntryToResponseCursor
implements SearchCursor {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private Cursor<Entry> wrapped;
    private SearchResultDone searchDoneResp;
    private boolean done;
    private int messageId;

    public EntryToResponseCursor(int messageId, Cursor<Entry> wrapped) {
        LOG_CURSOR.debug("Creating EntryToResponseCursor {}", this);
        this.wrapped = wrapped;
        this.messageId = messageId;
    }

    @Override
    public Iterator<Response> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void after(Response resp) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void afterLast() throws Exception {
        this.wrapped.afterLast();
    }

    @Override
    public boolean available() {
        return this.wrapped.available();
    }

    @Override
    public void before(Response resp) throws Exception {
        throw new UnsupportedOperationException();
    }

    @Override
    public void beforeFirst() throws Exception {
        this.wrapped.beforeFirst();
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing EntryToResponseCursor {}", this);
        this.wrapped.close();
    }

    @Override
    public void close(Exception e) throws Exception {
        LOG_CURSOR.debug("Closing EntryToResponseCursor {}", this);
        this.wrapped.close(e);
    }

    @Override
    public boolean first() throws Exception {
        return this.wrapped.first();
    }

    @Override
    public Response get() throws Exception {
        ClonedServerEntry entry = (ClonedServerEntry)this.wrapped.get();
        SearchResultEntryImpl se = new SearchResultEntryImpl(this.messageId);
        se.setEntry(entry);
        return se;
    }

    @Override
    public SearchResultDone getSearchResultDone() {
        return this.searchDoneResp;
    }

    @Override
    public boolean isClosed() throws Exception {
        return this.wrapped.isClosed();
    }

    @Override
    public boolean last() throws Exception {
        return this.wrapped.last();
    }

    @Override
    public boolean next() throws Exception {
        this.done = this.wrapped.next();
        if (!this.done) {
            this.searchDoneResp = new SearchResultDoneImpl(this.messageId);
            this.searchDoneResp.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
        }
        return this.done;
    }

    @Override
    public boolean previous() throws Exception {
        return this.wrapped.previous();
    }

    @Override
    public void setClosureMonitor(ClosureMonitor monitor) {
        this.wrapped.setClosureMonitor(monitor);
    }

    @Override
    public boolean isAfterLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isAfterLast()")));
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isBeforeFirst()")));
    }

    @Override
    public boolean isFirst() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isFirst()")));
    }

    @Override
    public boolean isLast() throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02014_UNSUPPORTED_OPERATION, this.getClass().getName().concat(".").concat("isLast()")));
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean isReferral() {
        return false;
    }

    @Override
    public Referral getReferral() throws LdapException {
        throw new LdapException();
    }

    @Override
    public boolean isEntry() {
        return true;
    }

    @Override
    public Entry getEntry() throws LdapException {
        if (!this.done && this.wrapped.available()) {
            try {
                return this.wrapped.get();
            }
            catch (Exception e) {
                throw new LdapException(e);
            }
        }
        throw new LdapException();
    }

    @Override
    public boolean isIntermediate() {
        return false;
    }

    @Override
    public IntermediateResponse getIntermediate() throws LdapException {
        throw new LdapException();
    }
}

