/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.schema.registries.synchronizers;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.exception.LdapUnwillingToPerformException;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeType;
import org.apache.directory.shared.ldap.model.schema.LdapSyntax;
import org.apache.directory.shared.ldap.model.schema.MatchingRule;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.apache.directory.shared.ldap.model.schema.SchemaObject;
import org.apache.directory.shared.ldap.model.schema.registries.Schema;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(SyntaxSynchronizer.class);

    public SyntaxSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    @Override
    public boolean modify(ModifyOperationContext modifyContext, Entry targetEntry, boolean cascade) throws LdapException {
        Dn name = modifyContext.getDn();
        Entry entry = modifyContext.getEntry();
        String oid = this.getOid(entry);
        LdapSyntax syntax = this.factory.getSyntax(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), this.getSchemaName(name));
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.isSchemaEnabled(schemaName)) {
            this.schemaManager.unregisterLdapSyntax(oid);
            this.schemaManager.add(syntax);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void add(Entry entry) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "Syntax");
        this.checkOidIsUnique(entry);
        String schemaName = this.getSchemaName(dn);
        LdapSyntax syntax = this.factory.getSyntax(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && syntax.isEnabled()) {
            if (this.schemaManager.add(syntax)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_399, entry.getDn().getName(), Strings.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("The Syntax {} cannot be added in the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    private List<SchemaObject> checkInUse(String oid) {
        ArrayList<SchemaObject> dependees = new ArrayList<SchemaObject>();
        for (AttributeType attributeType : this.schemaManager.getAttributeTypeRegistry()) {
            if (!oid.equals(attributeType.getSyntax().getOid())) continue;
            dependees.add(attributeType);
        }
        for (MatchingRule matchingRule : this.schemaManager.getMatchingRuleRegistry()) {
            if (!oid.equals(matchingRule.getSyntax().getOid())) continue;
            dependees.add(matchingRule);
        }
        return dependees;
    }

    private String getNames(List<SchemaObject> schemaObjects) {
        StringBuilder sb = new StringBuilder();
        boolean isFirst = true;
        for (SchemaObject schemaObject : schemaObjects) {
            if (isFirst) {
                isFirst = false;
            } else {
                sb.append(", ");
            }
            sb.append(schemaObject.getName());
        }
        return sb.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void delete(Entry entry, boolean cascade) throws LdapException {
        Dn dn = entry.getDn();
        Dn parentDn = dn.getParent();
        this.checkParent(parentDn, this.schemaManager, "Syntax");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The Syntax {} cannot be removed from the disabled schema {}.", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        LdapSyntax syntax = (LdapSyntax)this.checkOidExists(entry);
        ArrayList errors = new ArrayList();
        if (schema.isEnabled() && syntax.isEnabled()) {
            if (this.schemaManager.delete(syntax)) {
                LOG.debug("Removed {} from the schema {}", syntax, (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_400, entry.getDn().getName(), Strings.listToString(errors));
            LOG.info(msg);
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, msg);
        }
        LOG.debug("Removed {} from the disabled schema {}", syntax, (Object)schemaName);
    }

    @Override
    public void rename(Entry entry, Rdn newRdn, boolean cascade) throws LdapException {
        String oldOid = this.getOid(entry);
        String schemaName = this.getSchemaName(entry.getDn());
        List<SchemaObject> dependees = this.checkInUse(oldOid);
        if (dependees.size() != 0) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_401, oldOid, this.getNames(dependees)));
        }
        Entry targetEntry = entry.clone();
        String newOid = newRdn.getNormValue().getString();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        LdapSyntax syntax = this.factory.getSyntax(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), this.getSchemaName(entry.getDn()));
        if (this.isSchemaEnabled(schemaName)) {
            this.schemaManager.unregisterLdapSyntax(oldOid);
            this.schemaManager.add(syntax);
        } else {
            this.unregisterOids(syntax);
            this.registerOids(syntax);
        }
    }

    @Override
    public void moveAndRename(Dn oriChildName, Dn newParentName, Rdn newRn, boolean deleteOldRn, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        List<SchemaObject> dependees = this.checkInUse(oldOid);
        if (dependees.size() != 0) {
            throw new LdapUnwillingToPerformException(ResultCodeEnum.UNWILLING_TO_PERFORM, I18n.err(I18n.ERR_401, oldOid, this.getNames(dependees)));
        }
        Entry targetEntry = entry.clone();
        String newOid = newRn.getNormValue().getString();
        this.checkOidIsUnique(newOid);
        targetEntry.put("m-oid", newOid);
        LdapSyntax syntax = this.factory.getSyntax(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), this.getSchemaName(newParentName));
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterLdapSyntax(oldOid);
        } else {
            this.unregisterOids(syntax);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(syntax);
        } else {
            this.registerOids(syntax);
        }
    }

    @Override
    public void move(Dn oriChildName, Dn newParentName, Entry entry, boolean cascade) throws LdapException {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        LdapSyntax syntax = this.factory.getSyntax(this.schemaManager, entry, this.schemaManager.getRegistries(), this.getSchemaName(newParentName));
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterLdapSyntax(oid);
        } else {
            this.unregisterOids(syntax);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(syntax);
        } else {
            this.registerOids(syntax);
        }
    }

    private void checkNewParent(Dn newParent) throws LdapException {
        if (newParent.size() != 3) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_402, new Object[0]));
        }
        Rdn rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_403, new Object[0]));
        }
        if (!rdn.getNormValue().getString().equalsIgnoreCase("syntaxes")) {
            throw new LdapInvalidDnException(ResultCodeEnum.NAMING_VIOLATION, I18n.err(I18n.ERR_363, new Object[0]));
        }
    }
}

