/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.commons.collections.ArrayStack;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DescendantCursor<ID extends Comparable<ID>>
extends AbstractIndexCursor<ID, Entry, ID> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_719, new Object[0]);
    private final Store<Entry, ID> db;
    private IndexEntry prefetched;
    private IndexCursor<ParentIdAndRdn<ID>, Entry, ID> currentCursor;
    private ID currentParentId;
    private ArrayStack cursorStack;
    private ArrayStack parentIdStack;
    private ID baseId;
    private boolean topLevel;
    protected static final boolean TOP_LEVEL = true;
    protected static final boolean INNER = false;

    public DescendantCursor(Store<Entry, ID> db, ID baseId, ID parentId, IndexCursor<ParentIdAndRdn<ID>, Entry, ID> cursor) throws Exception {
        this(db, baseId, parentId, cursor, true);
    }

    public DescendantCursor(Store<Entry, ID> db, ID baseId, ID parentId, IndexCursor<ParentIdAndRdn<ID>, Entry, ID> cursor, boolean topLevel) throws Exception {
        LOG_CURSOR.debug("Creating ChildrenCursor {}", this);
        this.db = db;
        this.currentParentId = parentId;
        this.currentCursor = cursor;
        this.cursorStack = new ArrayStack();
        this.parentIdStack = new ArrayStack();
        this.baseId = baseId;
        this.topLevel = topLevel;
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public boolean previous() throws Exception {
        IndexEntry entry;
        this.checkNotClosed("next()");
        boolean hasPrevious = this.currentCursor.previous();
        if (hasPrevious && ((ParentIdAndRdn)(entry = (IndexEntry)this.currentCursor.get()).getTuple().getKey()).getParentId().equals(this.currentParentId)) {
            this.prefetched = entry;
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        boolean finished = false;
        while (!finished) {
            boolean hasNext = this.currentCursor.next();
            if (hasNext) {
                IndexEntry cursorEntry = (IndexEntry)this.currentCursor.get();
                ParentIdAndRdn parentIdAndRdn = (ParentIdAndRdn)cursorEntry.getKey();
                if (!parentIdAndRdn.getParentId().equals(this.currentParentId)) {
                    finished = this.cursorStack.size() == 0;
                    if (finished) continue;
                    this.currentCursor.close();
                    this.currentCursor = (IndexCursor)this.cursorStack.pop();
                    this.currentParentId = (Comparable)this.parentIdStack.pop();
                    continue;
                }
                if (this.topLevel) {
                    this.prefetched = new ForwardIndexEntry();
                    this.prefetched.setId((Comparable)cursorEntry.getId());
                    this.prefetched.setKey(this.baseId);
                } else {
                    this.prefetched = cursorEntry;
                }
                if (parentIdAndRdn.getNbDescendants() > 0) {
                    Comparable newParentId = (Comparable)cursorEntry.getId();
                    IndexCursor<ParentIdAndRdn<ID>, Entry, ID> cursor = this.db.getRdnIndex().forwardCursor();
                    ForwardIndexEntry startingPos = new ForwardIndexEntry();
                    startingPos.setKey(new ParentIdAndRdn<Comparable>(newParentId, (Rdn[])null));
                    cursor.before((Entry)((Object)startingPos));
                    this.cursorStack.push(this.currentCursor);
                    this.parentIdStack.push(this.currentParentId);
                    this.currentCursor = cursor;
                    this.currentParentId = newParentId;
                }
                return true;
            }
            finished = this.cursorStack.size() == 0;
            if (finished) continue;
            this.currentCursor.close();
            this.currentCursor = (IndexCursor)this.cursorStack.pop();
            this.currentParentId = (Comparable)this.parentIdStack.pop();
        }
        return false;
    }

    @Override
    public IndexEntry<ID, ID> get() throws Exception {
        this.checkNotClosed("get()");
        return this.prefetched;
    }

    @Override
    public void close() throws Exception {
        LOG_CURSOR.debug("Closing ChildrenCursor {}", this);
        for (Object cursor : this.cursorStack) {
            ((IndexCursor)cursor).close();
        }
        this.currentCursor.close();
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        LOG_CURSOR.debug("Closing ChildrenCursor {}", this);
        for (Object cursor : this.cursorStack) {
            ((IndexCursor)cursor).close(cause);
        }
        this.currentCursor.close(cause);
        super.close(cause);
    }
}

