/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.model.filter.ScopeNode;
import org.apache.directory.shared.ldap.model.message.SearchScope;

public class SubtreeScopeEvaluator<E, ID extends Comparable<ID>>
implements Evaluator<ScopeNode, E, ID> {
    private final ScopeNode node;
    private final ID baseId;
    private final boolean baseIsContextEntry;
    private final boolean dereferencing;
    private final Store<E, ID> db;
    private ID contextEntryId;

    public SubtreeScopeEvaluator(Store<E, ID> db, ScopeNode<ID> node) throws Exception {
        this.db = db;
        this.node = node;
        if (node.getScope() != SearchScope.SUBTREE) {
            throw new IllegalStateException(I18n.err(I18n.ERR_727, new Object[0]));
        }
        this.baseId = (Comparable)node.getBaseId();
        this.baseIsContextEntry = this.getContextEntryId() == this.baseId;
        this.dereferencing = node.getDerefAliases().isDerefInSearching() || node.getDerefAliases().isDerefAlways();
    }

    private ID getContextEntryId() throws Exception {
        if (this.contextEntryId == null) {
            try {
                this.contextEntryId = this.db.getEntryId(((Partition)((Object)this.db)).getSuffixDn());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.contextEntryId == null) {
            return this.db.getDefaultId();
        }
        return this.contextEntryId;
    }

    private boolean isDescendant(ID candidateId) throws Exception {
        ID tmp = candidateId;
        do {
            ParentIdAndRdn<ID> parentIdAndRdn;
            if ((parentIdAndRdn = this.db.getRdnIndex().reverseLookup(tmp)) == null) {
                return false;
            }
            tmp = parentIdAndRdn.getParentId();
            if (!tmp.equals(this.db.getRootId())) continue;
            return false;
        } while (!tmp.equals(this.baseId));
        return true;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ID> candidate) throws Exception {
        boolean isDescendant;
        Comparable id = (Comparable)candidate.getId();
        boolean bl = isDescendant = this.baseIsContextEntry || this.baseId.equals(id) || this.isDescendant(id);
        if (!this.isDereferencing()) {
            return isDescendant;
        }
        if (null != this.db.getAliasIndex().reverseLookup(id)) {
            return false;
        }
        if (isDescendant) {
            return true;
        }
        return this.db.getSubAliasIndex().forward((Comparable)this.baseId, id);
    }

    @Override
    public boolean evaluateEntry(E candidate) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_721, new Object[0]));
    }

    @Override
    public ScopeNode getExpression() {
        return this.node;
    }

    public ID getBaseId() {
        return this.baseId;
    }

    public boolean isDereferencing() {
        return this.dereferencing;
    }
}

