/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.ldapResult;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.BerValue;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.MessageDecorator;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreResultCode
extends GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreResultCode.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreResultCode() {
        super("Store resultCode");
    }

    @Override
    public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        BerValue value = tlv.getValue();
        ResultCodeEnum resultCode = ResultCodeEnum.SUCCESS;
        try {
            resultCode = ResultCodeEnum.getResultCode(IntegerDecoder.parse(value, 0, ResultCodeEnum.E_SYNC_REFRESH_REQUIRED.getResultCode()));
        }
        catch (IntegerDecoderException ide) {
            LOG.error(I18n.err(I18n.ERR_04018, Strings.dumpBytes(value.getData()), ide.getMessage()));
            throw new DecoderException(ide.getMessage());
        }
        if (IS_DEBUG) {
            LOG.debug("The result code is set to " + (Object)((Object)resultCode));
        }
        ResultResponse response = (ResultResponse)((Object)container.getMessage());
        LdapResult ldapResult = response.getLdapResult();
        ldapResult.setResultCode(resultCode);
    }
}

