/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions.searchRequest.filter;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreFinal
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreFinal.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreFinal() {
        super("Store a final value");
    }

    @Override
    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        SubstringFilter substringFilter = (SubstringFilter)searchRequest.getTerminalFilter();
        if (tlv.getLength() == 0) {
            String msg = I18n.err(I18n.ERR_04020, new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        String finalValue = Strings.utf8ToString(tlv.getValue().getData());
        substringFilter.setFinalSubstrings(finalValue);
        searchRequest.unstackFilters(container);
        if (IS_DEBUG) {
            LOG.debug("Stored a any substring : {}", (Object)finalValue);
        }
    }
}

