/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.config;

import net.sf.ehcache.config.NonstopConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerracottaConfiguration
implements Cloneable {
    public static final boolean DEFAULT_CLUSTERED = true;
    public static final ValueMode DEFAULT_VALUE_MODE = ValueMode.SERIALIZATION;
    public static final boolean DEFAULT_COHERENT_READS = true;
    public static final boolean DEFAULT_CACHE_XA = false;
    public static final boolean DEFAULT_ORPHAN_EVICTION = true;
    public static final int DEFAULT_ORPHAN_EVICTION_PERIOD = 4;
    public static final boolean DEFAULT_LOCAL_KEY_CACHE = false;
    public static final int DEFAULT_LOCAL_KEY_CACHE_SIZE = 300000;
    public static final boolean DEFAULT_COPY_ON_READ = false;
    public static final NonstopConfiguration DEFAULT_NON_STOP_CONFIGURATION = new NonstopConfiguration().enabled(false);
    @Deprecated
    public static final boolean DEFAULT_CACHE_COHERENT = true;
    public static final Consistency DEFAULT_CONSISTENCY_TYPE = Consistency.STRONG;
    public static final boolean DEFAULT_SYNCHRONOUS_WRITES = false;
    public static final StorageStrategy DEFAULT_STORAGE_STRATEGY = StorageStrategy.DCV2;
    public static final int DEFAULT_CONCURRENCY = 0;
    private static final Logger LOG = LoggerFactory.getLogger(TerracottaConfiguration.class.getName());
    private boolean clustered = true;
    private ValueMode valueMode = DEFAULT_VALUE_MODE;
    private boolean coherentReads = true;
    private boolean orphanEviction = true;
    private int orphanEvictionPeriod = 4;
    private boolean localKeyCache = false;
    private int localKeyCacheSize = 300000;
    private boolean isCopyOnRead = false;
    private boolean cacheXA = false;
    private boolean synchronousWrites = false;
    private StorageStrategy storageStrategy = DEFAULT_STORAGE_STRATEGY;
    private int concurrency = 0;
    private NonstopConfiguration nonStopConfiguration = DEFAULT_NON_STOP_CONFIGURATION;
    private boolean copyOnReadSet;
    private volatile boolean storageStrategySet;
    private Consistency consistency = DEFAULT_CONSISTENCY_TYPE;

    public TerracottaConfiguration clone() {
        try {
            TerracottaConfiguration clone = (TerracottaConfiguration)super.clone();
            if (this.nonStopConfiguration != null) {
                clone.nonstop(this.nonStopConfiguration.clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void setClustered(boolean clustered) {
        this.clustered = clustered;
    }

    public TerracottaConfiguration clustered(boolean clustered) {
        this.setClustered(clustered);
        return this;
    }

    public boolean isClustered() {
        return this.clustered;
    }

    public void setCopyOnRead(boolean isCopyOnRead) {
        LOG.warn("copyOnRead is deprecated on the <terracotta /> element, please use the copyOnRead attribute on <cache /> or <defaultCache />");
        this.copyOnReadSet = true;
        this.isCopyOnRead = isCopyOnRead;
    }

    boolean isCopyOnReadSet() {
        return this.copyOnReadSet;
    }

    public TerracottaConfiguration copyOnRead(boolean isCopyOnRead) {
        this.setCopyOnRead(isCopyOnRead);
        return this;
    }

    public boolean isCacheXA() {
        return this.cacheXA;
    }

    public void setCacheXA(boolean cacheXA) {
        this.cacheXA = cacheXA;
    }

    public TerracottaConfiguration cacheXA(boolean cacheXA) {
        this.setCacheXA(cacheXA);
        return this;
    }

    public boolean isCopyOnRead() {
        return this.isCopyOnRead;
    }

    public void setCoherentReads(boolean coherentReads) {
        LOG.warn("The attribute \"coherentReads\" in \"terracotta\" element is deprecated. Please use the new \"coherent\" attribute instead.");
        this.coherentReads = coherentReads;
    }

    public TerracottaConfiguration coherentReads(boolean coherentReads) {
        this.setCoherentReads(coherentReads);
        return this;
    }

    public boolean getCoherentReads() {
        return this.coherentReads;
    }

    public void setValueMode(String valueMode) {
        if (valueMode == null) {
            throw new IllegalArgumentException("Value mode must be non-null");
        }
        this.valueMode = ValueMode.valueOf(ValueMode.class, valueMode.toUpperCase());
    }

    public TerracottaConfiguration valueMode(String valueMode) {
        this.setValueMode(valueMode);
        return this;
    }

    public TerracottaConfiguration valueMode(ValueMode valueMode) {
        if (valueMode == null) {
            throw new IllegalArgumentException("Value mode must be non-null");
        }
        this.valueMode = valueMode;
        return this;
    }

    public ValueMode getValueMode() {
        return this.valueMode;
    }

    public void setOrphanEviction(boolean orphanEviction) {
        this.orphanEviction = orphanEviction;
    }

    public TerracottaConfiguration orphanEviction(boolean orphanEviction) {
        this.setOrphanEviction(orphanEviction);
        return this;
    }

    public boolean getOrphanEviction() {
        return this.orphanEviction;
    }

    public void setOrphanEvictionPeriod(int orphanEvictionPeriod) {
        this.orphanEvictionPeriod = orphanEvictionPeriod;
    }

    public TerracottaConfiguration orphanEvictionPeriod(int orphanEvictionPeriod) {
        this.setOrphanEvictionPeriod(orphanEvictionPeriod);
        return this;
    }

    public int getOrphanEvictionPeriod() {
        return this.orphanEvictionPeriod;
    }

    public void setLocalKeyCache(boolean localKeyCache) {
        this.localKeyCache = localKeyCache;
    }

    public TerracottaConfiguration localKeyCache(boolean localKeyCache) {
        this.setLocalKeyCache(localKeyCache);
        return this;
    }

    public boolean getLocalKeyCache() {
        return this.localKeyCache;
    }

    public void setLocalKeyCacheSize(int localKeyCacheSize) {
        this.localKeyCacheSize = localKeyCacheSize;
    }

    public TerracottaConfiguration localKeyCacheSize(int localKeyCacheSize) {
        this.setLocalKeyCacheSize(localKeyCacheSize);
        return this;
    }

    public int getLocalKeyCacheSize() {
        return this.localKeyCacheSize;
    }

    @Deprecated
    public void setCoherent(boolean coherent) {
        Consistency consistencyType = coherent ? Consistency.STRONG : Consistency.EVENTUAL;
        this.consistency(consistencyType);
    }

    @Deprecated
    public TerracottaConfiguration coherent(boolean coherent) {
        Consistency consistencyType = coherent ? Consistency.STRONG : Consistency.EVENTUAL;
        this.consistency(consistencyType);
        return this;
    }

    @Deprecated
    public boolean isCoherent() {
        return this.consistency == Consistency.STRONG;
    }

    public boolean isSynchronousWrites() {
        return this.synchronousWrites;
    }

    public void setSynchronousWrites(boolean synchronousWrites) {
        this.synchronousWrites = synchronousWrites;
    }

    public TerracottaConfiguration synchronousWrites(boolean synchronousWrites) {
        this.setSynchronousWrites(synchronousWrites);
        return this;
    }

    public void setStorageStrategy(String storageStrategy) {
        if (storageStrategy == null) {
            throw new IllegalArgumentException("Storage Strategy must be non-null");
        }
        this.storageStrategy(StorageStrategy.valueOf(StorageStrategy.class, storageStrategy.toUpperCase()));
    }

    public TerracottaConfiguration storageStrategy(String storageStrategy) {
        this.setStorageStrategy(storageStrategy);
        return this;
    }

    public TerracottaConfiguration storageStrategy(StorageStrategy storageStrategy) {
        if (storageStrategy == null) {
            throw new IllegalArgumentException("Storage Strategy must be non-null");
        }
        this.storageStrategy = storageStrategy;
        this.storageStrategySet = true;
        return this;
    }

    public boolean isStorageStrategySet() {
        return this.storageStrategySet;
    }

    public StorageStrategy getStorageStrategy() {
        return this.storageStrategy;
    }

    public TerracottaConfiguration concurrency(int concurrency) {
        this.setConcurrency(concurrency);
        return this;
    }

    public void setConcurrency(int concurrency) {
        if (concurrency < 0) {
            throw new IllegalArgumentException("Only non-negative integers allowed");
        }
        this.concurrency = concurrency;
    }

    public int getConcurrency() {
        return this.concurrency;
    }

    public void addNonstop(NonstopConfiguration nonstopConfiguration) {
        this.nonStopConfiguration = nonstopConfiguration;
    }

    public TerracottaConfiguration nonstop(NonstopConfiguration nonstopConfiguration) {
        this.addNonstop(nonstopConfiguration);
        return this;
    }

    public NonstopConfiguration getNonstopConfiguration() {
        return this.nonStopConfiguration;
    }

    public boolean isNonstopEnabled() {
        return this.nonStopConfiguration != null && this.nonStopConfiguration.isEnabled();
    }

    public TerracottaConfiguration consistency(Consistency consistency) {
        this.setConsistency(consistency);
        return this;
    }

    public void setConsistency(Consistency consistency) {
        this.consistency = consistency;
    }

    public void setConsistency(String consistency) {
        if (consistency == null) {
            throw new IllegalArgumentException("Consistency cannot be null");
        }
        this.setConsistency(Consistency.valueOf(consistency.toUpperCase()));
    }

    public Consistency getConsistency() {
        return this.consistency;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Consistency {
        STRONG,
        EVENTUAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StorageStrategy {
        CLASSIC,
        DCV2;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ValueMode {
        SERIALIZATION,
        IDENTITY;

    }
}

