/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.subtree;

import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.subtree.Subentry;

public class SubentryCache
implements Iterable<Dn> {
    private static final int DEFAULT_CACHE_MAX_SIZE = 1000;
    private int cacheMaxSize = 1000;
    private AtomicInteger cacheSize;
    private final Map<Dn, Subentry> cache = new ConcurrentHashMap<Dn, Subentry>();

    public SubentryCache() {
        this.cacheSize = new AtomicInteger(0);
    }

    public SubentryCache(int maxSize) {
        this.cacheSize = new AtomicInteger(0);
        this.cacheMaxSize = maxSize;
    }

    public final Subentry getSubentry(Dn dn) {
        return this.cache.get(dn);
    }

    public final Subentry removeSubentry(Dn dn) {
        Subentry oldSubentry = this.cache.remove(dn);
        if (oldSubentry != null) {
            this.cacheSize.decrementAndGet();
        }
        return oldSubentry;
    }

    public Subentry addSubentry(Dn dn, Subentry subentry) {
        Subentry oldSubentry;
        if (this.cacheSize.get() > this.cacheMaxSize) {
            // empty if block
        }
        if ((oldSubentry = this.cache.put(dn, subentry)) == null) {
            this.cacheSize.getAndIncrement();
        }
        return oldSubentry;
    }

    public boolean hasSubentry(Dn dn) {
        return this.cache.containsKey(dn);
    }

    @Override
    public Iterator<Dn> iterator() {
        return this.cache.keySet().iterator();
    }

    public int getCacheSize() {
        return this.cacheSize.get();
    }
}

