/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.jdbm;

import java.io.IOException;
import jdbm.helper.TupleBrowser;
import org.apache.directory.server.core.partition.impl.btree.jdbm.JdbmTable;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.apache.directory.shared.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.model.cursor.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NoDupsCursor<K, V>
extends AbstractCursor<Tuple<K, V>> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final JdbmTable<K, V> table;
    private jdbm.helper.Tuple jdbmTuple = new jdbm.helper.Tuple();
    private Tuple<K, V> returnedTuple = new Tuple();
    private TupleBrowser browser;
    private boolean valueAvailable;

    public NoDupsCursor(JdbmTable<K, V> table) throws IOException {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating NoDupsCursor {}", (Object)this);
        }
        this.table = table;
    }

    private void clearValue() {
        this.returnedTuple.setKey(null);
        this.returnedTuple.setValue(null);
        this.jdbmTuple.setKey(null);
        this.jdbmTuple.setValue(null);
        this.valueAvailable = false;
    }

    @Override
    public boolean available() {
        return this.valueAvailable;
    }

    public void beforeKey(K key) throws Exception {
        this.checkNotClosed("beforeKey()");
        this.closeBrowser(this.browser);
        this.browser = this.table.getBTree().browse(key);
        this.clearValue();
    }

    public void afterKey(K key) throws Exception {
        this.closeBrowser(this.browser);
        this.browser = this.table.getBTree().browse(key);
        while (this.browser.getNext(this.jdbmTuple)) {
            this.checkNotClosed("afterKey()");
            Object next = this.jdbmTuple.getKey();
            int nextCompared = this.table.getKeyComparator().compare(next, key);
            if (nextCompared <= 0) continue;
            this.browser.getPrevious(this.jdbmTuple);
            this.clearValue();
            return;
        }
        this.clearValue();
    }

    public void beforeValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_596, new Object[0]));
    }

    public void afterValue(K key, V value) throws Exception {
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_596, new Object[0]));
    }

    @Override
    public void before(Tuple<K, V> element) throws Exception {
        this.beforeKey(element.getKey());
    }

    @Override
    public void after(Tuple<K, V> element) throws Exception {
        this.afterKey(element.getKey());
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.closeBrowser(this.browser);
        this.browser = this.table.getBTree().browse();
        this.clearValue();
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.closeBrowser(this.browser);
        this.browser = this.table.getBTree().browse(null);
        this.clearValue();
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.afterLast();
        }
        if (this.browser.getPrevious(this.jdbmTuple)) {
            if (this.returnedTuple.getKey() != null && this.table.getKeyComparator().compare(this.jdbmTuple.getKey(), this.returnedTuple.getKey()) == 0) {
                this.browser.getPrevious(this.jdbmTuple);
            }
            this.returnedTuple.setKey(this.jdbmTuple.getKey());
            this.returnedTuple.setValue(this.jdbmTuple.getValue());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("previous()");
        if (this.browser == null) {
            this.beforeFirst();
        }
        if (this.browser.getNext(this.jdbmTuple)) {
            if (this.returnedTuple.getKey() != null && this.table.getKeyComparator().compare(this.jdbmTuple.getKey(), this.returnedTuple.getKey()) == 0) {
                this.browser.getNext(this.jdbmTuple);
            }
            this.returnedTuple.setKey(this.jdbmTuple.getKey());
            this.returnedTuple.setValue(this.jdbmTuple.getValue());
            this.valueAvailable = true;
            return true;
        }
        this.clearValue();
        return false;
    }

    @Override
    public Tuple<K, V> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.valueAvailable) {
            return this.returnedTuple;
        }
        throw new InvalidCursorPositionException();
    }

    @Override
    public void close() throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing NoDupsCursor {}", (Object)this);
        }
        super.close();
        this.closeBrowser(this.browser);
    }

    @Override
    public void close(Exception cause) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing NoDupsCursor {}", (Object)this);
        }
        super.close(cause);
        this.closeBrowser(this.browser);
    }

    private void closeBrowser(TupleBrowser browser) {
        if (browser != null) {
            browser.close();
        }
    }
}

