/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.shared;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.directory.server.core.api.DnFactory;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDnFactory
implements DnFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDnFactory.class);
    private Cache dnCache;
    private SchemaManager schemaManager;
    private boolean enableStats = false;
    private int hitCount = 0;
    private int missCount = 0;

    public DefaultDnFactory(SchemaManager schemaManager, Cache dnCache) {
        this.schemaManager = schemaManager;
        this.dnCache = dnCache;
    }

    @Override
    public Dn create(String dn) throws LdapInvalidDnException {
        Element dnCacheEntry;
        if (dn == null) {
            return null;
        }
        if (dn.trim().length() == 0) {
            return Dn.ROOT_DSE;
        }
        Dn cachedDn = null;
        if (this.dnCache != null && (dnCacheEntry = this.dnCache.get((Serializable)((Object)dn))) != null) {
            cachedDn = (Dn)dnCacheEntry.getObjectValue();
        }
        if (cachedDn == null) {
            LOG.debug("Dn {} not found in the cache, creating", (Object)dn);
            cachedDn = new Dn(this.schemaManager, dn);
            if (this.dnCache != null) {
                this.dnCache.put(new Element((Serializable)((Object)dn), cachedDn));
            }
            if (this.enableStats) {
                ++this.missCount;
            }
        } else {
            cachedDn.apply(this.schemaManager);
            if (this.enableStats) {
                ++this.hitCount;
            }
        }
        LOG.debug("Dn {} found in the cache", (Object)dn);
        if (this.enableStats) {
            System.out.println("Dn cache hit - " + this.hitCount + ", miss - " + this.missCount + " and is normalized = " + cachedDn.isSchemaAware());
        }
        return cachedDn;
    }

    @Override
    public Dn create(String ... upRdns) throws LdapInvalidDnException {
        StringBuilder sb = new StringBuilder();
        for (String s : upRdns) {
            sb.append(s).append(',');
        }
        String dn = sb.toString();
        dn = dn.substring(0, dn.length() - 1);
        return this.create(dn);
    }
}

