/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.cursor;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Set;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.cursor.AbstractCursor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetCursor<E>
extends AbstractCursor<E> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private final E[] set;
    private final Comparator<E> comparator;
    private int index = -1;

    public SetCursor(Comparator<E> comparator, Set<E> set) {
        if (set == null) {
            set = Collections.EMPTY_SET;
        }
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating SetCursor {}", (Object)this);
        }
        this.comparator = comparator;
        this.set = set.toArray();
    }

    public SetCursor(Set<E> set) {
        this(null, set);
    }

    public SetCursor() {
        this(null, Collections.EMPTY_SET);
    }

    public SetCursor(Comparator<E> comparator) {
        this(comparator, Collections.EMPTY_SET);
    }

    @Override
    public boolean available() {
        return this.index >= 0 && this.index < this.set.length;
    }

    @Override
    public void before(E element) throws Exception {
        this.checkNotClosed("before()");
        if (this.comparator == null) {
            throw new IllegalStateException();
        }
        if (this.set.length == 0) {
            return;
        }
        if (this.set.length == 1) {
            if (this.comparator.compare(element, this.set[0]) <= 0) {
                this.beforeFirst();
            } else {
                this.afterLast();
            }
        }
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02008_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void after(E element) throws Exception {
        this.checkNotClosed("after()");
        if (this.comparator == null) {
            throw new IllegalStateException();
        }
        if (this.set.length == 0) {
            return;
        }
        if (this.set.length == 1) {
            if (this.comparator.compare(element, this.set[0]) >= 0) {
                this.afterLast();
            } else {
                this.beforeFirst();
            }
        }
        throw new UnsupportedOperationException(I18n.err(I18n.ERR_02008_LIST_MAY_BE_SORTED, new Object[0]));
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        this.index = -1;
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.index = this.set.length;
    }

    @Override
    public boolean first() throws Exception {
        this.checkNotClosed("first()");
        if (this.set.length > 0) {
            this.index = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws Exception {
        this.checkNotClosed("last()");
        if (this.set.length > 0) {
            this.index = this.set.length - 1;
            return true;
        }
        return false;
    }

    @Override
    public boolean isFirst() throws Exception {
        this.checkNotClosed("isFirst()");
        return this.set.length > 0 && this.index == 0;
    }

    @Override
    public boolean isLast() throws Exception {
        this.checkNotClosed("isLast()");
        return this.set.length > 0 && this.index == this.set.length - 1;
    }

    @Override
    public boolean isAfterLast() throws Exception {
        this.checkNotClosed("isAfterLast()");
        return this.index == this.set.length;
    }

    @Override
    public boolean isBeforeFirst() throws Exception {
        this.checkNotClosed("isBeforeFirst()");
        return this.index == -1;
    }

    @Override
    public boolean previous() throws Exception {
        this.checkNotClosed("previous()");
        if (this.index == -1) {
            return false;
        }
        if (this.index - 1 >= 0) {
            --this.index;
            return true;
        }
        if (this.index <= 0) {
            this.index = -1;
            return false;
        }
        if (this.set.length <= 0) {
            this.index = -1;
        }
        return false;
    }

    @Override
    public boolean next() throws Exception {
        this.checkNotClosed("next()");
        if (this.set.length > 0 && this.index == -1) {
            this.index = 0;
            return true;
        }
        if (this.set.length > 0 && this.index + 1 < this.set.length) {
            ++this.index;
            return true;
        }
        if (this.set.length > 0 && this.index + 1 == this.set.length) {
            ++this.index;
            return false;
        }
        if (this.set.length <= 0) {
            this.index = this.set.length;
        }
        return false;
    }

    @Override
    public E get() throws Exception {
        this.checkNotClosed("get()");
        if (this.index < 0 || this.index >= this.set.length) {
            throw new IOException(I18n.err(I18n.ERR_02009_CURSOR_NOT_POSITIONED, new Object[0]));
        }
        return this.set[this.index];
    }

    @Override
    public void close() throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ListCursor {}", (Object)this);
        }
        super.close();
    }

    @Override
    public void close(Exception cause) throws Exception {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ListCursor {}", (Object)this);
        }
        super.close(cause);
    }
}

