/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.model.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.schema.parsers.AbstractSchemaParser;
import org.apache.directory.shared.ldap.model.schema.parsers.LdapComparatorDescription;
import org.apache.directory.shared.ldap.model.schema.parsers.ReusableAntlrSchemaParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapComparatorDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(LdapComparatorDescriptionSchemaParser.class);

    public LdapComparatorDescription parseComparatorDescription(String comparatorDescription) throws ParseException {
        LOG.debug("Parsing a Comparator : {}", (Object)comparatorDescription);
        if (comparatorDescription == null) {
            LOG.error(I18n.err(I18n.ERR_04236, new Object[0]));
            throw new ParseException("Null", 0);
        }
        ReusableAntlrSchemaParser reusableAntlrSchemaParser = this.parser;
        synchronized (reusableAntlrSchemaParser) {
            this.reset(comparatorDescription);
            try {
                LdapComparatorDescription ldapComparatorDescription = this.parser.ldapComparator();
                LOG.debug("Parsed a LdapComparator : {}", (Object)ldapComparatorDescription);
                LdapComparatorDescriptionSchemaParser.updateSchemaName(ldapComparatorDescription);
                return ldapComparatorDescription;
            }
            catch (RecognitionException re) {
                String msg = I18n.err(I18n.ERR_04273, comparatorDescription, re.getMessage(), re.getColumn());
                LOG.error(msg);
                throw new ParseException(msg, re.getColumn());
            }
            catch (TokenStreamException tse) {
                String msg = I18n.err(I18n.ERR_04238, comparatorDescription, tse.getMessage());
                LOG.error(msg);
                throw new ParseException(msg, 0);
            }
        }
    }

    public LdapComparatorDescription parse(String schemaDescription) throws ParseException {
        return this.parseComparatorDescription(schemaDescription);
    }
}

