/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api.authn.ppolicy;

import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.core.api.authn.ppolicy.DefaultPasswordValidator;
import org.apache.directory.server.core.api.authn.ppolicy.PasswordValidator;

public class PasswordPolicyConfiguration {
    private String pwdAttribute = "userPassword";
    private int pwdMinAge = 0;
    private int pwdMaxAge = 0;
    private int pwdInHistory = 0;
    private int pwdCheckQuality = 0;
    private int pwdMinLength = 0;
    private int pwdMaxLength = 0;
    private int pwdExpireWarning = 0;
    private int pwdGraceAuthNLimit = 0;
    private int pwdGraceExpire = 0;
    private boolean pwdLockout = false;
    private int pwdLockoutDuration = 300;
    private int pwdMaxFailure = 0;
    private int pwdFailureCountInterval = 0;
    private boolean pwdMustChange = false;
    private boolean pwdAllowUserChange = true;
    private boolean pwdSafeModify = false;
    private int pwdMinDelay = 0;
    private int pwdMaxDelay = 0;
    private int pwdMaxIdle = 0;
    private PasswordValidator pwdValidator = DefaultPasswordValidator.INSTANCE;

    public String getPwdAttribute() {
        return this.pwdAttribute;
    }

    public void setPwdAttribute(String pwdAttribute) {
        this.pwdAttribute = pwdAttribute;
    }

    public int getPwdMinAge() {
        return this.pwdMinAge;
    }

    public void setPwdMinAge(int pwdMinAge) {
        this.pwdMinAge = pwdMinAge;
    }

    public int getPwdMaxAge() {
        return this.pwdMaxAge;
    }

    public void setPwdMaxAge(int pwdMaxAge) {
        this.pwdMaxAge = pwdMaxAge;
    }

    public int getPwdInHistory() {
        return this.pwdInHistory;
    }

    public void setPwdInHistory(int pwdInHistory) {
        this.pwdInHistory = pwdInHistory;
    }

    public int getPwdCheckQuality() {
        return this.pwdCheckQuality;
    }

    public void setPwdCheckQuality(int pwdCheckQuality) {
        this.pwdCheckQuality = pwdCheckQuality;
    }

    public int getPwdMinLength() {
        return this.pwdMinLength;
    }

    public void setPwdMinLength(int pwdMinLength) {
        this.pwdMinLength = pwdMinLength;
    }

    public int getPwdMaxLength() {
        return this.pwdMaxLength;
    }

    public void setPwdMaxLength(int pwdMaxLength) {
        this.pwdMaxLength = pwdMaxLength;
    }

    public int getPwdExpireWarning() {
        return this.pwdExpireWarning;
    }

    public void setPwdExpireWarning(int pwdExpireWarning) {
        this.pwdExpireWarning = pwdExpireWarning;
    }

    public int getPwdGraceAuthNLimit() {
        return this.pwdGraceAuthNLimit;
    }

    public void setPwdGraceAuthNLimit(int pwdGraceAuthNLimit) {
        this.pwdGraceAuthNLimit = pwdGraceAuthNLimit;
    }

    public int getPwdGraceExpire() {
        return this.pwdGraceExpire;
    }

    public void setPwdGraceExpire(int pwdGraceExpire) {
        this.pwdGraceExpire = pwdGraceExpire;
    }

    public boolean isPwdLockout() {
        return this.pwdLockout;
    }

    public void setPwdLockout(boolean pwdLockout) {
        this.pwdLockout = pwdLockout;
    }

    public int getPwdLockoutDuration() {
        return this.pwdLockoutDuration;
    }

    public void setPwdLockoutDuration(int pwdLockoutDuration) {
        this.pwdLockoutDuration = pwdLockoutDuration;
    }

    public int getPwdMaxFailure() {
        return this.pwdMaxFailure;
    }

    public void setPwdMaxFailure(int pwdMaxFailure) {
        this.pwdMaxFailure = pwdMaxFailure;
    }

    public int getPwdFailureCountInterval() {
        return this.pwdFailureCountInterval;
    }

    public void setPwdFailureCountInterval(int pwdFailureCountInterval) {
        this.pwdFailureCountInterval = pwdFailureCountInterval;
    }

    public boolean isPwdMustChange() {
        return this.pwdMustChange;
    }

    public void setPwdMustChange(boolean pwdMustChange) {
        this.pwdMustChange = pwdMustChange;
    }

    public boolean isPwdAllowUserChange() {
        return this.pwdAllowUserChange;
    }

    public void setPwdAllowUserChange(boolean pwdAllowUserChange) {
        this.pwdAllowUserChange = pwdAllowUserChange;
    }

    public boolean isPwdSafeModify() {
        return this.pwdSafeModify;
    }

    public void setPwdSafeModify(boolean pwdSafeModify) {
        this.pwdSafeModify = pwdSafeModify;
    }

    public int getPwdMinDelay() {
        return this.pwdMinDelay;
    }

    public void setPwdMinDelay(int pwdMinDelay) {
        this.pwdMinDelay = pwdMinDelay;
    }

    public int getPwdMaxDelay() {
        return this.pwdMaxDelay;
    }

    public void setPwdMaxDelay(int pwdMaxDelay) {
        this.pwdMaxDelay = pwdMaxDelay;
    }

    public int getPwdMaxIdle() {
        return this.pwdMaxIdle;
    }

    public void setPwdMaxIdle(int pwdMaxIdle) {
        this.pwdMaxIdle = pwdMaxIdle;
    }

    public PasswordValidator getPwdValidator() {
        return this.pwdValidator;
    }

    public void setPwdValidator(PasswordValidator pwdValidator) {
        this.pwdValidator = pwdValidator;
    }

    public void validate() throws LdapException {
        StringBuilder sb = new StringBuilder();
        int errCount = 0;
        if (this.pwdMinAge < 0) {
            sb.append(++errCount).append(". password minimum age cannot be negative\n");
        }
        if (this.pwdMaxAge < 0) {
            sb.append(++errCount).append(". password maximum age cannot be negative\n");
        }
        if (this.pwdMaxAge > 0 && this.pwdMaxAge < this.pwdMinAge) {
            sb.append(++errCount).append(". password maximum age should be greater than the minimum age\n");
        }
        if (this.pwdInHistory < 0) {
            sb.append(++errCount).append(". password history count cannot be negative\n");
        }
        if (this.pwdCheckQuality < 0 || this.pwdCheckQuality > 2) {
            sb.append(++errCount).append(". invalid password quality check value, valid values are 0, 1 and 2 \n");
        }
        if (this.pwdMinLength < 0) {
            sb.append(++errCount).append(". password minimum length cannot be negative\n");
        }
        if (this.pwdMaxLength < 0) {
            sb.append(++errCount).append(". password maximum length cannot be negative\n");
        }
        if (this.pwdMaxLength > 0 && this.pwdMaxLength < this.pwdMinLength) {
            sb.append(++errCount).append(". password maximum length should be greater than minimum length\n");
        }
        if (this.pwdExpireWarning < 0) {
            sb.append(++errCount).append(". password expire warning time cannot be negative\n");
        }
        if (this.pwdGraceAuthNLimit < 0) {
            sb.append(++errCount).append(". password grace authentication limits cannot be negative\n");
        }
        if (this.pwdGraceExpire < 0) {
            sb.append(++errCount).append(". password grace expiration time cannot be negative\n");
        }
        if (this.pwdLockoutDuration < 0) {
            sb.append(++errCount).append(". password lockout duration time cannot be negative\n");
        }
        if (this.pwdMaxFailure < 0) {
            sb.append(++errCount).append(". password maximum failure count cannot be negative\n");
        }
        if (this.pwdFailureCountInterval < 0) {
            sb.append(++errCount).append(". password failure count interval time cannot be negative\n");
        }
        if (this.pwdMinDelay > 0 && this.pwdMaxDelay <= 0 || this.pwdMaxDelay > 0 && this.pwdMinDelay <= 0) {
            sb.append(++errCount).append(". if password minimum or maximum delay time is specified then the correspomding maximu or minimum delay time should also be specified\n");
        } else {
            if (this.pwdMinDelay < 0) {
                sb.append(++errCount).append(". password minimum delay time cannot be negative\n");
            }
            if (this.pwdMaxDelay < 0) {
                sb.append(++errCount).append(". password maximum delay time cannot be negative\n");
            }
        }
        if (this.pwdMaxIdle < 0) {
            sb.append(++errCount).append(". password maximum idle time cannot be negative\n");
        }
        if (errCount > 0) {
            throw new LdapException("There are errors in password policy configuration\n" + sb.toString());
        }
    }
}

