/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.evaluator;

import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.normalizers.NoOpNormalizer;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;

public class SubstringEvaluator
implements Evaluator<SubstringNode> {
    private final Store db;
    private final SchemaManager schemaManager;
    private final SubstringNode node;
    private final Pattern regex;
    private final AttributeType attributeType;
    private final Normalizer normalizer;
    private final Index<String, String> idx;

    public SubstringEvaluator(SubstringNode node, Store db, SchemaManager schemaManager) throws Exception {
        this.db = db;
        this.node = node;
        this.schemaManager = schemaManager;
        this.attributeType = node.getAttributeType();
        MatchingRule rule = this.attributeType.getSubstring();
        if (rule == null) {
            rule = this.attributeType.getEquality();
        }
        this.normalizer = rule != null ? rule.getNormalizer() : new NoOpNormalizer(this.attributeType.getSyntaxOid());
        this.regex = this.attributeType.getSyntax().isHumanReadable() ? node.getRegex(this.normalizer) : null;
        this.idx = db.hasIndexOn(this.attributeType) ? db.getIndex(this.attributeType) : null;
    }

    @Override
    public boolean evaluate(IndexEntry<?, String> indexEntryQM) throws LdapException {
        Attribute attr;
        IndexEntry<?, String> indexEntry = indexEntryQM;
        Entry entry = indexEntry.getEntry();
        if (null == entry) {
            entry = this.db.fetch(indexEntry.getId());
            if (null == entry) {
                return false;
            }
            indexEntry.setEntry(entry);
        }
        if ((attr = entry.get(this.attributeType)) != null) {
            if (attr.isHumanReadable()) {
                for (Value value : attr) {
                    String strValue = (String)value.getNormValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    indexEntry.setKey(strValue);
                    return true;
                }
            } else {
                for (Value value : attr) {
                    byte[] byteValue = (byte[])value.getNormValue();
                }
            }
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = (AttributeType)descendants.next();
                attr = entry.get(descendant);
                if (null == attr) continue;
                for (Value value : attr) {
                    String strValue = (String)value.getNormValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    indexEntry.setKey(strValue);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean evaluate(Entry entry) throws Exception {
        Attribute attr = entry.get(this.attributeType);
        if (attr != null) {
            for (Value value : attr) {
                String strValue = (String)value.getNormValue();
                if (!this.regex.matcher(strValue).matches()) continue;
                return true;
            }
        }
        if (this.schemaManager.getAttributeTypeRegistry().hasDescendants(this.attributeType)) {
            Iterator descendants = this.schemaManager.getAttributeTypeRegistry().descendants(this.attributeType);
            while (descendants.hasNext()) {
                AttributeType descendant = (AttributeType)descendants.next();
                attr = entry.get(descendant);
                if (null == attr) continue;
                for (Value value : attr) {
                    String strValue = (String)value.getNormValue();
                    if (!this.regex.matcher(strValue).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Pattern getPattern() {
        return this.regex;
    }

    @Override
    public SubstringNode getExpression() {
        return this.node;
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("SubstringEvaluator : ").append(this.node).append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

