/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.client;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.shared.kerberos.KerberosUtils;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;

public class KdcConfig {
    private String hostName = "localhost";
    private int kdcPort = 88;
    private int passwdPort = 464;
    private boolean useUdp = true;
    private boolean useLegacyChngPwdProtocol = false;
    private int timeout = 60000;
    private Set<EncryptionType> encryptionTypes = new HashSet<EncryptionType>();

    public KdcConfig() {
        this.encryptionTypes.add(EncryptionType.AES128_CTS_HMAC_SHA1_96);
        this.encryptionTypes.add(EncryptionType.AES256_CTS_HMAC_SHA1_96);
        this.encryptionTypes.add(EncryptionType.DES_CBC_MD5);
        this.encryptionTypes.add(EncryptionType.DES3_CBC_SHA1_KD);
        this.encryptionTypes = KerberosUtils.orderEtypesByStrength(this.encryptionTypes);
    }

    public static KdcConfig getDefaultConfig() {
        return new KdcConfig();
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public int getKdcPort() {
        return this.kdcPort;
    }

    public void setKdcPort(int kdcPort) {
        this.kdcPort = kdcPort;
    }

    public int getPasswdPort() {
        return this.passwdPort;
    }

    public void setPasswdPort(int passwdPort) {
        this.passwdPort = passwdPort;
    }

    public boolean isUseUdp() {
        return this.useUdp;
    }

    public void setUseUdp(boolean useUdp) {
        this.useUdp = useUdp;
    }

    public boolean isUseLegacyChngPwdProtocol() {
        return this.useLegacyChngPwdProtocol;
    }

    public void setUseLegacyChngPwdProtocol(boolean useLegacyChngPwdProtocol) {
        this.useLegacyChngPwdProtocol = useLegacyChngPwdProtocol;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public Set<EncryptionType> getEncryptionTypes() {
        return this.encryptionTypes;
    }

    public void setEncryptionTypes(Set<EncryptionType> encryptionTypes) {
        this.encryptionTypes = encryptionTypes;
    }

    public String toString() {
        return "KdcConfig [hostName=" + this.hostName + ", kdcPort=" + this.kdcPort + ", passwdPort=" + this.passwdPort + ", useUdp=" + this.useUdp + ", useLegacyChngPwdProtocol=" + this.useLegacyChngPwdProtocol + ", timeout=" + this.timeout + ", encryptionTypes=" + this.encryptionTypes + "]";
    }
}

