/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.client;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.directory.kerberos.client.KdcClientUtil;
import org.apache.directory.shared.kerberos.codec.options.KdcOptions;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.HostAddress;

public class TgtRequest {
    private String clientPrincipal;
    private String password;
    private String realm;
    private String serverPrincipal;
    private long startTime;
    private long expiryTime;
    private long renewTill;
    private List<HostAddress> hostAddresses = new ArrayList<HostAddress>();
    private KdcOptions options = new KdcOptions();
    private boolean preAuthEnabled = false;
    private Set<EncryptionType> eTypes;

    public TgtRequest() {
        this.startTime = System.currentTimeMillis();
        this.expiryTime = this.startTime + 28800000L;
    }

    public void addHost(String hostNameOrIpAddress) throws UnknownHostException {
        InetAddress address = InetAddress.getByName(hostNameOrIpAddress);
        this.hostAddresses.add(new HostAddress(address));
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientPrincipal() {
        return this.clientPrincipal;
    }

    public void setClientPrincipal(String clientPrincipal) {
        this.clientPrincipal = clientPrincipal;
        this.realm = KdcClientUtil.extractRealm(clientPrincipal);
    }

    public String getRealm() {
        return this.realm;
    }

    public String getServerPrincipal() {
        return this.serverPrincipal;
    }

    public void setServerPrincipal(String serverPrincipal) {
        this.serverPrincipal = serverPrincipal;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getExpiryTime() {
        return this.expiryTime;
    }

    public void setExpiryTime(long expiryTime) {
        this.expiryTime = expiryTime;
    }

    public long getRenewTill() {
        return this.renewTill;
    }

    public void setRenewTill(long renewTill) {
        this.renewTill = renewTill;
    }

    public List<HostAddress> getHostAddresses() {
        return this.hostAddresses;
    }

    public void setForwardable(boolean forwardable) {
        this.setOrClear(1, forwardable);
    }

    public void setProxiable(boolean proxiable) {
        this.setOrClear(3, proxiable);
    }

    public void setAllowPostdate(boolean allowPostdate) {
        this.setOrClear(5, allowPostdate);
    }

    public void setPostdated(boolean postdated) {
        this.setOrClear(6, postdated);
    }

    public void setRenewableOk(boolean renewableOk) {
        this.setOrClear(27, renewableOk);
    }

    public void setRenewable(boolean renewable) {
        this.setOrClear(8, renewable);
    }

    public KdcOptions getOptions() {
        return this.options;
    }

    public boolean isPreAuthEnabled() {
        return this.preAuthEnabled;
    }

    public void setPreAuthEnabled(boolean preAuthEnabled) {
        this.preAuthEnabled = preAuthEnabled;
    }

    public String getSName() {
        return KdcClientUtil.extractName(this.serverPrincipal);
    }

    public String getCName() {
        return KdcClientUtil.extractName(this.clientPrincipal);
    }

    public Set<EncryptionType> getETypes() {
        return this.eTypes;
    }

    public void setETypes(Set<EncryptionType> eTypes) {
        this.eTypes = eTypes;
    }

    private void setOrClear(int pos, boolean set) {
        if (set) {
            this.options.setBit(pos);
        } else {
            this.options.clearBit(pos);
        }
    }
}

