/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.credentials.cache;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.kerberos.credentials.cache.Credentials;
import org.apache.directory.kerberos.credentials.cache.CredentialsCache;
import org.apache.directory.kerberos.credentials.cache.Tag;
import org.apache.directory.server.kerberos.protocol.codec.KerberosEncoder;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.components.AuthorizationData;
import org.apache.directory.shared.kerberos.components.AuthorizationDataEntry;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.HostAddress;
import org.apache.directory.shared.kerberos.components.HostAddresses;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.messages.Ticket;

public class CacheOutputStream
extends DataOutputStream {
    public CacheOutputStream(OutputStream out) {
        super(out);
    }

    public void write(CredentialsCache credCache) throws IOException {
        int writeVersion = 1283;
        this.writeVersion(writeVersion);
        if (writeVersion == 1284) {
            this.writeTags(credCache.getTags());
        }
        this.writePrincipal(credCache.getPrimaryPrincipalName(), writeVersion);
        List<Credentials> credentialsList = credCache.getCredsList();
        if (credentialsList != null) {
            for (Credentials cred : credentialsList) {
                this.writeCredentials(cred, writeVersion);
            }
        }
    }

    private void writeVersion(int version) throws IOException {
        this.writeShort(version);
    }

    private void writeTags(List<Tag> tags) throws IOException {
        int length = 0;
        if (tags != null) {
            for (Tag tag : tags) {
                if (tag.tag != 1) continue;
                length += tag.length;
            }
        }
        this.writeShort(length);
        if (tags != null) {
            for (Tag tag : tags) {
                if (tag.tag != 1) continue;
                this.writeTag(tag);
            }
        }
    }

    private void writeTag(Tag tag) throws IOException {
        this.writeShort(tag.tag);
        this.writeShort(tag.length);
        this.writeInt(tag.time);
        this.writeInt(tag.usec);
    }

    private void writePrincipal(PrincipalName pname, int version) throws IOException {
        int num = pname.getNames().size();
        if (version != 1281) {
            this.writeInt(pname.getNameType().getValue());
        } else {
            ++num;
        }
        this.writeInt(num);
        if (pname.getRealm() != null) {
            byte[] realmBytes = null;
            realmBytes = pname.getRealm().getBytes();
            this.writeInt(realmBytes.length);
            this.write(realmBytes);
        } else {
            this.writeInt(0);
        }
        byte[] bytes = null;
        for (int i = 0; i < pname.getNames().size(); ++i) {
            bytes = ((String)pname.getNames().get(i)).getBytes();
            this.writeInt(bytes.length);
            this.write(bytes);
        }
    }

    private void writeCredentials(Credentials creds, int version) throws IOException {
        this.writePrincipal(creds.getClientName(), version);
        this.writePrincipal(creds.getServerName(), version);
        this.writeKey(creds.getKey(), version);
        this.writeKerberosTime(creds.getAuthTime());
        this.writeKerberosTime(creds.getStartTime());
        this.writeKerberosTime(creds.getEndTime());
        this.writeKerberosTime(creds.getRenewTill());
        this.writeByte(creds.isEncInSKey() ? 1 : 0);
        this.writeInt(creds.getFlags().getIntValue());
        this.writeAddrs(creds.getClientAddresses());
        this.writeAuth(creds.getAuthzData());
        this.writeTicket(creds.getTicket());
        this.writeTicket(creds.getSecondTicket());
    }

    private void writeKerberosTime(KerberosTime ktime) throws IOException {
        int time = 0;
        if (ktime != null) {
            time = (int)(ktime.getTime() / 1000L);
        }
        this.writeInt(time);
    }

    private void writeKey(EncryptionKey key, int version) throws IOException {
        this.writeShort(key.getKeyType().getValue());
        if (version == 1283) {
            this.writeShort(key.getKeyType().getValue());
        }
        this.writeInt(key.getKeyValue().length);
        this.write(key.getKeyValue());
    }

    private void writeAddrs(HostAddresses addresses) throws IOException {
        if (addresses == null) {
            this.writeInt(0);
        } else {
            HostAddress[] addrs = addresses.getAddresses();
            this.write(addrs.length);
            for (int i = 0; i < addrs.length; ++i) {
                this.write(addrs[i].getAddrType().getValue());
                this.write(addrs[i].getAddress().length);
                this.write(addrs[i].getAddress(), 0, addrs[i].getAddress().length);
            }
        }
    }

    private void writeAuth(AuthorizationData authData) throws IOException {
        if (authData == null) {
            this.writeInt(0);
        } else {
            for (AuthorizationDataEntry ade : authData.getAuthorizationData()) {
                this.write(ade.getAdType().getValue());
                this.write(ade.getAdData().length);
                this.write(ade.getAdData());
            }
        }
    }

    private void writeTicket(Ticket t) throws IOException {
        if (t == null) {
            this.writeInt(0);
        } else {
            byte[] bytes = KerberosEncoder.encode((Asn1Object)t, (boolean)false).array();
            this.writeInt(bytes.length);
            this.write(bytes);
        }
    }
}

