/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.credentials.cache;

import java.text.ParseException;
import org.apache.directory.kerberos.client.AbstractTicket;
import org.apache.directory.kerberos.client.TgTicket;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.types.PrincipalNameType;
import org.apache.directory.shared.kerberos.components.AuthorizationData;
import org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.HostAddresses;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.flags.TicketFlags;
import org.apache.directory.shared.kerberos.messages.Ticket;

public class Credentials {
    private PrincipalName clientName;
    private String clientRealm;
    private PrincipalName serverName;
    private String serverRealm;
    private EncryptionKey key;
    private KerberosTime authTime;
    private KerberosTime startTime;
    private KerberosTime endTime;
    private KerberosTime renewTill;
    private HostAddresses clientAddresses;
    private AuthorizationData authzData;
    private boolean isEncInSKey;
    private TicketFlags flags;
    private Ticket ticket;
    private Ticket secondTicket;

    public Credentials(PrincipalName cname, PrincipalName sname, EncryptionKey ekey, KerberosTime authtime, KerberosTime starttime, KerberosTime endtime, KerberosTime renewTill, boolean isEncInSKey, TicketFlags flags, HostAddresses caddr, AuthorizationData authData, Ticket ticket, Ticket secondTicket) {
        this.clientName = cname;
        if (cname.getRealm() != null) {
            this.clientRealm = cname.getRealm();
        }
        this.serverName = sname;
        if (sname.getRealm() != null) {
            this.serverRealm = sname.getRealm();
        }
        this.key = ekey;
        this.authTime = authtime;
        this.startTime = starttime;
        this.endTime = endtime;
        this.renewTill = renewTill;
        this.clientAddresses = caddr;
        this.authzData = authData;
        this.isEncInSKey = isEncInSKey;
        this.flags = flags;
        this.ticket = ticket;
        this.secondTicket = secondTicket;
    }

    public Credentials(TgTicket tgt) {
        PrincipalName clientPrincipal = null;
        try {
            clientPrincipal = new PrincipalName(tgt.getClientName(), PrincipalNameType.KRB_NT_PRINCIPAL);
        }
        catch (ParseException e) {
            throw new RuntimeException("Invalid tgt with bad client name");
        }
        clientPrincipal.setRealm(tgt.getRealm());
        this.init(tgt, clientPrincipal);
    }

    public Credentials(AbstractTicket tkt, PrincipalName clientPrincipal) {
        this.init(tkt, clientPrincipal);
    }

    private void init(AbstractTicket tkt, PrincipalName clientPrincipal) {
        EncKdcRepPart kdcRepPart = tkt.getEncKdcRepPart();
        this.serverName = kdcRepPart.getSName();
        this.serverRealm = kdcRepPart.getSRealm();
        this.serverName.setRealm(this.serverRealm);
        this.clientName = clientPrincipal;
        this.key = kdcRepPart.getKey();
        this.authTime = kdcRepPart.getAuthTime();
        this.startTime = kdcRepPart.getStartTime();
        this.endTime = kdcRepPart.getEndTime();
        this.renewTill = kdcRepPart.getRenewTill();
        this.flags = kdcRepPart.getFlags();
        this.clientAddresses = kdcRepPart.getClientAddresses();
        this.ticket = tkt.getTicket();
        this.isEncInSKey = false;
        this.secondTicket = null;
    }

    public PrincipalName getServicePrincipal() {
        return this.serverName;
    }

    public KerberosTime getAuthTime() {
        return this.authTime;
    }

    public KerberosTime getEndTime() {
        return this.endTime;
    }

    public TicketFlags getTicketFlags() {
        return this.flags;
    }

    public int getEType() {
        return this.key.getKeyType().getValue();
    }

    public PrincipalName getClientName() {
        return this.clientName;
    }

    public PrincipalName getServerName() {
        return this.serverName;
    }

    public String getClientRealm() {
        return this.clientRealm;
    }

    public EncryptionKey getKey() {
        return this.key;
    }

    public KerberosTime getStartTime() {
        return this.startTime;
    }

    public KerberosTime getRenewTill() {
        return this.renewTill;
    }

    public HostAddresses getClientAddresses() {
        return this.clientAddresses;
    }

    public AuthorizationData getAuthzData() {
        return this.authzData;
    }

    public boolean isEncInSKey() {
        return this.isEncInSKey;
    }

    public TicketFlags getFlags() {
        return this.flags;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public Ticket getSecondTicket() {
        return this.secondTicket;
    }
}

