/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.client;

import org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.messages.Ticket;

public abstract class AbstractTicket {
    protected Ticket ticket;
    protected EncKdcRepPart encKdcRepPart;

    public AbstractTicket(Ticket ticket, EncKdcRepPart encKdcRepPart) {
        this.ticket = ticket;
        this.encKdcRepPart = encKdcRepPart;
    }

    public EncKdcRepPart getEncKdcRepPart() {
        return this.encKdcRepPart;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public EncryptionKey getSessionKey() {
        return this.encKdcRepPart.getKey();
    }

    public long getStartTime() {
        return this.encKdcRepPart.getStartTime().getTime();
    }

    public long getExpiryTime() {
        return this.encKdcRepPart.getEndTime().getTime();
    }

    public boolean isForwardable() {
        return this.encKdcRepPart.getFlags().isForwardable();
    }
}

