/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.client;

import java.io.IOException;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.text.ParseException;
import java.util.List;
import org.apache.directory.api.asn1.Asn1Object;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.api.util.Strings;
import org.apache.directory.kerberos.client.ChangePasswordResult;
import org.apache.directory.kerberos.client.KdcClientUtil;
import org.apache.directory.kerberos.client.KdcConfig;
import org.apache.directory.kerberos.client.KerberosChannel;
import org.apache.directory.kerberos.client.ServiceTicket;
import org.apache.directory.kerberos.client.ServiceTicketRequest;
import org.apache.directory.kerberos.client.TgTicket;
import org.apache.directory.kerberos.client.TgtRequest;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswdErrorType;
import org.apache.directory.server.kerberos.changepwd.exceptions.ChangePasswordException;
import org.apache.directory.server.kerberos.changepwd.io.ChangePasswordDecoder;
import org.apache.directory.server.kerberos.changepwd.io.ChangePasswordEncoder;
import org.apache.directory.server.kerberos.changepwd.messages.AbstractPasswordMessage;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordError;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordReply;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordRequest;
import org.apache.directory.server.kerberos.protocol.codec.KerberosDecoder;
import org.apache.directory.server.kerberos.protocol.codec.KerberosEncoder;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.server.kerberos.shared.crypto.encryption.RandomKeyFactory;
import org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.directory.shared.kerberos.codec.KerberosMessageContainer;
import org.apache.directory.shared.kerberos.codec.options.ApOptions;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.codec.types.PaDataType;
import org.apache.directory.shared.kerberos.codec.types.PrincipalNameType;
import org.apache.directory.shared.kerberos.components.EncKdcRepPart;
import org.apache.directory.shared.kerberos.components.EncKrbPrivPart;
import org.apache.directory.shared.kerberos.components.EncryptedData;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.components.HostAddress;
import org.apache.directory.shared.kerberos.components.HostAddresses;
import org.apache.directory.shared.kerberos.components.KdcReqBody;
import org.apache.directory.shared.kerberos.components.PaData;
import org.apache.directory.shared.kerberos.components.PaEncTsEnc;
import org.apache.directory.shared.kerberos.components.PrincipalName;
import org.apache.directory.shared.kerberos.exceptions.ErrorType;
import org.apache.directory.shared.kerberos.exceptions.KerberosException;
import org.apache.directory.shared.kerberos.messages.ApReq;
import org.apache.directory.shared.kerberos.messages.AsRep;
import org.apache.directory.shared.kerberos.messages.AsReq;
import org.apache.directory.shared.kerberos.messages.Authenticator;
import org.apache.directory.shared.kerberos.messages.ChangePasswdData;
import org.apache.directory.shared.kerberos.messages.EncAsRepPart;
import org.apache.directory.shared.kerberos.messages.EncTgsRepPart;
import org.apache.directory.shared.kerberos.messages.KerberosMessage;
import org.apache.directory.shared.kerberos.messages.KrbError;
import org.apache.directory.shared.kerberos.messages.KrbPriv;
import org.apache.directory.shared.kerberos.messages.TgsRep;
import org.apache.directory.shared.kerberos.messages.TgsReq;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KdcConnection {
    private static final Logger LOG = LoggerFactory.getLogger(KdcConnection.class);
    private SecureRandom nonceGenerator;
    static final String TIME_OUT_ERROR = "TimeOut occured";
    private CipherTextHandler cipherTextHandler;
    private KerberosChannel channel;
    private KdcConfig config;

    public KdcConnection(KdcConfig config) {
        this.config = config;
        this.nonceGenerator = new SecureRandom(String.valueOf(System.currentTimeMillis()).getBytes());
        this.cipherTextHandler = new CipherTextHandler();
        this.channel = new KerberosChannel();
    }

    private void connect() throws IOException {
        this.channel.openConnection(this.config.getHostName(), this.config.getKdcPort(), this.config.getTimeout(), this.config.isUseUdp());
    }

    public TgTicket getTgt(String principal, String password) throws Exception {
        TgtRequest clientTgtReq = new TgtRequest();
        clientTgtReq.setClientPrincipal(principal);
        clientTgtReq.setPassword(password);
        return this.getTgt(clientTgtReq);
    }

    public ServiceTicket getServiceTicket(String clientPrincipal, String password, String serverPrincipal) throws KerberosException {
        TgtRequest clientTgtReq = new TgtRequest();
        clientTgtReq.setClientPrincipal(clientPrincipal);
        clientTgtReq.setPassword(password);
        TgTicket tgt = this.getTgt(clientTgtReq);
        return this.getServiceTicket(new ServiceTicketRequest(tgt, serverPrincipal));
    }

    public TgTicket getTgt(TgtRequest clientTgtReq) throws KerberosException {
        TgTicket tgt = null;
        KerberosException ke = null;
        for (int i = 0; i < 2; ++i) {
            ke = null;
            try {
                tgt = this._getTgt(clientTgtReq);
            }
            catch (KerberosException e) {
                ke = e;
            }
            if (ke == null || ke.getErrorCode() != ErrorType.KDC_ERR_PREAUTH_REQUIRED.getValue()) continue;
            clientTgtReq.setETypes(KdcClientUtil.getEtypesFromError(ke.getError()));
            clientTgtReq.setPreAuthEnabled(true);
        }
        if (ke != null) {
            throw ke;
        }
        return tgt;
    }

    TgTicket _getTgt(TgtRequest clientTgtReq) throws KerberosException {
        String realm = clientTgtReq.getRealm();
        if (clientTgtReq.getServerPrincipal() == null) {
            String serverPrincipal = "krbtgt/" + realm + "@" + realm;
            clientTgtReq.setServerPrincipal(serverPrincipal);
        }
        if (clientTgtReq.getETypes() == null) {
            clientTgtReq.setETypes(this.config.getEncryptionTypes());
        }
        KdcReqBody body = new KdcReqBody();
        body.setFrom(new KerberosTime(clientTgtReq.getStartTime()));
        PrincipalName cName = null;
        try {
            cName = new PrincipalName(clientTgtReq.getCName(), PrincipalNameType.KRB_NT_PRINCIPAL);
            body.setCName(cName);
            body.setRealm(realm);
            PrincipalName sName = new PrincipalName(clientTgtReq.getSName(), PrincipalNameType.KRB_NT_SRV_INST);
            body.setSName(sName);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Couldn't parse the given principals", e);
        }
        body.setTill(new KerberosTime(clientTgtReq.getExpiryTime()));
        int currentNonce = this.nonceGenerator.nextInt();
        body.setNonce(currentNonce);
        body.setEType(clientTgtReq.getETypes());
        body.setKdcOptions(clientTgtReq.getOptions());
        List<HostAddress> lstAddresses = clientTgtReq.getHostAddresses();
        if (!lstAddresses.isEmpty()) {
            HostAddresses addresses = new HostAddresses();
            for (HostAddress h : lstAddresses) {
                addresses.addHostAddress(h);
            }
            body.setAddresses(addresses);
        }
        EncryptionType encryptionType = clientTgtReq.getETypes().iterator().next();
        EncryptionKey clientKey = KerberosKeyFactory.string2Key((String)clientTgtReq.getClientPrincipal(), (String)clientTgtReq.getPassword(), (EncryptionType)encryptionType);
        AsReq req = new AsReq();
        req.setKdcReqBody(body);
        if (clientTgtReq.isPreAuthEnabled()) {
            PaEncTsEnc tmstmp = new PaEncTsEnc();
            tmstmp.setPaTimestamp(new KerberosTime());
            EncryptedData paDataValue = this.cipherTextHandler.encrypt(clientKey, this.getEncoded((Asn1Object)tmstmp), KeyUsage.AS_REQ_PA_ENC_TIMESTAMP_WITH_CKEY);
            PaData paEncTstmp = new PaData();
            paEncTstmp.setPaDataType(PaDataType.PA_ENC_TIMESTAMP);
            paEncTstmp.setPaDataValue(this.getEncoded((Asn1Object)paDataValue));
            req.addPaData(paEncTstmp);
        }
        try {
            TgTicket tgTicket;
            this.connect();
            KerberosMessage kdcRep = this.sendAndReceiveKrbMsg((KerberosMessage)req);
            if (kdcRep == null) {
                LOG.error("Authentication failed : timeout occured");
                throw new KerberosException(ErrorType.KRB_ERR_GENERIC, TIME_OUT_ERROR);
            }
            if (kdcRep instanceof KrbError) {
                LOG.debug("Authentication failed : {}", (Object)kdcRep);
                throw new KerberosException((KrbError)kdcRep);
            }
            AsRep rep = (AsRep)kdcRep;
            if (!cName.getNameString().equals(rep.getCName().getNameString())) {
                throw new KerberosException(ErrorType.KDC_ERR_CLIENT_NAME_MISMATCH);
            }
            if (!realm.equals(rep.getCRealm())) {
                throw new KerberosException(ErrorType.KRB_ERR_WRONG_REALM);
            }
            if (encryptionType != rep.getEncPart().getEType()) {
                encryptionType = rep.getEncPart().getEType();
                clientKey = KerberosKeyFactory.string2Key((String)clientTgtReq.getClientPrincipal(), (String)clientTgtReq.getPassword(), (EncryptionType)encryptionType);
            }
            byte[] decryptedEncAsRepPart = this.cipherTextHandler.decrypt(clientKey, rep.getEncPart(), KeyUsage.AS_REP_ENC_PART_WITH_CKEY);
            EncKdcRepPart encKdcRepPart = null;
            try {
                EncAsRepPart encAsRepPart = KerberosDecoder.decodeEncAsRepPart((byte[])decryptedEncAsRepPart);
                encKdcRepPart = encAsRepPart.getEncKdcRepPart();
            }
            catch (KerberosException e) {
                LOG.info("Trying an encTgsRepPart instead");
                EncTgsRepPart encTgsRepPart = KerberosDecoder.decodeEncTgsRepPart((byte[])decryptedEncAsRepPart);
                encKdcRepPart = encTgsRepPart.getEncKdcRepPart();
            }
            if (currentNonce != encKdcRepPart.getNonce()) {
                throw new KerberosException(ErrorType.KRB_ERR_GENERIC, "received nonce didn't match with the nonce sent in the request");
            }
            if (!encKdcRepPart.getSName().getNameString().equals(clientTgtReq.getSName())) {
                throw new KerberosException(ErrorType.KDC_ERR_SERVER_NOMATCH);
            }
            if (!encKdcRepPart.getSRealm().equals(clientTgtReq.getRealm())) {
                throw new KerberosException(ErrorType.KRB_ERR_GENERIC, "received server realm does not match with requested server realm");
            }
            List<HostAddress> hosts = clientTgtReq.getHostAddresses();
            if (!hosts.isEmpty()) {
                HostAddresses addresses = encKdcRepPart.getClientAddresses();
                for (HostAddress h : hosts) {
                    if (addresses.contains(h)) continue;
                    throw new KerberosException(ErrorType.KRB_ERR_GENERIC, "requested client address" + h + " is not found in the ticket");
                }
            }
            LOG.debug("Authentication successful : {}", (Object)kdcRep);
            TgTicket tgTicket2 = tgTicket = new TgTicket(rep.getTicket(), encKdcRepPart, rep.getCName().getNameString());
            return tgTicket2;
        }
        catch (KerberosException ke) {
            throw ke;
        }
        catch (Exception e) {
            LOG.error("Authentication failed");
            throw new KerberosException(ErrorType.KRB_ERR_GENERIC, TIME_OUT_ERROR);
        }
        finally {
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close the channel", (Throwable)e);
                }
            }
        }
    }

    private ServiceTicket getServiceTicket(ServiceTicketRequest srvTktReq) throws KerberosException {
        String serverPrincipal = srvTktReq.getServerPrincipal();
        EncryptionKey sessionKey = srvTktReq.getTgt().getSessionKey();
        Authenticator authenticator = new Authenticator();
        try {
            authenticator.setCName(new PrincipalName(srvTktReq.getTgt().getClientName(), PrincipalNameType.KRB_NT_PRINCIPAL));
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Couldn't parse the given principal", e);
        }
        authenticator.setCRealm(srvTktReq.getTgt().getRealm());
        authenticator.setCTime(new KerberosTime());
        authenticator.setCusec(0);
        if (srvTktReq.getSubSessionKey() != null) {
            sessionKey = srvTktReq.getSubSessionKey();
            authenticator.setSubKey(sessionKey);
        }
        EncryptedData authnData = this.cipherTextHandler.encrypt(sessionKey, this.getEncoded((Asn1Object)authenticator), KeyUsage.TGS_REQ_PA_TGS_REQ_PADATA_AP_REQ_TGS_SESS_KEY);
        ApReq apReq = new ApReq();
        apReq.setAuthenticator(authnData);
        apReq.setTicket(srvTktReq.getTgt().getTicket());
        apReq.setApOptions(srvTktReq.getApOptions());
        KdcReqBody tgsReqBody = new KdcReqBody();
        tgsReqBody.setKdcOptions(srvTktReq.getKdcOptions());
        tgsReqBody.setRealm(KdcClientUtil.extractRealm(serverPrincipal));
        tgsReqBody.setTill(this.getDefaultTill());
        int currentNonce = this.nonceGenerator.nextInt();
        tgsReqBody.setNonce(currentNonce);
        tgsReqBody.setEType(this.config.getEncryptionTypes());
        PrincipalName principalName = new PrincipalName(KdcClientUtil.extractName(serverPrincipal), 3);
        tgsReqBody.setSName(principalName);
        TgsReq tgsReq = new TgsReq();
        tgsReq.setKdcReqBody(tgsReqBody);
        PaData authnHeader = new PaData();
        authnHeader.setPaDataType(PaDataType.PA_TGS_REQ);
        authnHeader.setPaDataValue(this.getEncoded((Asn1Object)apReq));
        tgsReq.addPaData(authnHeader);
        try {
            ServiceTicket srvTkt;
            this.connect();
            KerberosMessage kdcRep = this.sendAndReceiveKrbMsg((KerberosMessage)tgsReq);
            if (kdcRep == null) {
                LOG.error("TGT request failed : timeout occured");
                throw new KerberosException(ErrorType.KRB_ERR_GENERIC, TIME_OUT_ERROR);
            }
            if (kdcRep instanceof KrbError) {
                LOG.debug("TGT request failed : {}", (Object)kdcRep);
                throw new KerberosException((KrbError)kdcRep);
            }
            TgsRep rep = (TgsRep)kdcRep;
            byte[] decryptedData = this.cipherTextHandler.decrypt(sessionKey, rep.getEncPart(), KeyUsage.TGS_REP_ENC_PART_TGS_SESS_KEY);
            EncTgsRepPart encTgsRepPart = KerberosDecoder.decodeEncTgsRepPart((byte[])decryptedData);
            if (currentNonce != encTgsRepPart.getEncKdcRepPart().getNonce()) {
                throw new KerberosException(ErrorType.KRB_ERR_GENERIC, "received nonce didn't match with the nonce sent in the request");
            }
            LOG.debug("TGT request successful : {}", (Object)rep);
            ServiceTicket serviceTicket = srvTkt = new ServiceTicket(rep.getTicket(), encTgsRepPart.getEncKdcRepPart());
            return serviceTicket;
        }
        catch (KerberosException e) {
            throw e;
        }
        catch (Exception te) {
            LOG.error("TGT request failed : timeout occured");
            throw new KerberosException(ErrorType.KRB_ERR_GENERIC, TIME_OUT_ERROR);
        }
        finally {
            if (this.channel != null) {
                try {
                    this.channel.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close the channel", (Throwable)e);
                }
            }
        }
    }

    public ChangePasswordResult changePassword(String clientPrincipal, String oldPassword, String newPassword) throws ChangePasswordException {
        KerberosChannel channel = null;
        try {
            ChangePasswordResult result;
            TgtRequest clientTgtReq = new TgtRequest();
            clientTgtReq.setClientPrincipal(clientPrincipal);
            clientTgtReq.setPassword(oldPassword);
            clientTgtReq.setServerPrincipal("kadmin/changepw@" + KdcClientUtil.extractRealm(clientPrincipal));
            TgTicket tgt = this.getTgt(clientTgtReq);
            ApReq apReq = new ApReq();
            ApOptions options = new ApOptions();
            apReq.setApOptions(options);
            apReq.setTicket(tgt.getTicket());
            Authenticator authenticator = new Authenticator();
            authenticator.setCName(new PrincipalName(tgt.getClientName(), PrincipalNameType.KRB_NT_PRINCIPAL));
            authenticator.setCRealm(tgt.getRealm());
            KerberosTime ctime = new KerberosTime();
            authenticator.setCTime(ctime);
            authenticator.setCusec(0);
            authenticator.setSeqNumber(this.nonceGenerator.nextInt());
            EncryptionKey subKey = RandomKeyFactory.getRandomKey((EncryptionType)tgt.getEncKdcRepPart().getKey().getKeyType());
            authenticator.setSubKey(subKey);
            EncryptedData authData = this.cipherTextHandler.encrypt(tgt.getSessionKey(), this.getEncoded((Asn1Object)authenticator), KeyUsage.AP_REQ_AUTHNT_SESS_KEY);
            apReq.setAuthenticator(authData);
            KrbPriv privateMessage = new KrbPriv();
            EncKrbPrivPart part = new EncKrbPrivPart();
            part.setSenderAddress(new HostAddress(InetAddress.getLocalHost()));
            part.setSeqNumber(authenticator.getSeqNumber().intValue());
            part.setTimestamp(authenticator.getCtime());
            short changePwdPVNO = -128;
            if (this.config.isUseLegacyChngPwdProtocol()) {
                part.setUserData(Strings.getBytesUtf8((String)newPassword));
                changePwdPVNO = 1;
            } else {
                ChangePasswdData chngPwdData = new ChangePasswdData();
                chngPwdData.setNewPasswd(Strings.getBytesUtf8((String)newPassword));
                byte[] data = this.getEncoded((Asn1Object)chngPwdData);
                part.setUserData(data);
            }
            EncryptedData encKrbPrivPartData = this.cipherTextHandler.encrypt(subKey, this.getEncoded((Asn1Object)part), KeyUsage.KRB_PRIV_ENC_PART_CHOSEN_KEY);
            privateMessage.setEncPart(encKrbPrivPartData);
            ChangePasswordRequest req = new ChangePasswordRequest(changePwdPVNO, apReq, privateMessage);
            channel = new KerberosChannel();
            channel.openConnection(this.config.getHostName(), this.config.getPasswdPort(), this.config.getTimeout(), this.config.isUseUdp());
            AbstractPasswordMessage reply = this.sendAndReceiveChngPwdMsg((AbstractPasswordMessage)req, channel);
            if (reply instanceof ChangePasswordError) {
                ChangePasswordResult result2;
                ChangePasswordError err = (ChangePasswordError)reply;
                ChangePasswordResult changePasswordResult = result2 = new ChangePasswordResult(err.getKrbError().getEData());
                return changePasswordResult;
            }
            ChangePasswordReply chngPwdReply = (ChangePasswordReply)reply;
            KrbPriv replyPriv = chngPwdReply.getPrivateMessage();
            byte[] data = this.cipherTextHandler.decrypt(subKey, replyPriv.getEncPart(), KeyUsage.KRB_PRIV_ENC_PART_CHOSEN_KEY);
            part = KerberosDecoder.decodeEncKrbPrivPart((byte[])data);
            ChangePasswordResult changePasswordResult = result = new ChangePasswordResult(part.getUserData());
            return changePasswordResult;
        }
        catch (ChangePasswordException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.warn("failed to change the password", (Throwable)e);
            throw new ChangePasswordException(ChangePasswdErrorType.KRB5_KPASSWD_HARDERROR, (Throwable)e);
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close the channel", (Throwable)e);
                }
            }
        }
    }

    private byte[] getEncoded(Asn1Object obj) {
        try {
            ByteBuffer buf = ByteBuffer.allocate(obj.computeLength());
            obj.encode(buf);
            return buf.array();
        }
        catch (Exception e) {
            LOG.error("Failed to encode the ASN.1 object {}", (Object)obj);
            throw new RuntimeException(e);
        }
    }

    private KerberosTime getDefaultTill() {
        return new KerberosTime(System.currentTimeMillis() + 3600000L);
    }

    private KerberosMessage sendAndReceiveKrbMsg(KerberosMessage req) throws Exception {
        ByteBuffer encodedBuf = KerberosEncoder.encode((Asn1Object)req, (boolean)this.channel.isUseTcp());
        encodedBuf.flip();
        ByteBuffer repData = this.channel.sendAndReceive(encodedBuf);
        KerberosMessageContainer kerberosMessageContainer = new KerberosMessageContainer();
        kerberosMessageContainer.setStream(repData);
        kerberosMessageContainer.setGathering(true);
        kerberosMessageContainer.setTCP(this.channel.isUseTcp());
        return (KerberosMessage)KerberosDecoder.decode((KerberosMessageContainer)kerberosMessageContainer, (Asn1Decoder)new Asn1Decoder());
    }

    private AbstractPasswordMessage sendAndReceiveChngPwdMsg(AbstractPasswordMessage req, KerberosChannel chngPwdChannel) throws Exception {
        ByteBuffer encodedBuf = ChangePasswordEncoder.encode((AbstractPasswordMessage)req, (boolean)chngPwdChannel.isUseTcp());
        encodedBuf.flip();
        ByteBuffer repData = chngPwdChannel.sendAndReceive(encodedBuf);
        return ChangePasswordDecoder.decode((ByteBuffer)repData, (boolean)chngPwdChannel.isUseTcp());
    }
}

