/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.kerberos.client;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.ber.Asn1Decoder;
import org.apache.directory.server.kerberos.changepwd.io.ChangePasswordDecoder;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordReply;
import org.apache.directory.server.kerberos.changepwd.messages.ChangePasswordRequest;
import org.apache.directory.server.kerberos.protocol.codec.KerberosDecoder;
import org.apache.directory.server.kerberos.shared.crypto.encryption.CipherTextHandler;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KerberosKeyFactory;
import org.apache.directory.server.kerberos.shared.crypto.encryption.KeyUsage;
import org.apache.directory.shared.kerberos.codec.KerberosMessageContainer;
import org.apache.directory.shared.kerberos.codec.types.EncryptionType;
import org.apache.directory.shared.kerberos.components.EncKrbPrivPart;
import org.apache.directory.shared.kerberos.components.EncryptionKey;
import org.apache.directory.shared.kerberos.messages.ApRep;
import org.apache.directory.shared.kerberos.messages.ApReq;
import org.apache.directory.shared.kerberos.messages.AsRep;
import org.apache.directory.shared.kerberos.messages.Authenticator;
import org.apache.directory.shared.kerberos.messages.EncAsRepPart;
import org.apache.directory.shared.kerberos.messages.KrbPriv;

public abstract class KpasswdDecode {
    private CipherTextHandler cipherTextHandler = new CipherTextHandler();
    private EncryptionKey clientKey;
    private EncryptionKey sessionKey;
    private EncryptionKey subSessionKey;

    public KpasswdDecode(String principal, String password, EncryptionType eType) {
        this.clientKey = KerberosKeyFactory.string2Key((String)principal, (String)password, (EncryptionType)eType);
    }

    public void decodeAsRep(byte[] asReppkt) throws Exception {
        ByteBuffer repData = ByteBuffer.wrap(asReppkt);
        KerberosMessageContainer kerberosMessageContainer = new KerberosMessageContainer();
        kerberosMessageContainer.setStream(repData);
        kerberosMessageContainer.setGathering(true);
        kerberosMessageContainer.setTCP(false);
        AsRep asReply = (AsRep)KerberosDecoder.decode((KerberosMessageContainer)kerberosMessageContainer, (Asn1Decoder)new Asn1Decoder());
        System.out.println(asReply);
        byte[] decryptedEncAsRepPart = this.cipherTextHandler.decrypt(this.clientKey, asReply.getEncPart(), KeyUsage.AS_REP_ENC_PART_WITH_CKEY);
        byte[] tmp = new byte[182];
        System.arraycopy(decryptedEncAsRepPart, 0, tmp, 0, 182);
        EncAsRepPart encAsRepPart = KerberosDecoder.decodeEncAsRepPart((byte[])tmp);
        this.sessionKey = encAsRepPart.getEncKdcRepPart().getKey();
    }

    public void decodeApReq(byte[] kpasswdApReqpkt) throws Exception {
        ByteBuffer chngpwdReqData = ByteBuffer.wrap(kpasswdApReqpkt);
        ChangePasswordRequest chngPwdReq = (ChangePasswordRequest)ChangePasswordDecoder.decode((ByteBuffer)chngpwdReqData, (boolean)false);
        ApReq apReq = chngPwdReq.getAuthHeader();
        byte[] decryptedAuthenticator = this.cipherTextHandler.decrypt(this.sessionKey, apReq.getAuthenticator(), KeyUsage.AP_REQ_AUTHNT_SESS_KEY);
        Authenticator authenticator = KerberosDecoder.decodeAuthenticator((byte[])decryptedAuthenticator);
        this.subSessionKey = authenticator.getSubKey();
    }

    public void decodeApRep(byte[] kpasswdReplypkt) throws Exception {
        ByteBuffer chngpwdReplyData = ByteBuffer.wrap(kpasswdReplypkt);
        ChangePasswordReply chngPwdReply = (ChangePasswordReply)ChangePasswordDecoder.decode((ByteBuffer)chngpwdReplyData, (boolean)false);
        ApRep apRep = chngPwdReply.getApplicationReply();
        KrbPriv krbPriv = chngPwdReply.getPrivateMessage();
        byte[] decryptedKrbPrivPart = this.cipherTextHandler.decrypt(this.subSessionKey, krbPriv.getEncPart(), KeyUsage.KRB_PRIV_ENC_PART_CHOSEN_KEY);
        EncKrbPrivPart krbPrivPart = KerberosDecoder.decodeEncKrbPrivPart((byte[])decryptedKrbPrivPart);
        System.out.println(krbPrivPart);
    }
}

