/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import java.io.IOException;
import java.util.HashMap;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.GrammarTransition;
import org.apache.directory.shared.dsmlv2.IGrammar;
import org.apache.directory.shared.dsmlv2.IStates;
import org.apache.directory.shared.dsmlv2.Tag;
import org.apache.directory.shared.i18n.I18n;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractGrammar
implements IGrammar {
    protected HashMap<Tag, GrammarTransition>[] transitions;
    protected String name;
    protected IStates statesEnum;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GrammarTransition getTransition(int state, Tag tag) {
        return this.transitions[state].get(tag);
    }

    public IStates getStatesEnum() {
        return this.statesEnum;
    }

    public void setStatesEnum(IStates statesEnum) {
        this.statesEnum = statesEnum;
    }

    public void executeAction(Dsmlv2Container container) throws XmlPullParserException, IOException {
        XmlPullParser xpp = container.getParser();
        int eventType = xpp.getEventType();
        do {
            if (eventType == 0) {
                container.setState(0);
                continue;
            }
            if (eventType == 1) {
                container.setState(-1);
                continue;
            }
            if (eventType == 2) {
                this.processTag(container, Tag.START);
                continue;
            }
            if (eventType != 3) continue;
            this.processTag(container, Tag.END);
        } while ((eventType = xpp.next()) != 1);
    }

    private void processTag(Dsmlv2Container container, int tagType) throws XmlPullParserException {
        XmlPullParser xpp = container.getParser();
        String tagName = xpp.getName().toLowerCase();
        GrammarTransition transition = this.getTransition(container.getState(), new Tag(tagName, tagType));
        if (transition != null) {
            container.setState(transition.getNextState());
            if (transition.hasAction()) {
                transition.getAction().action(container);
            }
        } else {
            throw new XmlPullParserException(I18n.err((String)"ERR_03036", (Object[])new Object[]{new Tag(tagName, tagType)}), xpp, null);
        }
    }
}

