/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.dsmlv2;

import java.util.List;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.apache.directory.shared.dsmlv2.Dsmlv2Container;
import org.apache.directory.shared.dsmlv2.engine.Dsmlv2Engine;
import org.apache.directory.shared.dsmlv2.request.BatchRequest;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.util.Base64;
import org.apache.directory.shared.ldap.util.StringTools;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.DocumentResult;
import org.dom4j.io.DocumentSource;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParserUtils {
    public static final String XML_SCHEMA_URI = "http://www.w3c.org/2001/XMLSchema";
    public static final String XML_SCHEMA_INSTANCE_URI = "http://www.w3c.org/2001/XMLSchema-instance";
    public static final String BASE64BINARY = "base64Binary";
    public static final String XSI = "xsi";
    public static final String XSD = "xsd";

    public static String getXsiTypeAttributeValue(XmlPullParser xpp) {
        String type = null;
        int nbAttributes = xpp.getAttributeCount();
        for (int i = 0; i < nbAttributes; ++i) {
            if (!xpp.getAttributeName(i).equals("type") || !xpp.getNamespace(xpp.getAttributePrefix(i)).equals(XML_SCHEMA_INSTANCE_URI)) continue;
            type = xpp.getAttributeValue(i);
            break;
        }
        return type;
    }

    public static boolean isBase64BinaryValue(XmlPullParser parser, String attrValue) {
        if (attrValue == null) {
            return false;
        }
        String[] splitedString = attrValue.split(":");
        return splitedString.length == 2 && XML_SCHEMA_URI.equals(parser.getNamespace(splitedString[0])) && BASE64BINARY.equals(splitedString[1]);
    }

    public static boolean needsBase64Encoding(Object value) {
        if (value instanceof byte[]) {
            return true;
        }
        if (value instanceof String) {
            return !LdifUtils.isLDIFSafe((String)((String)value));
        }
        return true;
    }

    public static String base64Encode(Object value) {
        if (value instanceof byte[]) {
            return new String(Base64.encode((byte[])((byte[])value)));
        }
        if (value instanceof String) {
            return new String(Base64.encode((byte[])StringTools.getBytesUtf8((String)((String)value))));
        }
        return "";
    }

    public static int parseAndVerifyRequestID(String attributeValue, XmlPullParser xpp) throws XmlPullParserException {
        try {
            int requestID = Integer.parseInt(attributeValue);
            if (requestID == 0) {
                throw new XmlPullParserException(I18n.err((String)"ERR_03038", (Object[])new Object[0]), xpp, null);
            }
            return requestID;
        }
        catch (NumberFormatException e) {
            throw new XmlPullParserException(I18n.err((String)"ERR_03039", (Object[])new Object[0]), xpp, null);
        }
    }

    public static void addControls(Element element, List<Control> controls) {
        if (controls != null) {
            for (int i = 0; i < controls.size(); ++i) {
                byte[] value;
                Control control = controls.get(i);
                Element controlElement = element.addElement("control");
                if (control.getOid() != null) {
                    controlElement.addAttribute("type", control.getOid());
                }
                if (control.isCritical()) {
                    controlElement.addAttribute("criticality", "true");
                }
                if ((value = control.getValue()) == null) continue;
                if (ParserUtils.needsBase64Encoding(value)) {
                    Namespace xsdNamespace = new Namespace(XSD, XML_SCHEMA_URI);
                    Namespace xsiNamespace = new Namespace(XSI, XML_SCHEMA_INSTANCE_URI);
                    element.getDocument().getRootElement().add(xsdNamespace);
                    element.getDocument().getRootElement().add(xsiNamespace);
                    Element valueElement = controlElement.addElement("controlValue").addText(ParserUtils.base64Encode(value));
                    valueElement.addAttribute(new QName("type", xsiNamespace), "xsd:base64Binary");
                    continue;
                }
                controlElement.addElement("controlValue").setText((String)value);
            }
        }
    }

    public static boolean isRequestIdNeeded(Dsmlv2Container container) throws XmlPullParserException {
        BatchRequest batchRequest = container.getBatchRequest();
        if (batchRequest == null) {
            throw new XmlPullParserException(I18n.err((String)"ERR_03040", (Object[])new Object[0]), container.getParser(), null);
        }
        return batchRequest.getProcessing() == BatchRequest.Processing.PARALLEL && batchRequest.getResponseOrder() == BatchRequest.ResponseOrder.UNORDERED;
    }

    public static Document styleDocument(Document document) {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = factory.newTransformer(new StreamSource(Dsmlv2Engine.class.getResourceAsStream("DSMLv2.xslt")));
        }
        catch (TransformerConfigurationException e1) {
            e1.printStackTrace();
        }
        DocumentSource source = new DocumentSource(document);
        DocumentResult result = new DocumentResult();
        try {
            transformer.transform((Source)source, (Result)result);
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        Document transformedDoc = result.getDocument();
        return transformedDoc;
    }
}

