/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.DecoderCallback;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.MessageDecorator;
import org.apache.directory.shared.ldap.model.exception.ResponseCarryingMessageException;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapDecoder
implements ProtocolDecoder {
    private static Logger LOG = LoggerFactory.getLogger(LdapDecoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private LdapMessageContainer<MessageDecorator<? extends Message>> ldapMessageContainer;
    private DecoderCallback decoderCallback;
    private Asn1Decoder asn1Decoder = new Asn1Decoder();

    private void digest(InputStream in) throws DecoderException {
        try {
            byte[] buf;
            int amount;
            while (in.available() > 0 && (amount = in.read(buf = new byte[in.available()])) != -1) {
                this.asn1Decoder.decode(ByteBuffer.wrap(buf, 0, amount), this.ldapMessageContainer);
            }
        }
        catch (Exception e) {
            String message = I18n.err((I18n)I18n.ERR_04060, (Object[])new Object[]{e.getLocalizedMessage()});
            LOG.error(message);
            throw new DecoderException(message, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object decode(Object lock, InputStream in) throws DecoderException {
        if (lock == null) {
            this.digest(in);
            if (this.ldapMessageContainer.getState() == TLVStateEnum.PDU_DECODED) {
                if (IS_DEBUG) {
                    LOG.debug("Decoded LdapMessage : " + this.ldapMessageContainer.getMessage());
                }
                return this.ldapMessageContainer.getMessage();
            }
            LOG.error(I18n.err((I18n)I18n.ERR_04062, (Object[])new Object[0]));
            throw new DecoderException(I18n.err((I18n)I18n.ERR_04063, (Object[])new Object[0]));
        }
        try {
            Object object = lock;
            synchronized (object) {
                this.digest(in);
                lock.notifyAll();
            }
        }
        catch (Exception e) {
            String message = I18n.err((I18n)I18n.ERR_04060, (Object[])new Object[]{e.getLocalizedMessage()});
            LOG.error(message);
            throw new DecoderException(message, (Throwable)e);
        }
        if (this.ldapMessageContainer.getState() == TLVStateEnum.PDU_DECODED) {
            if (IS_DEBUG) {
                LOG.debug("Decoded LdapMessage : " + this.ldapMessageContainer.getMessage());
            }
            return this.ldapMessageContainer.getMessage();
        }
        LOG.error(I18n.err((I18n)I18n.ERR_04064, (Object[])new Object[0]));
        throw new DecoderException(I18n.err((I18n)I18n.ERR_04063, (Object[])new Object[0]));
    }

    public void setCallback(DecoderCallback cb) {
        this.decoderCallback = cb;
    }

    public DecoderCallback getCallback() {
        return this.decoderCallback;
    }

    public void decode(IoSession session, IoBuffer in, ProtocolDecoderOutput out) throws Exception {
        ByteBuffer buf = in.buf();
        LdapMessageContainer messageContainer = (LdapMessageContainer)((Object)session.getAttribute((Object)"messageContainer"));
        if (session.containsAttribute((Object)"maxPDUSize")) {
            int maxPDUSize = (Integer)session.getAttribute((Object)"maxPDUSize");
            messageContainer.setMaxPDUSize(maxPDUSize);
        }
        buf.mark();
        while (buf.hasRemaining()) {
            try {
                this.asn1Decoder.decode(buf, (Asn1Container)messageContainer);
                if (IS_DEBUG) {
                    LOG.debug("Decoding the PDU : ");
                    int size = buf.position();
                    buf.reset();
                    int position = buf.position();
                    int pduLength = size - position;
                    byte[] array = new byte[pduLength];
                    System.arraycopy(buf.array(), position, array, 0, pduLength);
                    buf.position(size);
                    if (array.length == 0) {
                        LOG.debug("NULL buffer, what the HELL ???");
                    } else {
                        LOG.debug(Strings.dumpBytes((byte[])array));
                    }
                }
                buf.mark();
                if (messageContainer.getState() != TLVStateEnum.PDU_DECODED) continue;
                if (IS_DEBUG) {
                    LOG.debug("Decoded LdapMessage : " + messageContainer.getMessage());
                }
                Object message = messageContainer.getMessage();
                out.write(message);
                messageContainer.clean();
            }
            catch (DecoderException de) {
                buf.clear();
                messageContainer.clean();
                if (de instanceof ResponseCarryingException) {
                    ResponseCarryingMessageException rcme = new ResponseCarryingMessageException(de.getMessage());
                    rcme.setResponse(((ResponseCarryingException)de).getResponse());
                    throw rcme;
                }
                throw new ResponseCarryingException(de.getMessage());
            }
        }
    }

    public void dispose(IoSession session) throws Exception {
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public void setLdapMessageContainer(LdapMessageContainer<MessageDecorator<? extends Message>> ldapMessageContainer) {
        this.ldapMessageContainer = ldapMessageContainer;
    }
}

