/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoder;
import org.apache.directory.shared.asn1.ber.tlv.BooleanDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.LongDecoder;
import org.apache.directory.shared.asn1.ber.tlv.LongDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.util.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.LdapStatesEnum;
import org.apache.directory.shared.ldap.codec.actions.AttributeDescAction;
import org.apache.directory.shared.ldap.codec.actions.ControlValueAction;
import org.apache.directory.shared.ldap.codec.actions.ControlsInitAction;
import org.apache.directory.shared.ldap.codec.actions.ErrorMessageAction;
import org.apache.directory.shared.ldap.codec.actions.InitAndFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitApproxMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAssertionValueFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAttributeDescFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitAttributeDescListAction;
import org.apache.directory.shared.ldap.codec.actions.InitEqualityMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitExtensibleMatchFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitGreaterOrEqualFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitLessOrEqualFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitNotFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitOrFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitPresentFilterAction;
import org.apache.directory.shared.ldap.codec.actions.InitReferralsAction;
import org.apache.directory.shared.ldap.codec.actions.InitSubstringsFilterAction;
import org.apache.directory.shared.ldap.codec.actions.MatchedDNAction;
import org.apache.directory.shared.ldap.codec.actions.ModifyAttributeValueAction;
import org.apache.directory.shared.ldap.codec.actions.ReferralAction;
import org.apache.directory.shared.ldap.codec.actions.ResponseAction;
import org.apache.directory.shared.ldap.codec.actions.ResponseNameAction;
import org.apache.directory.shared.ldap.codec.actions.ResultCodeAction;
import org.apache.directory.shared.ldap.codec.actions.SearchResultAttributeValueAction;
import org.apache.directory.shared.ldap.codec.actions.ServerSASLCredsAction;
import org.apache.directory.shared.ldap.codec.actions.StoreAnyAction;
import org.apache.directory.shared.ldap.codec.actions.StoreFinalAction;
import org.apache.directory.shared.ldap.codec.actions.StoreMatchValueAction;
import org.apache.directory.shared.ldap.codec.actions.StoreReferenceAction;
import org.apache.directory.shared.ldap.codec.actions.StoreTypeMatchingRuleAction;
import org.apache.directory.shared.ldap.codec.actions.ValueAction;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.shared.ldap.codec.decorators.AbandonRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.AddRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.AddResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.BindRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.BindResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.CompareRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.CompareResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.DeleteRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.DeleteResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ExtendedRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.IntermediateResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.MessageDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ModifyDnRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ModifyDnResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ModifyRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ModifyResponseDecorator;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultDoneDecorator;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultEntryDecorator;
import org.apache.directory.shared.ldap.codec.decorators.SearchResultReferenceDecorator;
import org.apache.directory.shared.ldap.codec.decorators.UnbindRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.model.filter.SearchScope;
import org.apache.directory.shared.ldap.model.message.AbandonRequest;
import org.apache.directory.shared.ldap.model.message.AbandonRequestImpl;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AddRequestImpl;
import org.apache.directory.shared.ldap.model.message.AddResponse;
import org.apache.directory.shared.ldap.model.message.AddResponseImpl;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.BindRequest;
import org.apache.directory.shared.ldap.model.message.BindRequestImpl;
import org.apache.directory.shared.ldap.model.message.BindResponse;
import org.apache.directory.shared.ldap.model.message.BindResponseImpl;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.model.message.CompareResponse;
import org.apache.directory.shared.ldap.model.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.model.message.DeleteResponse;
import org.apache.directory.shared.ldap.model.message.DeleteResponseImpl;
import org.apache.directory.shared.ldap.model.message.ExtendedRequest;
import org.apache.directory.shared.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.IntermediateResponse;
import org.apache.directory.shared.ldap.model.message.IntermediateResponseImpl;
import org.apache.directory.shared.ldap.model.message.LdapResult;
import org.apache.directory.shared.ldap.model.message.Message;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponse;
import org.apache.directory.shared.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.model.message.ModifyResponse;
import org.apache.directory.shared.ldap.model.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.model.message.Referral;
import org.apache.directory.shared.ldap.model.message.ReferralImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultDone;
import org.apache.directory.shared.ldap.model.message.SearchResultDoneImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultEntry;
import org.apache.directory.shared.ldap.model.message.SearchResultEntryImpl;
import org.apache.directory.shared.ldap.model.message.SearchResultReference;
import org.apache.directory.shared.ldap.model.message.SearchResultReferenceImpl;
import org.apache.directory.shared.ldap.model.message.UnbindRequest;
import org.apache.directory.shared.ldap.model.message.UnbindRequestImpl;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LdapMessageGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(LdapMessageGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar instance = new LdapMessageGrammar();

    private LdapMessageGrammar() {
        this.setName(LdapMessageGrammar.class.getName());
        this.transitions = new GrammarTransition[LdapStatesEnum.LAST_LDAP_STATE.ordinal()][256];
        this.transitions[LdapStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.START_STATE, (Enum)LdapStatesEnum.LDAP_MESSAGE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("LdapMessage initialization"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04066, (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04067, (Object[])new Object[0]));
                }
            }
        });
        this.transitions[LdapStatesEnum.LDAP_MESSAGE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.LDAP_MESSAGE_STATE, (Enum)LdapStatesEnum.MESSAGE_ID_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Store MessageId"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04068, (Object[])new Object[0]));
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04069, (Object[])new Object[0]));
                }
                Value value = tlv.getValue();
                try {
                    int messageId = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                    container.setMessageId(messageId);
                    if (IS_DEBUG) {
                        LOG.debug("Ldap Message Id has been decoded : " + messageId);
                    }
                }
                catch (IntegerDecoderException ide) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04070, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), ide.getLocalizedMessage()}));
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][66] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.UNBIND_REQUEST_STATE, 66, (Action)new GrammarAction<LdapMessageContainer<UnbindRequestDecorator>>("Unbind Request initialization"){

            public void action(LdapMessageContainer<UnbindRequestDecorator> container) throws DecoderException {
                UnbindRequestDecorator unbindRequest = new UnbindRequestDecorator(container.getLdapCodecService(), (UnbindRequest)new UnbindRequestImpl(container.getMessageId()));
                container.setMessage(unbindRequest);
                TLV tlv = container.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength != 0) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04071, (Object[])new Object[]{expectedLength}));
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04072, (Object[])new Object[0]));
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.UNBIND_REQUEST_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.UNBIND_REQUEST_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][74] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.DEL_REQUEST_STATE, 74, (Action)new GrammarAction<LdapMessageContainer<DeleteRequestDecorator>>("Init del Request"){

            public void action(LdapMessageContainer<DeleteRequestDecorator> container) throws DecoderException {
                DeleteRequestDecorator delRequest = new DeleteRequestDecorator(container.getLdapCodecService(), (DeleteRequest)new DeleteRequestImpl(container.getMessageId()));
                container.setMessage(delRequest);
                TLV tlv = container.getCurrentTLV();
                Dn entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04073, (Object[])new Object[0]));
                }
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = Strings.utf8ToString((byte[])dnBytes);
                try {
                    entry = new Dn(dnStr);
                }
                catch (LdapInvalidDnException ine) {
                    String msg = I18n.err((I18n)I18n.ERR_04074, (Object[])new Object[]{dnStr, Strings.dumpBytes((byte[])dnBytes), ine.getLocalizedMessage()});
                    LOG.error(msg);
                    DeleteResponseImpl response = new DeleteResponseImpl(delRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
                }
                delRequest.setName(entry);
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("Deleting Dn {}", (Object)entry);
                }
            }
        });
        this.transitions[LdapStatesEnum.DEL_REQUEST_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.DEL_REQUEST_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][80] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.ABANDON_REQUEST_STATE, 80, (Action)new GrammarAction<LdapMessageContainer<AbandonRequestDecorator>>("Init Abandon Request"){

            public void action(LdapMessageContainer<AbandonRequestDecorator> container) throws DecoderException {
                AbandonRequestDecorator abandonRequest = new AbandonRequestDecorator(container.getLdapCodecService(), (AbandonRequest)new AbandonRequestImpl(container.getMessageId()));
                container.setMessage(abandonRequest);
                TLV tlv = container.getCurrentTLV();
                Value value = tlv.getValue();
                if (value == null || value.getData() == null) {
                    String msg = I18n.err((I18n)I18n.ERR_04075, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                try {
                    int abandonnedMessageId = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                    abandonRequest.setAbandoned(abandonnedMessageId);
                    if (IS_DEBUG) {
                        LOG.debug("AbandonMessage Id has been decoded : {}", (Object)abandonnedMessageId);
                    }
                    container.setGrammarEndAllowed(true);
                    return;
                }
                catch (IntegerDecoderException ide) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04076, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), ide.getMessage()}));
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.ABANDON_REQUEST_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ABANDON_REQUEST_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][96] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.BIND_REQUEST_STATE, 96, (Action)new GrammarAction<LdapMessageContainer<BindRequestDecorator>>("Init BindRequest"){

            public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
                BindRequestDecorator bindRequest = new BindRequestDecorator(container.getLdapCodecService(), (BindRequest)new BindRequestImpl(container.getMessageId()));
                container.setMessage(bindRequest);
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04077, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[LdapStatesEnum.BIND_REQUEST_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.BIND_REQUEST_STATE, (Enum)LdapStatesEnum.VERSION_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<LdapMessageContainer<BindRequestDecorator>>("Store version"){

            public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
                BindRequest bindRequestMessage = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    int version = IntegerDecoder.parse((Value)value, (int)1, (int)127);
                    if (IS_DEBUG) {
                        LOG.debug("Ldap version ", (Object)version);
                    }
                    bindRequestMessage.setVersion3(version == 3);
                }
                catch (IntegerDecoderException ide) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04078, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), ide.getMessage()}));
                    throw new DecoderException(ide.getMessage());
                }
            }
        });
        this.transitions[LdapStatesEnum.VERSION_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.VERSION_STATE, (Enum)LdapStatesEnum.NAME_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<BindRequestDecorator>>("Store Bind Name value"){

            public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
                BindRequest bindRequestMessage = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    bindRequestMessage.setName(Dn.EMPTY_DN);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = Strings.utf8ToString((byte[])dnBytes);
                    try {
                        Dn dn = new Dn(dnStr);
                        bindRequestMessage.setName(dn);
                    }
                    catch (LdapInvalidDnException ine) {
                        String msg = "Incorrect Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                        LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        BindResponseImpl response = new BindResponseImpl(bindRequestMessage.getMessageId());
                        throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
                    }
                }
                if (IS_DEBUG) {
                    LOG.debug(" The Bind name is {}", (Object)bindRequestMessage.getName());
                }
            }
        });
        this.transitions[LdapStatesEnum.NAME_STATE.ordinal()][128] = new GrammarTransition((Enum)LdapStatesEnum.NAME_STATE, (Enum)LdapStatesEnum.SIMPLE_STATE, 128, (Action)new GrammarAction<LdapMessageContainer<BindRequestDecorator>>("Store Bind Simple Authentication value"){

            public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
                BindRequest bindRequestMessage = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                bindRequestMessage.setSimple(true);
                if (tlv.getLength() == 0) {
                    bindRequestMessage.setCredentials(StringConstants.EMPTY_BYTES);
                } else {
                    bindRequestMessage.setCredentials(tlv.getValue().getData());
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("The simple authentication is : {}", (Object)Strings.dumpBytes((byte[])bindRequestMessage.getCredentials()));
                }
            }
        });
        this.transitions[LdapStatesEnum.SIMPLE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.SIMPLE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.NAME_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.NAME_STATE, (Enum)LdapStatesEnum.SASL_STATE, 163, (Action)new GrammarAction<LdapMessageContainer<BindRequestDecorator>>("Initialize Bind SASL Authentication"){

            public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
                BindRequest bindRequestMessage = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04079, (Object[])new Object[0]);
                    LOG.error(msg);
                    BindResponseImpl response = new BindResponseImpl(bindRequestMessage.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_CREDENTIALS, bindRequestMessage.getName(), null);
                }
                bindRequestMessage.setSimple(false);
                if (IS_DEBUG) {
                    LOG.debug("The SaslCredential has been created");
                }
            }
        });
        this.transitions[LdapStatesEnum.SASL_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.SASL_STATE, (Enum)LdapStatesEnum.MECHANISM_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<BindRequestDecorator>>("Store SASL mechanism"){

            public void action(LdapMessageContainer<BindRequestDecorator> container) throws DecoderException {
                BindRequest bindRequestMessage = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    bindRequestMessage.setSaslMechanism("");
                } else {
                    bindRequestMessage.setSaslMechanism(Strings.utf8ToString((byte[])tlv.getValue().getData()));
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("The mechanism is : {}", (Object)bindRequestMessage.getSaslMechanism());
                }
            }
        });
        this.transitions[LdapStatesEnum.MECHANISM_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MECHANISM_STATE, (Enum)LdapStatesEnum.CREDENTIALS_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<BindRequestDecorator>>("Store SASL credentials"){

            public void action(LdapMessageContainer<BindRequestDecorator> container) {
                BindRequest bindRequestMessage = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    bindRequestMessage.setCredentials(StringConstants.EMPTY_BYTES);
                } else {
                    bindRequestMessage.setCredentials(tlv.getValue().getData());
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("The credentials are : {}", (Object)Strings.dumpBytes((byte[])bindRequestMessage.getCredentials()));
                }
            }
        });
        this.transitions[LdapStatesEnum.MECHANISM_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.MECHANISM_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.CREDENTIALS_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.CREDENTIALS_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][97] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.BIND_RESPONSE_STATE, 97, (Action)new GrammarAction<LdapMessageContainer<BindResponseDecorator>>("Init BindReponse"){

            public void action(LdapMessageContainer<BindResponseDecorator> container) {
                BindResponseDecorator bindResponse = new BindResponseDecorator(container.getLdapCodecService(), (BindResponse)new BindResponseImpl(container.getMessageId()));
                container.setMessage(bindResponse);
            }
        });
        this.transitions[LdapStatesEnum.BIND_RESPONSE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.BIND_RESPONSE_STATE, (Enum)LdapStatesEnum.RESULT_CODE_BR_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new ResultCodeAction());
        this.transitions[LdapStatesEnum.RESULT_CODE_BR_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.RESULT_CODE_BR_STATE, (Enum)LdapStatesEnum.MATCHED_DN_BR_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new MatchedDNAction());
        this.transitions[LdapStatesEnum.MATCHED_DN_BR_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MATCHED_DN_BR_STATE, (Enum)LdapStatesEnum.ERROR_MESSAGE_BR_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ErrorMessageAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_BR_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_BR_STATE, (Enum)LdapStatesEnum.SERVER_SASL_CREDENTIALS_STATE, 135, (Action)new ServerSASLCredsAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_BR_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_BR_STATE, (Enum)LdapStatesEnum.REFERRALS_BR_STATE, 163, (Action)new InitReferralsAction());
        this.transitions[LdapStatesEnum.REFERRALS_BR_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.REFERRALS_BR_STATE, (Enum)LdapStatesEnum.REFERRAL_BR_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ReferralAction());
        this.transitions[LdapStatesEnum.REFERRAL_BR_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_BR_STATE, (Enum)LdapStatesEnum.REFERRAL_BR_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ReferralAction());
        this.transitions[LdapStatesEnum.REFERRAL_BR_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_BR_STATE, (Enum)LdapStatesEnum.SERVER_SASL_CREDENTIALS_STATE, 135, (Action)new ServerSASLCredsAction());
        this.transitions[LdapStatesEnum.REFERRAL_BR_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_BR_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_BR_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_BR_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.SERVER_SASL_CREDENTIALS_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.SERVER_SASL_CREDENTIALS_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.RESULT_CODE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.RESULT_CODE_STATE, (Enum)LdapStatesEnum.MATCHED_DN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new MatchedDNAction());
        this.transitions[LdapStatesEnum.MATCHED_DN_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MATCHED_DN_STATE, (Enum)LdapStatesEnum.ERROR_MESSAGE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ErrorMessageAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_STATE, (Enum)LdapStatesEnum.REFERRALS_STATE, 163, (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Init referrals list"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04080, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                MessageDecorator<? extends Message> response = container.getMessage();
                LdapResult ldapResult = ((ResultResponse)response).getLdapResult();
                ReferralImpl referral = new ReferralImpl();
                ldapResult.setReferral((Referral)referral);
            }
        });
        this.transitions[LdapStatesEnum.REFERRALS_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.REFERRALS_STATE, (Enum)LdapStatesEnum.REFERRAL_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ReferralAction());
        this.transitions[LdapStatesEnum.REFERRAL_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_STATE, (Enum)LdapStatesEnum.REFERRAL_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ReferralAction());
        this.transitions[LdapStatesEnum.REFERRAL_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][100] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.SEARCH_RESULT_ENTRY_STATE, 100, (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Init SearchResultEntry"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) {
                SearchResultEntryDecorator searchResultEntry = new SearchResultEntryDecorator(container.getLdapCodecService(), (SearchResultEntry)new SearchResultEntryImpl(container.getMessageId()));
                container.setMessage(searchResultEntry);
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_ENTRY_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.SEARCH_RESULT_ENTRY_STATE, (Enum)LdapStatesEnum.OBJECT_NAME_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>>("Store search result entry object name Value"){

            public void action(LdapMessageContainer<SearchResultEntryDecorator> container) throws DecoderException {
                SearchResultEntryDecorator searchResultEntry = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                Dn objectName = Dn.EMPTY_DN;
                if (tlv.getLength() == 0) {
                    searchResultEntry.setObjectName(objectName);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = Strings.utf8ToString((byte[])dnBytes);
                    try {
                        objectName = new Dn(dnStr);
                    }
                    catch (LdapInvalidDnException ine) {
                        String msg = "The Dn " + Strings.dumpBytes((byte[])dnBytes) + "is invalid : " + ine.getMessage();
                        LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        throw new DecoderException(msg, (Throwable)ine);
                    }
                    searchResultEntry.setObjectName(objectName);
                }
                if (IS_DEBUG) {
                    LOG.debug("Search Result Entry Dn found : {}", (Object)searchResultEntry.getObjectName());
                }
            }
        });
        this.transitions[LdapStatesEnum.OBJECT_NAME_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.OBJECT_NAME_STATE, (Enum)LdapStatesEnum.ATTRIBUTES_SR_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Pop and end allowed"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.ATTRIBUTES_SR_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTES_SR_STATE, (Enum)LdapStatesEnum.PARTIAL_ATTRIBUTES_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.ATTRIBUTES_SR_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTES_SR_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.PARTIAL_ATTRIBUTES_LIST_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.PARTIAL_ATTRIBUTES_LIST_STATE, (Enum)LdapStatesEnum.TYPE_SR_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchResultEntryDecorator>>("Store search result entry object name Value"){

            public void action(LdapMessageContainer<SearchResultEntryDecorator> container) throws DecoderException {
                SearchResultEntryDecorator searchResultEntry = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                String type = "";
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04081, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                type = LdapMessageGrammar.getType(tlv.getValue().getData());
                try {
                    searchResultEntry.addAttribute(type);
                }
                catch (LdapException ine) {
                    String msg = "The Attribute type " + type + "is invalid : " + ine.getMessage();
                    LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    throw new DecoderException(msg, (Throwable)ine);
                }
                if (IS_DEBUG) {
                    LOG.debug("Attribute type : {}", (Object)type);
                }
            }
        });
        this.transitions[LdapStatesEnum.TYPE_SR_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.TYPE_SR_STATE, (Enum)LdapStatesEnum.VALS_SR_STATE, (int)UniversalTag.SET.getValue(), (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Grammar end allowed"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.VALS_SR_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.VALS_SR_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_VALUE_SR_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new SearchResultAttributeValueAction());
        this.transitions[LdapStatesEnum.VALS_SR_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.VALS_SR_STATE, (Enum)LdapStatesEnum.PARTIAL_ATTRIBUTES_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.VALS_SR_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.VALS_SR_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_VALUE_SR_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_VALUE_SR_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_VALUE_SR_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new SearchResultAttributeValueAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_VALUE_SR_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_VALUE_SR_STATE, (Enum)LdapStatesEnum.PARTIAL_ATTRIBUTES_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.ATTRIBUTE_VALUE_SR_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_VALUE_SR_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][101] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.SEARCH_RESULT_DONE_STATE, 101, (Action)new GrammarAction<LdapMessageContainer<SearchResultDoneDecorator>>("Init search Result Done"){

            public void action(LdapMessageContainer<SearchResultDoneDecorator> container) {
                SearchResultDoneDecorator searchResultDone = new SearchResultDoneDecorator(container.getLdapCodecService(), (SearchResultDone)new SearchResultDoneImpl(container.getMessageId()));
                container.setMessage(searchResultDone);
                LOG.debug("Search Result Done found");
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_DONE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.SEARCH_RESULT_DONE_STATE, (Enum)LdapStatesEnum.RESULT_CODE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new ResultCodeAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][102] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.MODIFY_REQUEST_STATE, 102, (Action)new GrammarAction<LdapMessageContainer<ModifyRequestDecorator>>("Init ModifyRequest"){

            public void action(LdapMessageContainer<ModifyRequestDecorator> container) {
                ModifyRequestImpl modifyRequest = new ModifyRequestImpl(container.getMessageId());
                ModifyRequestDecorator modifyRequestDecorator = new ModifyRequestDecorator(container.getLdapCodecService(), (ModifyRequest)modifyRequest);
                container.setMessage(modifyRequestDecorator);
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_REQUEST_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MODIFY_REQUEST_STATE, (Enum)LdapStatesEnum.OBJECT_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<ModifyRequestDecorator>>("Store Modify request object Value"){

            public void action(LdapMessageContainer<ModifyRequestDecorator> container) throws DecoderException {
                ModifyRequestDecorator modifyRequestDecorator = container.getMessage();
                ModifyRequest modifyRequest = (ModifyRequest)modifyRequestDecorator.getDecorated();
                TLV tlv = container.getCurrentTLV();
                Dn object = Dn.EMPTY_DN;
                if (tlv.getLength() == 0) {
                    ((ModifyRequest)modifyRequestDecorator.getDecorated()).setName(object);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = Strings.utf8ToString((byte[])dnBytes);
                    try {
                        object = new Dn(dnStr);
                    }
                    catch (LdapInvalidDnException ine) {
                        String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                        LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        ModifyResponseImpl response = new ModifyResponseImpl(modifyRequest.getMessageId());
                        throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
                    }
                    modifyRequest.setName(object);
                }
                if (IS_DEBUG) {
                    LOG.debug("Modification of Dn {}", (Object)modifyRequest.getName());
                }
            }
        });
        this.transitions[LdapStatesEnum.OBJECT_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.OBJECT_STATE, (Enum)LdapStatesEnum.MODIFICATIONS_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.MODIFICATIONS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MODIFICATIONS_STATE, (Enum)LdapStatesEnum.MODIFICATIONS_SEQ_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.MODIFICATIONS_SEQ_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MODIFICATIONS_SEQ_STATE, (Enum)LdapStatesEnum.OPERATION_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new GrammarAction<LdapMessageContainer<ModifyRequestDecorator>>("Store operation type"){

            public void action(LdapMessageContainer<ModifyRequestDecorator> container) throws DecoderException {
                ModifyRequestDecorator modifyRequestDecorator = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                int operation = 0;
                try {
                    operation = IntegerDecoder.parse((Value)tlv.getValue(), (int)0, (int)2);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_04082, (Object[])new Object[]{Strings.dumpBytes((byte[])tlv.getValue().getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                modifyRequestDecorator.setCurrentOperation(operation);
                if (IS_DEBUG) {
                    switch (operation) {
                        case 0: {
                            LOG.debug("Modification operation : ADD");
                            break;
                        }
                        case 1: {
                            LOG.debug("Modification operation : DELETE");
                            break;
                        }
                        case 2: {
                            LOG.debug("Modification operation : REPLACE");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.OPERATION_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.OPERATION_STATE, (Enum)LdapStatesEnum.MODIFICATION_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.MODIFICATION_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MODIFICATION_STATE, (Enum)LdapStatesEnum.TYPE_MOD_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<ModifyRequestDecorator>>("Store type"){

            public void action(LdapMessageContainer<ModifyRequestDecorator> container) throws DecoderException {
                ModifyRequestDecorator modifyRequestDecorator = container.getMessage();
                ModifyRequest modifyRequest = (ModifyRequest)modifyRequestDecorator.getDecorated();
                TLV tlv = container.getCurrentTLV();
                String type = null;
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04083, (Object[])new Object[0]);
                    LOG.error(msg);
                    ModifyResponseImpl response = new ModifyResponseImpl(modifyRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, modifyRequest.getName(), null);
                }
                type = LdapMessageGrammar.getType(tlv.getValue().getData());
                modifyRequestDecorator.addAttributeTypeAndValues(type);
                if (IS_DEBUG) {
                    LOG.debug("Modifying type : {}", (Object)type);
                }
            }
        });
        this.transitions[LdapStatesEnum.TYPE_MOD_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.TYPE_MOD_STATE, (Enum)LdapStatesEnum.VALS_STATE, (int)UniversalTag.SET.getValue(), (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Init Attribute vals"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    LOG.debug("No vals for this attribute");
                }
                container.setGrammarEndAllowed(true);
                LOG.debug("Some vals are to be decoded");
            }
        });
        this.transitions[LdapStatesEnum.VALS_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.VALS_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ModifyAttributeValueAction());
        this.transitions[LdapStatesEnum.VALS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.VALS_STATE, (Enum)LdapStatesEnum.MODIFICATIONS_SEQ_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.VALS_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.VALS_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_VALUE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_VALUE_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ModifyAttributeValueAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_VALUE_STATE, (Enum)LdapStatesEnum.MODIFICATIONS_SEQ_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.ATTRIBUTE_VALUE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_VALUE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][103] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.MODIFY_RESPONSE_STATE, 103, (Action)new GrammarAction<LdapMessageContainer<ModifyResponseDecorator>>("Init ModifyResponse"){

            public void action(LdapMessageContainer<ModifyResponseDecorator> container) {
                ModifyResponseDecorator modifyResponse = new ModifyResponseDecorator(container.getLdapCodecService(), (ModifyResponse)new ModifyResponseImpl(container.getMessageId()));
                container.setMessage(modifyResponse);
                LOG.debug("Modify response");
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_RESPONSE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MODIFY_RESPONSE_STATE, (Enum)LdapStatesEnum.RESULT_CODE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new ResultCodeAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][104] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.ADD_REQUEST_STATE, 104, (Action)new GrammarAction<LdapMessageContainer<AddRequestDecorator>>("Init addRequest"){

            public void action(LdapMessageContainer<AddRequestDecorator> container) throws DecoderException {
                int messageId = container.getMessageId();
                AddRequestDecorator addRequest = new AddRequestDecorator(container.getLdapCodecService(), (AddRequest)new AddRequestImpl(messageId));
                container.setMessage(addRequest);
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04084, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[LdapStatesEnum.ADD_REQUEST_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ADD_REQUEST_STATE, (Enum)LdapStatesEnum.ENTRY_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<AddRequestDecorator>>("Store add request object Value"){

            public void action(LdapMessageContainer<AddRequestDecorator> container) throws DecoderException {
                AddRequestDecorator addRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04085, (Object[])new Object[0]);
                    LOG.error(msg);
                    AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.NAMING_VIOLATION, Dn.EMPTY_DN, null);
                }
                Dn entryDn = null;
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = Strings.utf8ToString((byte[])dnBytes);
                try {
                    entryDn = new Dn(dnStr);
                }
                catch (LdapInvalidDnException ine) {
                    String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                    LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
                }
                addRequest.setEntryDn(entryDn);
                LOG.debug("Adding an entry with Dn : {}", (Object)addRequest.getEntry());
            }
        });
        this.transitions[LdapStatesEnum.ENTRY_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ENTRY_STATE, (Enum)LdapStatesEnum.ATTRIBUTES_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.ATTRIBUTES_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTES_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.ATTRIBUTE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_STATE, (Enum)LdapStatesEnum.TYPE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<AddRequestDecorator>>("Store attribute type"){

            public void action(LdapMessageContainer<AddRequestDecorator> container) throws DecoderException {
                AddRequestDecorator addRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04086, (Object[])new Object[0]);
                    LOG.error(msg);
                    AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, addRequest.getEntry().getDn(), null);
                }
                String type = LdapMessageGrammar.getType(tlv.getValue().getData());
                try {
                    addRequest.addAttributeType(type);
                }
                catch (LdapException ne) {
                    String msg = I18n.err((I18n)I18n.ERR_04087, (Object[])new Object[0]);
                    LOG.error(msg);
                    AddResponseImpl response = new AddResponseImpl(addRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, addRequest.getEntry().getDn(), ne);
                }
                if (IS_DEBUG) {
                    LOG.debug("Adding type {}", (Object)type);
                }
            }
        });
        this.transitions[LdapStatesEnum.TYPE_STATE.ordinal()][UniversalTag.SET.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.TYPE_STATE, (Enum)LdapStatesEnum.VALUES_STATE, (int)UniversalTag.SET.getValue(), null);
        this.transitions[LdapStatesEnum.VALUES_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.VALUES_STATE, (Enum)LdapStatesEnum.VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ValueAction());
        this.transitions[LdapStatesEnum.VALUE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.VALUE_STATE, (Enum)LdapStatesEnum.VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ValueAction());
        this.transitions[LdapStatesEnum.VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.VALUE_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.VALUE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.VALUE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][105] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.ADD_RESPONSE_STATE, 105, (Action)new GrammarAction<LdapMessageContainer<AddResponseDecorator>>("Init AddResponse"){

            public void action(LdapMessageContainer<AddResponseDecorator> container) throws DecoderException {
                AddResponseDecorator addResponse = new AddResponseDecorator(container.getLdapCodecService(), (AddResponse)new AddResponseImpl(container.getMessageId()));
                container.setMessage(addResponse);
                TLV tlv = container.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04088, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                LOG.debug("Add Response");
            }
        });
        this.transitions[LdapStatesEnum.ADD_RESPONSE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ADD_RESPONSE_STATE, (Enum)LdapStatesEnum.RESULT_CODE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new ResultCodeAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][107] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.DEL_RESPONSE_STATE, 107, (Action)new GrammarAction<LdapMessageContainer<DeleteResponseDecorator>>("Init DelResponse"){

            public void action(LdapMessageContainer<DeleteResponseDecorator> container) {
                DeleteResponseDecorator delResponse = new DeleteResponseDecorator(container.getLdapCodecService(), (DeleteResponse)new DeleteResponseImpl(container.getMessageId()));
                container.setMessage(delResponse);
                LOG.debug("Del response ");
            }
        });
        this.transitions[LdapStatesEnum.DEL_RESPONSE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.DEL_RESPONSE_STATE, (Enum)LdapStatesEnum.RESULT_CODE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new ResultCodeAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][108] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.MODIFY_DN_REQUEST_STATE, 108, (Action)new GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>>("Init Modify Dn Request"){

            public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) {
                ModifyDnRequestDecorator modifyDnRequest = new ModifyDnRequestDecorator(container.getLdapCodecService(), (ModifyDnRequest)new ModifyDnRequestImpl(container.getMessageId()));
                container.setMessage(modifyDnRequest);
                LOG.debug("ModifyDn request");
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_REQUEST_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MODIFY_DN_REQUEST_STATE, (Enum)LdapStatesEnum.ENTRY_MOD_DN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>>("Store entry"){

            public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
                ModifyDnRequest modifyDnRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                Dn entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04089, (Object[])new Object[0]));
                }
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = Strings.utf8ToString((byte[])dnBytes);
                try {
                    entry = new Dn(dnStr);
                }
                catch (LdapInvalidDnException ine) {
                    String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                    LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
                }
                modifyDnRequest.setName(entry);
                if (IS_DEBUG) {
                    LOG.debug("Modifying Dn {}", (Object)entry);
                }
            }
        });
        this.transitions[LdapStatesEnum.ENTRY_MOD_DN_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ENTRY_MOD_DN_STATE, (Enum)LdapStatesEnum.NEW_RDN_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>>("Store new Rdn"){

            public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
                ModifyDnRequest modifyDnRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                Rdn newRdn = null;
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04090, (Object[])new Object[0]);
                    LOG.error(msg);
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), null);
                }
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = Strings.utf8ToString((byte[])dnBytes);
                try {
                    Dn dn = new Dn(dnStr);
                    newRdn = dn.getRdn(0);
                }
                catch (LdapInvalidDnException ine) {
                    String msg = "Invalid new Rdn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                    LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), ine);
                }
                modifyDnRequest.setNewRdn(newRdn);
                if (IS_DEBUG) {
                    LOG.debug("Modifying with new Rdn {}", (Object)newRdn);
                }
            }
        });
        this.transitions[LdapStatesEnum.NEW_RDN_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.NEW_RDN_STATE, (Enum)LdapStatesEnum.DELETE_OLD_RDN_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>>("Store matching dnAttributes Value"){

            public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
                ModifyDnRequest modifyDnRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    modifyDnRequest.setDeleteOldRdn(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04091, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), bde.getMessage()}));
                    throw new DecoderException(bde.getMessage());
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    if (modifyDnRequest.getDeleteOldRdn()) {
                        LOG.debug(" Old Rdn attributes will be deleted");
                    } else {
                        LOG.debug(" Old Rdn attributes will be retained");
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.DELETE_OLD_RDN_STATE.ordinal()][128] = new GrammarTransition((Enum)LdapStatesEnum.DELETE_OLD_RDN_STATE, (Enum)LdapStatesEnum.NEW_SUPERIOR_STATE, 128, (Action)new GrammarAction<LdapMessageContainer<ModifyDnRequestDecorator>>("Store new superior"){

            public void action(LdapMessageContainer<ModifyDnRequestDecorator> container) throws DecoderException {
                ModifyDnRequest modifyDnRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                Dn newSuperior = Dn.EMPTY_DN;
                if (tlv.getLength() == 0) {
                    if (modifyDnRequest.getDeleteOldRdn()) {
                        throw new DecoderException(I18n.err((I18n)I18n.ERR_04092, (Object[])new Object[0]));
                    }
                    LOG.warn("The new superior is null, so we will change the entry");
                    modifyDnRequest.setNewSuperior(newSuperior);
                } else {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = Strings.utf8ToString((byte[])dnBytes);
                    try {
                        newSuperior = new Dn(dnStr);
                    }
                    catch (LdapInvalidDnException ine) {
                        String msg = "Invalid new superior Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                        LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
                        throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), ine);
                    }
                    modifyDnRequest.setNewSuperior(newSuperior);
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("New superior Dn {}", (Object)newSuperior);
                }
            }
        });
        this.transitions[LdapStatesEnum.DELETE_OLD_RDN_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.DELETE_OLD_RDN_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.NEW_SUPERIOR_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.NEW_SUPERIOR_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][109] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.MODIFY_DN_RESPONSE_STATE, 109, (Action)new GrammarAction<LdapMessageContainer<ModifyDnResponseDecorator>>("Init ModifyDNResponse"){

            public void action(LdapMessageContainer<ModifyDnResponseDecorator> container) {
                ModifyDnResponseDecorator modifyDnResponse = new ModifyDnResponseDecorator(container.getLdapCodecService(), (ModifyDnResponse)new ModifyDnResponseImpl(container.getMessageId()));
                container.setMessage(modifyDnResponse);
                LOG.debug("Modify Dn response ");
            }
        });
        this.transitions[LdapStatesEnum.MODIFY_DN_RESPONSE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MODIFY_DN_RESPONSE_STATE, (Enum)LdapStatesEnum.RESULT_CODE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new ResultCodeAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][110] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.COMPARE_REQUEST_STATE, 110, (Action)new GrammarAction<LdapMessageContainer<CompareRequestDecorator>>("Init Compare Request"){

            public void action(LdapMessageContainer<CompareRequestDecorator> container) {
                CompareRequestDecorator compareRequest = new CompareRequestDecorator(container.getLdapCodecService(), (CompareRequest)new CompareRequestImpl(container.getMessageId()));
                container.setMessage(compareRequest);
                LOG.debug("Compare Request");
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_REQUEST_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.COMPARE_REQUEST_STATE, (Enum)LdapStatesEnum.ENTRY_COMP_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<CompareRequestDecorator>>("Store entry"){

            public void action(LdapMessageContainer<CompareRequestDecorator> container) throws DecoderException {
                CompareRequest compareRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                Dn entry = null;
                if (tlv.getLength() == 0) {
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04089, (Object[])new Object[0]));
                }
                byte[] dnBytes = tlv.getValue().getData();
                String dnStr = Strings.utf8ToString((byte[])dnBytes);
                try {
                    entry = new Dn(dnStr);
                }
                catch (LdapInvalidDnException ine) {
                    String msg = "Invalid Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                    LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                    CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
                }
                compareRequest.setName(entry);
                if (IS_DEBUG) {
                    LOG.debug("Comparing Dn {}", (Object)entry);
                }
            }
        });
        this.transitions[LdapStatesEnum.ENTRY_COMP_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ENTRY_COMP_STATE, (Enum)LdapStatesEnum.AVA_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[LdapStatesEnum.AVA_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.AVA_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESC_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<CompareRequestDecorator>>("Store attribute desc"){

            public void action(LdapMessageContainer<CompareRequestDecorator> container) throws DecoderException {
                CompareRequest compareRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04093, (Object[])new Object[0]);
                    LOG.error(msg);
                    CompareResponseImpl response = new CompareResponseImpl(compareRequest.getMessageId());
                    throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, compareRequest.getName(), null);
                }
                String type = LdapMessageGrammar.getType(tlv.getValue().getData());
                compareRequest.setAttributeId(type);
                if (IS_DEBUG) {
                    LOG.debug("Comparing attribute description {}", (Object)compareRequest.getAttributeId());
                }
            }
        });
        this.transitions[LdapStatesEnum.ATTRIBUTE_DESC_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_DESC_STATE, (Enum)LdapStatesEnum.ASSERTION_VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<CompareRequestDecorator>>("Store assertion value"){

            public void action(LdapMessageContainer<CompareRequestDecorator> container) {
                CompareRequest compareRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    compareRequest.setAssertionValue("");
                } else if (container.isBinary(compareRequest.getAttributeId())) {
                    compareRequest.setAssertionValue(tlv.getValue().getData());
                    if (IS_DEBUG) {
                        LOG.debug("Comparing attribute value {}", (Object)Strings.dumpBytes((byte[])compareRequest.getAssertionValue().getBytes()));
                    }
                } else {
                    compareRequest.setAssertionValue(Strings.utf8ToString((byte[])tlv.getValue().getData()));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Comparing attribute value {}", (Object)compareRequest.getAssertionValue());
                    }
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][111] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.COMPARE_RESPONSE_STATE, 111, (Action)new GrammarAction<LdapMessageContainer<CompareResponseDecorator>>("Init CompareResponse"){

            public void action(LdapMessageContainer<CompareResponseDecorator> container) throws DecoderException {
                CompareResponseDecorator compareResponse = new CompareResponseDecorator(container.getLdapCodecService(), (CompareResponse)new CompareResponseImpl(container.getMessageId()));
                container.setMessage(compareResponse);
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04094, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                LOG.debug("Compare response ");
            }
        });
        this.transitions[LdapStatesEnum.COMPARE_RESPONSE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.COMPARE_RESPONSE_STATE, (Enum)LdapStatesEnum.RESULT_CODE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new ResultCodeAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][115] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.SEARCH_RESULT_REFERENCE_STATE, 115, (Action)new GrammarAction<LdapMessageContainer<SearchResultReferenceDecorator>>("Init SearchResultReference"){

            public void action(LdapMessageContainer<SearchResultReferenceDecorator> container) throws DecoderException {
                SearchResultReferenceDecorator searchResultReference = new SearchResultReferenceDecorator(container.getLdapCodecService(), (SearchResultReference)new SearchResultReferenceImpl(container.getMessageId()));
                container.setMessage(searchResultReference);
                LOG.debug("SearchResultReference response ");
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_RESULT_REFERENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.SEARCH_RESULT_REFERENCE_STATE, (Enum)LdapStatesEnum.REFERENCE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new StoreReferenceAction());
        this.transitions[LdapStatesEnum.REFERENCE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.REFERENCE_STATE, (Enum)LdapStatesEnum.REFERENCE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new StoreReferenceAction());
        this.transitions[LdapStatesEnum.REFERENCE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.REFERENCE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][119] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.EXTENDED_REQUEST_STATE, 119, (Action)new GrammarAction<LdapMessageContainer<ExtendedRequestDecorator>>("Init Extended Request"){

            public void action(LdapMessageContainer<ExtendedRequestDecorator> container) throws DecoderException {
                ExtendedRequestDecorator extendedRequest = new ExtendedRequestDecorator(container.getLdapCodecService(), (ExtendedRequest)new ExtendedRequestImpl(container.getMessageId()));
                container.setMessage(extendedRequest);
                LOG.debug("Extended request");
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_REQUEST_STATE.ordinal()][128] = new GrammarTransition((Enum)LdapStatesEnum.EXTENDED_REQUEST_STATE, (Enum)LdapStatesEnum.REQUEST_NAME_STATE, 128, (Action)new GrammarAction<LdapMessageContainer<ExtendedRequestDecorator>>("Store name"){

            public void action(LdapMessageContainer<ExtendedRequestDecorator> container) throws DecoderException {
                ExtendedRequest extendedRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04095, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] requestNameBytes = tlv.getValue().getData();
                try {
                    String requestName = Strings.utf8ToString((byte[])requestNameBytes);
                    if (!OID.isOID((String)requestName)) {
                        String msg = "The Request name is not a valid OID : " + Strings.utf8ToString((byte[])requestNameBytes) + " (" + Strings.dumpBytes((byte[])requestNameBytes) + ") is invalid";
                        LOG.error(msg);
                        throw new DecoderException(msg);
                    }
                    extendedRequest.setRequestName(requestName);
                }
                catch (DecoderException de) {
                    String msg = "The Request name is not a valid OID : " + Strings.utf8ToString((byte[])requestNameBytes) + " (" + Strings.dumpBytes((byte[])requestNameBytes) + ") is invalid";
                    LOG.error("{} : {}", (Object)msg, (Object)de.getMessage());
                    throw de;
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("OID read : {}", (Object)extendedRequest.getRequestName());
                }
            }
        });
        this.transitions[LdapStatesEnum.REQUEST_NAME_STATE.ordinal()][129] = new GrammarTransition((Enum)LdapStatesEnum.REQUEST_NAME_STATE, (Enum)LdapStatesEnum.REQUEST_VALUE_STATE, 129, (Action)new GrammarAction<LdapMessageContainer<ExtendedRequestDecorator>>("Store value"){

            public void action(LdapMessageContainer<ExtendedRequestDecorator> container) throws DecoderException {
                ExtendedRequest extendedRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    extendedRequest.setRequestValue(StringConstants.EMPTY_BYTES);
                } else {
                    extendedRequest.setRequestValue(tlv.getValue().getData());
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("Extended value : {}", (Object)extendedRequest.getRequestValue());
                }
            }
        });
        this.transitions[LdapStatesEnum.REQUEST_NAME_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.REQUEST_NAME_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.REQUEST_VALUE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.REQUEST_VALUE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][120] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.EXTENDED_RESPONSE_STATE, 120, (Action)new GrammarAction<LdapMessageContainer<ExtendedResponseDecorator>>("Init Extended Reponse"){

            public void action(LdapMessageContainer<ExtendedResponseDecorator> container) throws DecoderException {
                ExtendedResponseDecorator extendedResponse = new ExtendedResponseDecorator(container.getLdapCodecService(), (ExtendedResponse)new ExtendedResponseImpl(container.getMessageId()));
                container.setMessage(extendedResponse);
                LOG.debug("Extended Response");
            }
        });
        this.transitions[LdapStatesEnum.EXTENDED_RESPONSE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.EXTENDED_RESPONSE_STATE, (Enum)LdapStatesEnum.RESULT_CODE_ER_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new ResultCodeAction());
        this.transitions[LdapStatesEnum.RESULT_CODE_ER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.RESULT_CODE_ER_STATE, (Enum)LdapStatesEnum.MATCHED_DN_ER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new MatchedDNAction());
        this.transitions[LdapStatesEnum.MATCHED_DN_ER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MATCHED_DN_ER_STATE, (Enum)LdapStatesEnum.ERROR_MESSAGE_ER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ErrorMessageAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_ER_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_ER_STATE, (Enum)LdapStatesEnum.REFERRALS_ER_STATE, 163, (Action)new InitReferralsAction());
        this.transitions[LdapStatesEnum.REFERRALS_ER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.REFERRALS_ER_STATE, (Enum)LdapStatesEnum.REFERRAL_ER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ReferralAction());
        this.transitions[LdapStatesEnum.REFERRAL_ER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_ER_STATE, (Enum)LdapStatesEnum.REFERRAL_ER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ReferralAction());
        this.transitions[LdapStatesEnum.REFERRAL_ER_STATE.ordinal()][138] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_ER_STATE, (Enum)LdapStatesEnum.RESPONSE_NAME_STATE, 138, (Action)new ResponseNameAction());
        this.transitions[LdapStatesEnum.REFERRAL_ER_STATE.ordinal()][139] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_ER_STATE, (Enum)LdapStatesEnum.RESPONSE_STATE, 139, (Action)new ResponseAction());
        this.transitions[LdapStatesEnum.REFERRAL_ER_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.REFERRAL_ER_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_ER_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_ER_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_ER_STATE.ordinal()][138] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_ER_STATE, (Enum)LdapStatesEnum.RESPONSE_NAME_STATE, 138, (Action)new ResponseNameAction());
        this.transitions[LdapStatesEnum.RESPONSE_NAME_STATE.ordinal()][139] = new GrammarTransition((Enum)LdapStatesEnum.RESPONSE_NAME_STATE, (Enum)LdapStatesEnum.RESPONSE_STATE, 139, (Action)new ResponseAction());
        this.transitions[LdapStatesEnum.RESPONSE_NAME_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.RESPONSE_NAME_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.ERROR_MESSAGE_ER_STATE.ordinal()][139] = new GrammarTransition((Enum)LdapStatesEnum.ERROR_MESSAGE_ER_STATE, (Enum)LdapStatesEnum.RESPONSE_STATE, 139, (Action)new ResponseAction());
        this.transitions[LdapStatesEnum.RESPONSE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.RESPONSE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][121] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_STATE, 121, (Action)new GrammarAction<LdapMessageContainer<IntermediateResponseDecorator>>("Init Intermediate Response"){

            public void action(LdapMessageContainer<IntermediateResponseDecorator> container) throws DecoderException {
                IntermediateResponseDecorator intermediateResponse = new IntermediateResponseDecorator(container.getLdapCodecService(), (IntermediateResponse)new IntermediateResponseImpl(container.getMessageId()));
                container.setMessage(intermediateResponse);
                LOG.debug("Intermediate Response");
            }
        });
        this.transitions[LdapStatesEnum.INTERMEDIATE_RESPONSE_STATE.ordinal()][128] = new GrammarTransition((Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_STATE, (Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_NAME_STATE, 128, (Action)new GrammarAction<LdapMessageContainer<IntermediateResponseDecorator>>("Store response name"){

            public void action(LdapMessageContainer<IntermediateResponseDecorator> container) throws DecoderException {
                IntermediateResponse intermediateResponse = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04095, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] responseNameBytes = tlv.getValue().getData();
                String oidStr = Strings.utf8ToString((byte[])responseNameBytes);
                if (!OID.isOID((String)oidStr)) {
                    String msg = "The Intermediate Response name is not a valid OID : " + Strings.utf8ToString((byte[])responseNameBytes) + " (" + Strings.dumpBytes((byte[])responseNameBytes) + ") is invalid";
                    LOG.error("{} : {}", (Object)msg, (Object)oidStr);
                    throw new DecoderException(msg);
                }
                OID.isOID((String)oidStr);
                intermediateResponse.setResponseName(oidStr);
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("OID read : {}", (Object)intermediateResponse.getResponseName());
                }
            }
        });
        this.transitions[LdapStatesEnum.INTERMEDIATE_RESPONSE_STATE.ordinal()][129] = new GrammarTransition((Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_STATE, (Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_VALUE_STATE, 129, (Action)new GrammarAction<LdapMessageContainer<IntermediateResponseDecorator>>("Store response value"){

            public void action(LdapMessageContainer<IntermediateResponseDecorator> container) throws DecoderException {
                IntermediateResponse intermediateResponse = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    intermediateResponse.setResponseValue(StringConstants.EMPTY_BYTES);
                } else {
                    intermediateResponse.setResponseValue(tlv.getValue().getData());
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("Value read : {}", (Object)Strings.dumpBytes((byte[])intermediateResponse.getResponseValue()));
                }
            }
        });
        this.transitions[LdapStatesEnum.INTERMEDIATE_RESPONSE_NAME_STATE.ordinal()][129] = new GrammarTransition((Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_NAME_STATE, (Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_VALUE_STATE, 129, (Action)new GrammarAction<LdapMessageContainer<IntermediateResponseDecorator>>("Store value"){

            public void action(LdapMessageContainer<IntermediateResponseDecorator> container) throws DecoderException {
                IntermediateResponse intermediateResponse = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    intermediateResponse.setResponseValue(StringConstants.EMPTY_BYTES);
                } else {
                    intermediateResponse.setResponseValue(tlv.getValue().getData());
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("Response value : {}", (Object)intermediateResponse.getResponseValue());
                }
            }
        });
        this.transitions[LdapStatesEnum.INTERMEDIATE_RESPONSE_NAME_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_NAME_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.INTERMEDIATE_RESPONSE_VALUE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.INTERMEDIATE_RESPONSE_VALUE_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>> addControl = new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Add Control"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                int expectedLength = tlv.getLength();
                if (expectedLength == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04096, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        };
        this.transitions[LdapStatesEnum.CONTROLS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.CONTROLS_STATE, (Enum)LdapStatesEnum.CONTROL_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)addControl);
        this.transitions[LdapStatesEnum.CONTROL_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.CONTROL_STATE, (Enum)LdapStatesEnum.CONTROL_TYPE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Set Control Type"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04097, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] value = tlv.getValue().getData();
                String oidValue = Strings.asciiBytesToString((byte[])value);
                if (!OID.isOID((String)oidValue)) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04098, (Object[])new Object[]{Strings.dumpBytes((byte[])value)}));
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04099, (Object[])new Object[]{oidValue}));
                }
                MessageDecorator<? extends Message> message = container.getMessage();
                CodecControl<? extends Control> control = container.getLdapCodecService().newControl(oidValue);
                message.addControl(control);
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("Control OID : " + oidValue);
                }
            }
        });
        this.transitions[LdapStatesEnum.CONTROL_TYPE_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.CONTROL_TYPE_STATE, (Enum)LdapStatesEnum.CRITICALITY_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Set Criticality"){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                CodecControl<Control> control = null;
                MessageDecorator<? extends Message> message = container.getMessage();
                control = message.getCurrentControl();
                Value value = tlv.getValue();
                try {
                    control.setCritical(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04100, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), bde.getMessage()}));
                    throw new DecoderException(bde.getMessage());
                }
                container.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("Control criticality : " + control.isCritical());
                }
            }
        });
        this.transitions[LdapStatesEnum.CRITICALITY_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.CRITICALITY_STATE, (Enum)LdapStatesEnum.CONTROL_VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ControlValueAction());
        this.transitions[LdapStatesEnum.CONTROL_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.CONTROL_TYPE_STATE, (Enum)LdapStatesEnum.CONTROL_VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new ControlValueAction());
        this.transitions[LdapStatesEnum.CONTROL_TYPE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.CONTROL_TYPE_STATE, (Enum)LdapStatesEnum.CONTROL_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)addControl);
        this.transitions[LdapStatesEnum.CRITICALITY_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.CRITICALITY_STATE, (Enum)LdapStatesEnum.CONTROL_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)addControl);
        this.transitions[LdapStatesEnum.CONTROL_VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.CONTROL_VALUE_STATE, (Enum)LdapStatesEnum.CONTROL_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)addControl);
        this.transitions[LdapStatesEnum.MESSAGE_ID_STATE.ordinal()][99] = new GrammarTransition((Enum)LdapStatesEnum.MESSAGE_ID_STATE, (Enum)LdapStatesEnum.SEARCH_REQUEST_STATE, 99, (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("Init SearchRequest"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) {
                TLV tlv = container.getCurrentTLV();
                SearchRequestDecorator searchRequest = new SearchRequestDecorator(container.getLdapCodecService(), (SearchRequest)new SearchRequestImpl(container.getMessageId()));
                searchRequest.setTlvId(tlv.getId());
                container.setMessage(searchRequest);
                LOG.debug("Search Request");
            }
        });
        this.transitions[LdapStatesEnum.SEARCH_REQUEST_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.SEARCH_REQUEST_STATE, (Enum)LdapStatesEnum.BASE_OBJECT_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("store base object value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequestDecorator searchRequestDecorator = container.getMessage();
                SearchRequest searchRequest = (SearchRequest)searchRequestDecorator.getDecorated();
                TLV tlv = container.getCurrentTLV();
                Dn baseObject = null;
                if (tlv.getLength() != 0) {
                    byte[] dnBytes = tlv.getValue().getData();
                    String dnStr = Strings.utf8ToString((byte[])dnBytes);
                    try {
                        baseObject = new Dn(dnStr);
                    }
                    catch (LdapInvalidDnException ine) {
                        String msg = "Invalid root Dn given : " + dnStr + " (" + Strings.dumpBytes((byte[])dnBytes) + ") is invalid";
                        LOG.error("{} : {}", (Object)msg, (Object)ine.getMessage());
                        SearchResultDoneImpl response = new SearchResultDoneImpl(searchRequest.getMessageId());
                        throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, Dn.EMPTY_DN, ine);
                    }
                } else {
                    baseObject = Dn.EMPTY_DN;
                }
                searchRequest.setBase(baseObject);
                LOG.debug("Searching with root Dn : {}", (Object)baseObject);
            }
        });
        this.transitions[LdapStatesEnum.BASE_OBJECT_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.BASE_OBJECT_STATE, (Enum)LdapStatesEnum.SCOPE_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("store scope value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
                TLV tlv = container.getCurrentTLV();
                Value value = tlv.getValue();
                int scope = 0;
                try {
                    scope = IntegerDecoder.parse((Value)value, (int)0, (int)2);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_04101, (Object[])new Object[]{value.toString()});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                searchRequest.setScope(SearchScope.getSearchScope((int)scope));
                if (IS_DEBUG) {
                    switch (scope) {
                        case 0: {
                            LOG.debug("Searching within BASE_OBJECT scope ");
                            break;
                        }
                        case 1: {
                            LOG.debug("Searching within SINGLE_LEVEL scope ");
                            break;
                        }
                        case 2: {
                            LOG.debug("Searching within WHOLE_SUBTREE scope ");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.SCOPE_STATE.ordinal()][UniversalTag.ENUMERATED.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.SCOPE_STATE, (Enum)LdapStatesEnum.DEREF_ALIAS_STATE, (int)UniversalTag.ENUMERATED.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("store derefAliases value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
                TLV tlv = container.getCurrentTLV();
                Value value = tlv.getValue();
                int derefAliases = 0;
                try {
                    derefAliases = IntegerDecoder.parse((Value)value, (int)0, (int)3);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_04102, (Object[])new Object[]{value.toString()});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                searchRequest.setDerefAliases(AliasDerefMode.getDerefMode((int)derefAliases));
                if (IS_DEBUG) {
                    switch (derefAliases) {
                        case 0: {
                            LOG.debug("Handling object strategy : NEVER_DEREF_ALIASES");
                            break;
                        }
                        case 1: {
                            LOG.debug("Handling object strategy : DEREF_IN_SEARCHING");
                            break;
                        }
                        case 2: {
                            LOG.debug("Handling object strategy : DEREF_FINDING_BASE_OBJ");
                            break;
                        }
                        case 3: {
                            LOG.debug("Handling object strategy : DEREF_ALWAYS");
                        }
                    }
                }
            }
        });
        this.transitions[LdapStatesEnum.DEREF_ALIAS_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.DEREF_ALIAS_STATE, (Enum)LdapStatesEnum.SIZE_LIMIT_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("store sizeLimit value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
                TLV tlv = container.getCurrentTLV();
                Value value = tlv.getValue();
                long sizeLimit = 0L;
                try {
                    sizeLimit = LongDecoder.parse((Value)value, (long)0L, (long)Integer.MAX_VALUE);
                }
                catch (LongDecoderException lde) {
                    String msg = I18n.err((I18n)I18n.ERR_04103, (Object[])new Object[]{value.toString()});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                searchRequest.setSizeLimit(sizeLimit);
                if (IS_DEBUG) {
                    LOG.debug("The sizeLimit value is set to {} objects", (Object)sizeLimit);
                }
            }
        });
        this.transitions[LdapStatesEnum.SIZE_LIMIT_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.SIZE_LIMIT_STATE, (Enum)LdapStatesEnum.TIME_LIMIT_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("store timeLimit value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
                TLV tlv = container.getCurrentTLV();
                Value value = tlv.getValue();
                int timeLimit = 0;
                try {
                    timeLimit = IntegerDecoder.parse((Value)value, (int)0, (int)Integer.MAX_VALUE);
                }
                catch (IntegerDecoderException ide) {
                    String msg = I18n.err((I18n)I18n.ERR_04104, (Object[])new Object[]{value.toString()});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                searchRequest.setTimeLimit(timeLimit);
                if (IS_DEBUG) {
                    LOG.debug("The timeLimit value is set to {} seconds", (Object)timeLimit);
                }
            }
        });
        this.transitions[LdapStatesEnum.TIME_LIMIT_STATE.ordinal()][UniversalTag.BOOLEAN.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.TIME_LIMIT_STATE, (Enum)LdapStatesEnum.TYPES_ONLY_STATE, (int)UniversalTag.BOOLEAN.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("store typesOnly value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequest searchRequest = (SearchRequest)container.getMessage().getDecorated();
                TLV tlv = container.getCurrentTLV();
                Value value = tlv.getValue();
                try {
                    searchRequest.setTypesOnly(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04105, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), bde.getMessage()}));
                    throw new DecoderException(bde.getMessage());
                }
                if (IS_DEBUG) {
                    LOG.debug("The search will return {}", (Object)(searchRequest.getTypesOnly() ? "only attributs type" : "attributes types and values"));
                }
            }
        });
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.TYPES_ONLY_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.TYPES_ONLY_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.AND_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.AND_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.OR_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.OR_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.NOT_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.NOT_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.EQUALITY_MATCH_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESC_FILTER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new InitAttributeDescFilterAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_DESC_FILTER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_DESC_FILTER_STATE, (Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new InitAssertionValueFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ASSERTION_VALUE_FILTER_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new InitAttributeDescListAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new AttributeDescAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_DESCRIPTION_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new AttributeDescAction());
        this.transitions[LdapStatesEnum.ATTRIBUTE_DESCRIPTION_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_STATE, (Enum)LdapStatesEnum.CONTROLS_STATE, 160, (Action)new ControlsInitAction());
        this.transitions[LdapStatesEnum.GREATER_OR_EQUAL_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESC_FILTER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new InitAttributeDescFilterAction());
        this.transitions[LdapStatesEnum.LESS_OR_EQUAL_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESC_FILTER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new InitAttributeDescFilterAction());
        this.transitions[LdapStatesEnum.SUBSTRING_FILTER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, (Enum)LdapStatesEnum.TYPE_SUBSTRING_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("Store substring filter type"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequestDecorator searchRequestDecorator = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequestDecorator.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04106, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                String type = LdapMessageGrammar.getType(tlv.getValue().getData());
                substringFilter.setType(type);
                searchRequestDecorator.setTerminalFilter(substringFilter);
            }
        });
        this.transitions[LdapStatesEnum.TYPE_SUBSTRING_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.TYPE_SUBSTRING_STATE, (Enum)LdapStatesEnum.SUBSTRINGS_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction<LdapMessageContainer<MessageDecorator<? extends Message>>>("Substring Filter substringsSequence "){

            public void action(LdapMessageContainer<MessageDecorator<? extends Message>> container) throws DecoderException {
                TLV tlv = container.getCurrentTLV();
                if (tlv.getLength() == 0) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04107, (Object[])new Object[0]));
                    throw new DecoderException("The substring sequence is empty");
                }
            }
        });
        this.transitions[LdapStatesEnum.SUBSTRINGS_STATE.ordinal()][128] = new GrammarTransition((Enum)LdapStatesEnum.SUBSTRINGS_STATE, (Enum)LdapStatesEnum.INITIAL_STATE, 128, (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("Store substring filter initial Value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequestDecorator searchRequestDecorator = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                SubstringFilter substringFilter = (SubstringFilter)searchRequestDecorator.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04108, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                substringFilter.setInitialSubstrings(Strings.utf8ToString((byte[])tlv.getValue().getData()));
                searchRequestDecorator.unstackFilters((Asn1Container)container);
            }
        });
        this.transitions[LdapStatesEnum.SUBSTRINGS_STATE.ordinal()][129] = new GrammarTransition((Enum)LdapStatesEnum.SUBSTRINGS_STATE, (Enum)LdapStatesEnum.ANY_STATE, 129, (Action)new StoreAnyAction());
        this.transitions[LdapStatesEnum.SUBSTRINGS_STATE.ordinal()][130] = new GrammarTransition((Enum)LdapStatesEnum.SUBSTRINGS_STATE, (Enum)LdapStatesEnum.FINAL_STATE, 130, (Action)new StoreFinalAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][129] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.ANY_STATE, 129, (Action)new StoreAnyAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][130] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.FINAL_STATE, 130, (Action)new StoreFinalAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new InitAttributeDescListAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.INITIAL_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.INITIAL_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][130] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.FINAL_STATE, 130, (Action)new StoreFinalAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][129] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.ANY_STATE, 129, (Action)new StoreAnyAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new InitAttributeDescListAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.ANY_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.ANY_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new InitAttributeDescListAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.FINAL_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.FINAL_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.PRESENT_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.PRESENT_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new InitAttributeDescListAction());
        this.transitions[LdapStatesEnum.APPROX_MATCH_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.APPROX_MATCH_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESC_FILTER_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new InitAttributeDescFilterAction());
        this.transitions[LdapStatesEnum.EXTENSIBLE_MATCH_STATE.ordinal()][129] = new GrammarTransition((Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, (Enum)LdapStatesEnum.MATCHING_RULE_STATE, 129, (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("Store matching rule Value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequestDecorator searchRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04109, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(I18n.err((I18n)I18n.ERR_04109, (Object[])new Object[0]));
                }
                extensibleMatchFilter.setMatchingRule(Strings.utf8ToString((byte[])tlv.getValue().getData()));
            }
        });
        this.transitions[LdapStatesEnum.EXTENSIBLE_MATCH_STATE.ordinal()][130] = new GrammarTransition((Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, (Enum)LdapStatesEnum.TYPE_MATCHING_RULE_STATE, 130, (Action)new StoreTypeMatchingRuleAction());
        this.transitions[LdapStatesEnum.EXTENSIBLE_MATCH_STATE.ordinal()][131] = new GrammarTransition((Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, (Enum)LdapStatesEnum.MATCH_VALUE_STATE, 131, (Action)new StoreMatchValueAction());
        this.transitions[LdapStatesEnum.MATCHING_RULE_STATE.ordinal()][130] = new GrammarTransition((Enum)LdapStatesEnum.MATCHING_RULE_STATE, (Enum)LdapStatesEnum.TYPE_MATCHING_RULE_STATE, 130, (Action)new StoreTypeMatchingRuleAction());
        this.transitions[LdapStatesEnum.MATCHING_RULE_STATE.ordinal()][131] = new GrammarTransition((Enum)LdapStatesEnum.MATCHING_RULE_STATE, (Enum)LdapStatesEnum.MATCH_VALUE_STATE, 131, (Action)new StoreMatchValueAction());
        this.transitions[LdapStatesEnum.TYPE_MATCHING_RULE_STATE.ordinal()][131] = new GrammarTransition((Enum)LdapStatesEnum.TYPE_MATCHING_RULE_STATE, (Enum)LdapStatesEnum.MATCH_VALUE_STATE, 131, (Action)new StoreMatchValueAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][132] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, 132, (Action)new GrammarAction<LdapMessageContainer<SearchRequestDecorator>>("Store matching dnAttributes Value"){

            public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
                SearchRequestDecorator searchRequest = container.getMessage();
                TLV tlv = container.getCurrentTLV();
                ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)searchRequest.getTerminalFilter();
                Value value = tlv.getValue();
                try {
                    extensibleMatchFilter.setDnAttributes(BooleanDecoder.parse((Value)value));
                }
                catch (BooleanDecoderException bde) {
                    LOG.error(I18n.err((I18n)I18n.ERR_04110, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData()), bde.getMessage()}));
                    throw new DecoderException(bde.getMessage());
                }
                if (IS_DEBUG) {
                    LOG.debug("Dn Attributes : {}", (Object)extensibleMatchFilter.isDnAttributes());
                }
                searchRequest.unstackFilters((Asn1Container)container);
            }
        });
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.MATCH_VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.MATCH_VALUE_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new InitAttributeDescListAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][160] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.AND_STATE, 160, (Action)new InitAndFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][161] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.OR_STATE, 161, (Action)new InitOrFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][162] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.NOT_STATE, 162, (Action)new InitNotFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][163] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.EQUALITY_MATCH_STATE, 163, (Action)new InitEqualityMatchFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][164] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.SUBSTRING_FILTER_STATE, 164, (Action)new InitSubstringsFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][165] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.GREATER_OR_EQUAL_STATE, 165, (Action)new InitGreaterOrEqualFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][166] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.LESS_OR_EQUAL_STATE, 166, (Action)new InitLessOrEqualFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][135] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.PRESENT_STATE, 135, (Action)new InitPresentFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][168] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.APPROX_MATCH_STATE, 168, (Action)new InitApproxMatchFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][169] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.EXTENSIBLE_MATCH_STATE, 169, (Action)new InitExtensibleMatchFilterAction());
        this.transitions[LdapStatesEnum.DN_ATTRIBUTES_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)LdapStatesEnum.DN_ATTRIBUTES_STATE, (Enum)LdapStatesEnum.ATTRIBUTE_DESCRIPTION_LIST_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new InitAttributeDescListAction());
    }

    public static Grammar getInstance() {
        return instance;
    }

    public static String getType(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] chars = new char[bytes.length];
        int pos = 0;
        for (byte b : bytes) {
            chars[pos++] = (char)b;
        }
        return new String(chars);
    }
}

