/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeDescAction
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeDescAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public AttributeDescAction() {
        super("Store attribute description");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        String attributeDescription = null;
        if (tlv.getLength() != 0 && !Strings.isEmpty((String)(attributeDescription = Strings.utf8ToString((byte[])tlv.getValue().getData())).trim())) {
            ((SearchRequest)searchRequestDecorator.getDecorated()).addAttributes(new String[]{attributeDescription});
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Decoded Attribute Description : {}", (Object)attributeDescription);
        }
    }
}

