/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.StringValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitAssertionValueFilterAction
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(InitAssertionValueFilterAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public InitAssertionValueFilterAction() {
        super("Initialize Assertion Value filter");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        BinaryValue assertionValue = null;
        assertionValue = tlv.getLength() != 0 ? new BinaryValue(tlv.getValue().getData()) : new BinaryValue(StringConstants.EMPTY_BYTES);
        AttributeValueAssertionFilter terminalFilter = (AttributeValueAssertionFilter)searchRequestDecorator.getTerminalFilter();
        AttributeValueAssertion assertion = terminalFilter.getAssertion();
        if (container.isBinary(assertion.getAttributeDesc())) {
            assertionValue = tlv.getLength() != 0 ? new BinaryValue(tlv.getValue().getData()) : new BinaryValue(StringConstants.EMPTY_BYTES);
            assertion.setAssertionValue((Value<?>)assertionValue);
        } else {
            assertionValue = tlv.getLength() != 0 ? new StringValue(Strings.utf8ToString((byte[])tlv.getValue().getData())) : new StringValue("");
            assertion.setAssertionValue((Value<?>)assertionValue);
        }
        searchRequestDecorator.unstackFilters((Asn1Container)container);
        if (IS_DEBUG) {
            LOG.debug("Initialize Assertion Value filter");
        }
    }
}

