/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.ModifyRequestDecorator;
import org.apache.directory.shared.util.StringConstants;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyAttributeValueAction
extends GrammarAction<LdapMessageContainer<ModifyRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyAttributeValueAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public ModifyAttributeValueAction() {
        super("Stores AttributeValue");
    }

    public void action(LdapMessageContainer<ModifyRequestDecorator> container) {
        ModifyRequestDecorator modifyRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        byte[] value = StringConstants.EMPTY_BYTES;
        if (tlv.getLength() == 0) {
            modifyRequestDecorator.addAttributeValue("");
        } else {
            value = tlv.getValue().getData();
            if (container.isBinary(modifyRequestDecorator.getCurrentAttributeType())) {
                modifyRequestDecorator.addAttributeValue(value);
            } else {
                modifyRequestDecorator.addAttributeValue(Strings.utf8ToString((byte[])value));
            }
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Value modified : {}", (Object)value);
        }
    }
}

