/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.ExtendedResponseDecorator;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.util.StringConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResponseAction
extends GrammarAction<LdapMessageContainer<ExtendedResponseDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public ResponseAction() {
        super("Store response");
    }

    public void action(LdapMessageContainer<ExtendedResponseDecorator> container) throws DecoderException {
        ExtendedResponse extendedResponse = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            extendedResponse.setResponseValue(StringConstants.EMPTY_BYTES);
        } else {
            extendedResponse.setResponseValue(tlv.getValue().getData());
        }
        container.setGrammarEndAllowed(true);
        if (IS_DEBUG) {
            LOG.debug("Extended value : {}", (Object)extendedResponse.getResponseValue());
        }
    }
}

