/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.actions;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.model.entry.BinaryValue;
import org.apache.directory.shared.ldap.model.entry.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoreMatchValueAction
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreMatchValueAction.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreMatchValueAction() {
        super("Store match Value");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) throws DecoderException {
        SearchRequestDecorator decorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        ExtensibleMatchFilter extensibleMatchFilter = (ExtensibleMatchFilter)decorator.getTerminalFilter();
        byte[] value = tlv.getValue().getData();
        extensibleMatchFilter.setMatchValue((Value<?>)new BinaryValue(value));
        decorator.unstackFilters((Asn1Container)container);
        if (IS_DEBUG) {
            LOG.debug("Stored a match value : {}", (Object)value);
        }
    }
}

