/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.api;

import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.naming.ldap.BasicControl;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.ldap.codec.BasicControlDecorator;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.ldap.codec.api.CodecControl;
import org.apache.directory.shared.ldap.codec.api.ControlFactory;
import org.apache.directory.shared.ldap.codec.api.ExtendedOpFactory;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.shared.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.shared.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.shared.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.shared.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.shared.ldap.codec.protocol.mina.LdapProtocolCodecFactory;
import org.apache.directory.shared.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncInfoValueFactory;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncModifyDnFactory;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory;
import org.apache.directory.shared.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.shared.util.exception.NotImplementedException;
import org.apache.mina.filter.codec.ProtocolCodecFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultLdapCodecService
implements LdapCodecService {
    Map<String, ControlFactory<?, ?>> controlFactories = new HashMap();
    Map<String, ExtendedOpFactory<?, ?>> extReqFactories = new HashMap();
    Map<String, ExtendedOpFactory<?, ?>> extResFactories = new HashMap();

    public DefaultLdapCodecService() {
        this.loadStockControls();
    }

    private void loadStockControls() {
        CascadeFactory cascadeFactory = new CascadeFactory(this);
        this.controlFactories.put("1.3.6.1.4.1.18060.0.0.1", cascadeFactory);
        EntryChangeFactory entryChangeFactory = new EntryChangeFactory(this);
        this.controlFactories.put("2.16.840.1.113730.3.4.7", entryChangeFactory);
        ManageDsaITFactory manageDsaITFactory = new ManageDsaITFactory(this);
        this.controlFactories.put("2.16.840.1.113730.3.4.2", manageDsaITFactory);
        PagedResultsFactory pagedResultsFactory = new PagedResultsFactory(this);
        this.controlFactories.put("1.2.840.113556.1.4.319", pagedResultsFactory);
        PersistentSearchFactory persistentSearchFactory = new PersistentSearchFactory(this);
        this.controlFactories.put("2.16.840.1.113730.3.4.3", persistentSearchFactory);
        SubentriesFactory subentriesFactory = new SubentriesFactory(this);
        this.controlFactories.put("1.3.6.1.4.1.4203.1.10.1", subentriesFactory);
        SyncDoneValueFactory syncDoneValueFactory = new SyncDoneValueFactory(this);
        this.controlFactories.put("1.3.6.1.4.1.4203.1.9.1.3", syncDoneValueFactory);
        SyncInfoValueFactory syncInfoValueFactory = new SyncInfoValueFactory(this);
        this.controlFactories.put("1.3.6.1.4.1.4203.1.9.1.4", syncInfoValueFactory);
        SyncModifyDnFactory syncModifyDnFactory = new SyncModifyDnFactory(this);
        this.controlFactories.put("1.3.6.1.4.1.4203.1.9.1.5", syncModifyDnFactory);
        SyncRequestValueFactory syncRequestValueFactory = new SyncRequestValueFactory(this);
        this.controlFactories.put("1.3.6.1.4.1.4203.1.9.1.1", syncRequestValueFactory);
        SyncStateValueFactory syncStateValueFactory = new SyncStateValueFactory(this);
        this.controlFactories.put("1.3.6.1.4.1.4203.1.9.1.2", syncStateValueFactory);
        PasswordPolicyFactory passwordPolicyFactory = new PasswordPolicyFactory(this);
        this.controlFactories.put("1.3.6.1.4.1.42.2.27.8.5.1", passwordPolicyFactory);
    }

    @Override
    public void registerControl(ControlFactory<?, ?> factory) {
        this.controlFactories.put(factory.getOid(), factory);
    }

    @Override
    public Iterator<String> registeredControls() {
        return Collections.unmodifiableSet(this.controlFactories.keySet()).iterator();
    }

    @Override
    public Iterator<String> registeredExtendedRequests() {
        return Collections.unmodifiableSet(this.extReqFactories.keySet()).iterator();
    }

    @Override
    public Iterator<String> registeredExtendedResponses() {
        return Collections.unmodifiableSet(this.extResFactories.keySet()).iterator();
    }

    @Override
    public void registerExtendedOp(ExtendedOpFactory<?, ?> factory) {
        this.extReqFactories.put(factory.getRequestOid(), factory);
    }

    @Override
    public ProtocolCodecFactory newProtocolCodecFactory(boolean client) {
        if (client) {
            return new LdapProtocolCodecFactory();
        }
        throw new NotImplementedException("Filters may be different here, and we're probably going to want to have a protocol codec factory registration mechanismsince this way we can swap in and out MINA/Grizzly");
    }

    @Override
    public CodecControl<? extends Control> newControl(String oid) {
        ControlFactory<?, ?> factory = this.controlFactories.get(oid);
        if (factory == null) {
            return new BasicControlDecorator((LdapCodecService)this, (Control)new OpaqueControl(oid));
        }
        return factory.newCodecControl();
    }

    @Override
    public CodecControl<? extends Control> newControl(Control control) {
        if (control == null) {
            throw new NullPointerException("Control argument was null.");
        }
        if (control instanceof CodecControl) {
            return (CodecControl)control;
        }
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getOid());
        if (factory == null) {
            return new BasicControlDecorator((LdapCodecService)this, control);
        }
        return factory.newCodecControl(control);
    }

    @Override
    public javax.naming.ldap.Control toJndiControl(Control control) throws EncoderException {
        CodecControl<? extends Control> decorator = this.newControl(control);
        ByteBuffer bb = ByteBuffer.allocate(decorator.computeLength());
        decorator.encode(bb);
        bb.flip();
        BasicControl jndiControl = new BasicControl(control.getOid(), control.isCritical(), bb.array());
        return jndiControl;
    }

    @Override
    public Control fromJndiControl(javax.naming.ldap.Control control) throws DecoderException {
        ControlFactory<?, ?> factory = this.controlFactories.get(control.getID());
        if (factory == null) {
            OpaqueControl ourControl = new OpaqueControl(control.getID());
            ourControl.setCritical(control.isCritical());
            BasicControlDecorator decorator = new BasicControlDecorator((LdapCodecService)this, (Control)ourControl);
            decorator.setValue(control.getEncodedValue());
            return decorator;
        }
        Object ourControl = factory.newCodecControl();
        ourControl.setCritical(control.isCritical());
        ourControl.setValue(control.getEncodedValue());
        ourControl.decode(control.getEncodedValue());
        return ourControl;
    }

    @Override
    public Asn1Container newMessageContainer() {
        return new LdapMessageContainer(this);
    }
}

