/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.search.pagedSearch;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.directory.shared.asn1.Asn1Object;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.controls.ControlDecorator;
import org.apache.directory.shared.ldap.codec.controls.search.pagedSearch.PagedResultsContainer;
import org.apache.directory.shared.ldap.model.message.controls.PagedResults;
import org.apache.directory.shared.ldap.model.message.controls.PagedResultsImpl;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PagedResultsDecorator
extends ControlDecorator<PagedResults>
implements PagedResults {
    private int pscSeqLength;
    private static final Asn1Decoder decoder = new Asn1Decoder();

    public PagedResultsDecorator(LdapCodecService codec) {
        this(codec, (PagedResults)new PagedResultsImpl());
    }

    public PagedResultsDecorator(LdapCodecService codec, PagedResults pagedResults) {
        super(codec, pagedResults);
    }

    @Override
    public int computeLength() {
        int sizeLength = 2 + Value.getNbBytes((int)this.getSize());
        int cookieLength = this.getCookie() != null ? 1 + TLV.getNbBytes((int)this.getCookie().length) + this.getCookie().length : 2;
        this.pscSeqLength = sizeLength + cookieLength;
        this.valueLength = 1 + TLV.getNbBytes((int)this.pscSeqLength) + this.pscSeqLength;
        return this.valueLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04023, (Object[])new Object[0]));
        }
        buffer.put(UniversalTag.SEQUENCE.getValue());
        buffer.put(TLV.getBytes((int)this.pscSeqLength));
        Value.encode((ByteBuffer)buffer, (int)this.getSize());
        Value.encode((ByteBuffer)buffer, (byte[])this.getCookie());
        return buffer;
    }

    @Override
    public byte[] getValue() {
        if (this.value == null) {
            try {
                this.computeLength();
                ByteBuffer buffer = ByteBuffer.allocate(this.valueLength);
                buffer.put(UniversalTag.SEQUENCE.getValue());
                buffer.put(TLV.getBytes((int)this.pscSeqLength));
                Value.encode((ByteBuffer)buffer, (int)this.getSize());
                Value.encode((ByteBuffer)buffer, (byte[])this.getCookie());
                this.value = buffer.array();
            }
            catch (Exception e) {
                return null;
            }
        }
        return this.value;
    }

    public int getSize() {
        return ((PagedResults)this.getDecorated()).getSize();
    }

    public void setSize(int size) {
        ((PagedResults)this.getDecorated()).setSize(size);
    }

    public byte[] getCookie() {
        return ((PagedResults)this.getDecorated()).getCookie();
    }

    public void setCookie(byte[] cookie) {
        if (!Strings.isEmpty((byte[])cookie)) {
            byte[] copy = new byte[cookie.length];
            System.arraycopy(cookie, 0, copy, 0, cookie.length);
            ((PagedResults)this.getDecorated()).setCookie(copy);
        } else {
            ((PagedResults)this.getDecorated()).setCookie(null);
        }
    }

    public int getCookieValue() {
        int value = 0;
        switch (this.getCookie().length) {
            case 1: {
                value = this.getCookie()[0] & 0xFF;
                break;
            }
            case 2: {
                value = ((this.getCookie()[0] & 0xFF) << 8) + (this.getCookie()[1] & 0xFF);
                break;
            }
            case 3: {
                value = ((this.getCookie()[0] & 0xFF) << 16) + ((this.getCookie()[1] & 0xFF) << 8) + (this.getCookie()[2] & 0xFF);
                break;
            }
            case 4: {
                value = ((this.getCookie()[0] & 0xFF) << 24) + ((this.getCookie()[1] & 0xFF) << 16) + ((this.getCookie()[2] & 0xFF) << 8) + (this.getCookie()[3] & 0xFF);
            }
        }
        return value;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        PagedResults otherControl = (PagedResults)o;
        return this.getSize() == otherControl.getSize() && Arrays.equals(this.getCookie(), otherControl.getCookie());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    Paged Search Control\n");
        sb.append("        oid : ").append(this.getOid()).append('\n');
        sb.append("        critical : ").append(this.isCritical()).append('\n');
        sb.append("        size   : '").append(this.getSize()).append("'\n");
        sb.append("        cookie   : '").append(Strings.dumpBytes((byte[])this.getCookie())).append("'\n");
        return sb.toString();
    }

    @Override
    public Asn1Object decode(byte[] controlBytes) throws DecoderException {
        ByteBuffer bb = ByteBuffer.wrap(controlBytes);
        PagedResultsContainer container = new PagedResultsContainer(this.getCodecService(), this);
        decoder.decode(bb, (Asn1Container)container);
        return this;
    }
}

