/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.api.LdapCodecService;
import org.apache.directory.shared.ldap.codec.decorators.LdapResultDecorator;
import org.apache.directory.shared.ldap.codec.decorators.ResponseDecorator;
import org.apache.directory.shared.ldap.model.message.ExtendedResponse;
import org.apache.directory.shared.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedResponseDecorator
extends ResponseDecorator<ExtendedResponse>
implements ExtendedResponse {
    private static final long serialVersionUID = -9029282485890195506L;
    private byte[] responseNameBytes;
    private int extendedResponseLength;

    public ExtendedResponseDecorator(LdapCodecService codec, ExtendedResponse decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public byte[] getResponseNameBytes() {
        return this.responseNameBytes;
    }

    public void setResponseNameBytes(byte[] responseNameBytes) {
        this.responseNameBytes = responseNameBytes;
    }

    public void setExtendedResponseLength(int extendedResponseLength) {
        this.extendedResponseLength = extendedResponseLength;
    }

    public int getExtendedResponseLength() {
        return this.extendedResponseLength;
    }

    public byte[] getEncodedValue() {
        return ((ExtendedResponse)this.getDecorated()).getEncodedValue();
    }

    public String getID() {
        return ((ExtendedResponse)this.getDecorated()).getID();
    }

    public String getResponseName() {
        return ((ExtendedResponse)this.getDecorated()).getResponseName();
    }

    public void setResponseName(String oid) {
        ((ExtendedResponse)this.getDecorated()).setResponseName(oid);
    }

    public byte[] getResponseValue() {
        return ((ExtendedResponse)this.getDecorated()).getEncodedValue();
    }

    public void setResponseValue(byte[] responseValue) {
        ((ExtendedResponse)this.getDecorated()).setResponseValue(responseValue);
    }

    @Override
    public int computeLength() {
        byte[] encodedValue;
        int ldapResultLength;
        int extendedResponseLength = ldapResultLength = ((LdapResultDecorator)this.getLdapResult()).computeLength();
        String id = this.getResponseName();
        if (!Strings.isEmpty((String)id)) {
            byte[] idBytes = Strings.getBytesUtf8((String)id);
            this.setResponseNameBytes(idBytes);
            int idLength = idBytes.length;
            extendedResponseLength += 1 + TLV.getNbBytes((int)idLength) + idLength;
        }
        if ((encodedValue = this.getResponseValue()) != null) {
            extendedResponseLength += 1 + TLV.getNbBytes((int)encodedValue.length) + encodedValue.length;
        }
        this.setExtendedResponseLength(extendedResponseLength);
        return 1 + TLV.getNbBytes((int)extendedResponseLength) + extendedResponseLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            byte[] encodedValue;
            buffer.put((byte)120);
            buffer.put(TLV.getBytes((int)this.getExtendedResponseLength()));
            ((LdapResultDecorator)this.getLdapResult()).encode(buffer);
            byte[] idBytes = this.getResponseNameBytes();
            if (idBytes != null) {
                buffer.put((byte)-118);
                buffer.put(TLV.getBytes((int)idBytes.length));
                if (idBytes.length != 0) {
                    buffer.put(idBytes);
                }
            }
            if ((encodedValue = this.getResponseValue()) != null) {
                buffer.put((byte)-117);
                buffer.put(TLV.getBytes((int)encodedValue.length));
                if (encodedValue.length != 0) {
                    buffer.put(encodedValue);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err((I18n)I18n.ERR_04005, (Object[])new Object[0]));
        }
        return buffer;
    }
}

