/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.protocol.mina;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.Asn1Decoder;
import org.apache.directory.shared.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.shared.ldap.codec.LdapMessageContainer;
import org.apache.directory.shared.util.Strings;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.codec.ProtocolDecoder;
import org.apache.mina.filter.codec.ProtocolDecoderOutput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapProtocolDecoder
implements ProtocolDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(LdapProtocolDecoder.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public void decode(IoSession session, IoBuffer buffer, ProtocolDecoderOutput out) throws Exception {
        Asn1Decoder ldapDecoder = new Asn1Decoder();
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)((Object)session.getAttribute((Object)"LDAP-Container"));
        ByteBuffer buf = buffer.buf();
        int currentPos = 0;
        while (buf.hasRemaining()) {
            try {
                ldapDecoder.decode(buf, (Asn1Container)ldapMessageContainer);
                if (IS_DEBUG) {
                    LOG.debug("Decoding the PDU : ");
                    int pos = buf.position();
                    byte[] b = new byte[pos - currentPos];
                    System.arraycopy(buf.array(), currentPos, b, 0, pos - currentPos);
                    currentPos = pos;
                    LOG.debug("Received buffer : " + Strings.dumpBytes((byte[])b));
                }
                if (ldapMessageContainer.getState() != TLVStateEnum.PDU_DECODED) continue;
                Object message = ldapMessageContainer.getMessage();
                if (IS_DEBUG) {
                    LOG.debug("Decoded LdapMessage : " + message);
                    buf.mark();
                }
                ldapMessageContainer.clean();
                out.write(message);
            }
            catch (DecoderException de) {
                buf.clear();
                ldapMessageContainer.clean();
                throw de;
            }
        }
    }

    public void finishDecode(IoSession session, ProtocolDecoderOutput out) throws Exception {
    }

    public void dispose(IoSession session) throws Exception {
    }
}

