/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.CancelResponse;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.Cancel;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.CancelDecoder;
import org.apache.directory.shared.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CancelRequest
extends ExtendedRequestImpl {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(CancelRequest.class);
    private int cancelId;
    public static final String EXTENSION_OID = "1.3.6.1.1.8";

    public CancelRequest(int messageId, int cancelId) {
        super(messageId);
        this.setRequestName(EXTENSION_OID);
        this.cancelId = cancelId;
    }

    public void setRequestValue(byte[] requestValue) {
        CancelDecoder decoder = new CancelDecoder();
        try {
            Cancel cancel = (Cancel)decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
            this.cancelId = cancel.getCancelId();
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return (ExtendedResponse)this.getResultResponse();
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                Cancel cancel = new Cancel();
                cancel.setCancelId(this.cancelId);
                this.requestValue = cancel.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04164, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new CancelResponse(this.cancelId);
        }
        return this.response;
    }
}

