/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.util.StringConstants;

public class CancelResponse
extends ExtendedResponseImpl {
    private static final long serialVersionUID = 1L;

    public CancelResponse(int messageId, ResultCodeEnum rcode) {
        super(messageId);
        switch (rcode) {
            case SUCCESS: 
            case CANCELED: 
            case CANNOT_CANCEL: 
            case NO_SUCH_OPERATION: 
            case TOO_LATE: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04166, (Object[])new Object[]{ResultCodeEnum.SUCCESS, ResultCodeEnum.OPERATIONS_ERROR, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS}));
            }
        }
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public CancelResponse(int messageId) {
        super(messageId);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public byte[] getResponse() {
        return StringConstants.EMPTY_BYTES;
    }

    public String getResponseName() {
        return "";
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + ((Object)((Object)this)).getClass().getName().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof CancelResponse;
    }
}

