/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.CertGenerationResponse;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.CertGenerationDecoder;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.CertGenerationObject;
import org.apache.directory.shared.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertGenerationRequest
extends ExtendedRequestImpl {
    private static final long serialVersionUID = 1L;
    private CertGenerationObject certGenObj;
    private static final Logger LOG = LoggerFactory.getLogger(CertGenerationRequest.class);
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.8";

    public CertGenerationRequest(int messageId, String targerDN, String issuerDN, String subjectDN, String keyAlgorithm) {
        super(messageId);
        this.setRequestName(EXTENSION_OID);
        this.certGenObj = new CertGenerationObject();
        this.certGenObj.setTargetDN(targerDN);
        this.certGenObj.setIssuerDN(issuerDN);
        this.certGenObj.setSubjectDN(subjectDN);
        this.certGenObj.setKeyAlgorithm(keyAlgorithm);
    }

    public void setequestValue(byte[] requestValue) {
        CertGenerationDecoder decoder = new CertGenerationDecoder();
        try {
            this.certGenObj = (CertGenerationObject)decoder.decode(requestValue);
            if (requestValue != null) {
                this.requestValue = new byte[requestValue.length];
                System.arraycopy(requestValue, 0, this.requestValue, 0, requestValue.length);
            } else {
                this.requestValue = null;
            }
        }
        catch (DecoderException e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        return (ExtendedResponse)this.getResultResponse();
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.certGenObj.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04167, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (this.requestValue == null) {
            return null;
        }
        byte[] copy = new byte[this.requestValue.length];
        System.arraycopy(this.requestValue, 0, copy, 0, this.requestValue.length);
        return copy;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            this.response = new CertGenerationResponse(this.getMessageId());
        }
        return this.response;
    }

    public String getTargetDN() {
        return this.certGenObj.getTargetDN();
    }

    public void setTargetDN(String targetDN) {
        this.certGenObj.setTargetDN(targetDN);
    }

    public String getIssuerDN() {
        return this.certGenObj.getIssuerDN();
    }

    public void setIssuerDN(String issuerDN) {
        this.certGenObj.setIssuerDN(issuerDN);
    }

    public String getSubjectDN() {
        return this.certGenObj.getSubjectDN();
    }

    public void setSubjectDN(String subjectDN) {
        this.certGenObj.setSubjectDN(subjectDN);
    }

    public String getKeyAlgorithm() {
        return this.certGenObj.getKeyAlgorithm();
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.certGenObj.setKeyAlgorithm(keyAlgorithm);
    }
}

