/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.model.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.model.message.ResultCodeEnum;
import org.apache.directory.shared.util.StringConstants;

public class CertGenerationResponse
extends ExtendedResponseImpl {
    private static final long serialVersionUID = 1L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.9";

    public CertGenerationResponse(int messageId, ResultCodeEnum rcode) {
        super(messageId, EXTENSION_OID);
        switch (rcode) {
            case SUCCESS: 
            case OPERATIONS_ERROR: 
            case INSUFFICIENT_ACCESS_RIGHTS: {
                break;
            }
            default: {
                throw new IllegalArgumentException(I18n.err((I18n)I18n.ERR_04166, (Object[])new Object[]{ResultCodeEnum.SUCCESS, ResultCodeEnum.OPERATIONS_ERROR, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS}));
            }
        }
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(rcode);
    }

    public CertGenerationResponse(int messageId) {
        super(messageId, EXTENSION_OID);
        super.getLdapResult().setMatchedDn(null);
        super.getLdapResult().setResultCode(ResultCodeEnum.SUCCESS);
    }

    public byte[] getResponse() {
        return StringConstants.EMPTY_BYTES;
    }

    public void setResponse(byte[] value) {
    }

    public String getResponseName() {
        return EXTENSION_OID;
    }

    public void setResponseName(String oid) {
        throw new UnsupportedOperationException(I18n.err((I18n)I18n.ERR_04168, (Object[])new Object[]{EXTENSION_OID}));
    }

    public int hashCode() {
        int hash = 37;
        hash = hash * 17 + ((Object)((Object)this)).getClass().getName().hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        return obj instanceof CertGenerationResponse;
    }
}

