/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended;

import java.nio.ByteBuffer;
import javax.naming.NamingException;
import javax.naming.ldap.ExtendedResponse;
import org.apache.directory.shared.asn1.EncoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.StoredProcedureResponse;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.StoredProcedure;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.StoredProcedureContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.StoredProcedureDecoder;
import org.apache.directory.shared.ldap.model.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.model.message.ResultResponse;
import org.apache.directory.shared.util.Strings;
import org.apache.directory.shared.util.exception.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredProcedureRequest
extends ExtendedRequestImpl {
    private static final Logger LOG = LoggerFactory.getLogger(StoredProcedureRequest.class);
    private static final long serialVersionUID = -4682291068700593492L;
    public static final String EXTENSION_OID = "1.3.6.1.4.1.18060.0.1.6";
    private StoredProcedure procedure;

    public StoredProcedureRequest(int messageId) {
        super(messageId);
        this.setRequestName(EXTENSION_OID);
        this.procedure = new StoredProcedure();
    }

    public StoredProcedureRequest(int messageId, String procedure, String language) {
        super(messageId);
        this.setRequestName(EXTENSION_OID);
        this.procedure = new StoredProcedure();
        this.setLanguage(language);
        this.setProcedure(procedure);
    }

    public void setRequestValue(byte[] payload) {
        StoredProcedureDecoder decoder = new StoredProcedureDecoder();
        StoredProcedureContainer container = new StoredProcedureContainer();
        try {
            decoder.decode(ByteBuffer.wrap(payload), (Asn1Container)container);
            this.procedure = container.getStoredProcedure();
        }
        catch (Exception e) {
            LOG.error(I18n.err((I18n)I18n.ERR_04165, (Object[])new Object[0]), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public ExtendedResponse createExtendedResponse(String id, byte[] berValue, int offset, int length) throws NamingException {
        StoredProcedureResponse resp = (StoredProcedureResponse)this.getResultResponse();
        resp.setResponseValue(berValue);
        resp.setResponseName(id);
        return resp;
    }

    public byte[] getRequestValue() {
        if (this.requestValue == null) {
            try {
                this.requestValue = this.procedure.encode().array();
            }
            catch (EncoderException e) {
                LOG.error(I18n.err((I18n)I18n.ERR_04174, (Object[])new Object[0]), (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return this.requestValue;
    }

    public ResultResponse getResultResponse() {
        if (this.response == null) {
            StoredProcedureResponse spr = new StoredProcedureResponse(this.getMessageId());
            spr.setResponseName(EXTENSION_OID);
            this.response = spr;
        }
        return this.response;
    }

    public String getLanguage() {
        return this.procedure.getLanguage();
    }

    public void setLanguage(String language) {
        this.procedure.setLanguage(language);
    }

    public void setProcedure(String procedure) {
        this.procedure.setProcedure(Strings.getBytesUtf8((String)procedure));
    }

    public String getProcedureSpecification() {
        return Strings.utf8ToString((byte[])this.procedure.getProcedure());
    }

    public int size() {
        return this.procedure.getParameters().size();
    }

    public Object getParameterType(int index) {
        if (!this.procedure.getLanguage().equals("java")) {
            return this.procedure.getParameters().get(index).getType();
        }
        return this.getJavaParameterType(index);
    }

    public Class<?> getJavaParameterType(int index) {
        throw new NotImplementedException(I18n.err((I18n)I18n.ERR_04175, (Object[])new Object[0]));
    }

    public Object getParameterValue(int index) {
        if (!this.procedure.getLanguage().equals("java")) {
            return this.procedure.getParameters().get(index).getValue();
        }
        return this.getJavaParameterValue(index);
    }

    public Object getJavaParameterValue(int index) {
        throw new NotImplementedException(I18n.err((I18n)I18n.ERR_04176, (Object[])new Object[0]));
    }

    public void addParameter(Object type, Object value) {
        StoredProcedure.StoredProcedureParameter parameter = new StoredProcedure.StoredProcedureParameter();
        parameter.setType((byte[])type);
        parameter.setValue((byte[])value);
        this.procedure.addParameter(parameter);
    }
}

