/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnect;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnectContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulDisconnectStatesEnum;
import org.apache.directory.shared.ldap.model.exception.LdapURLEncodingException;
import org.apache.directory.shared.ldap.model.filter.LdapURL;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GracefulDisconnectGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(GracefulDisconnectGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar instance = new GracefulDisconnectGrammar();
    private GrammarAction storeDelay = new GrammarAction("Set Graceful Disconnect Delay"){

        public void action(Asn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                int delay = IntegerDecoder.parse((Value)value, (int)0, (int)86400);
                if (IS_DEBUG) {
                    LOG.debug("Delay = " + delay);
                }
                gracefulDisconnectContainer.getGracefulDisconnect().setDelay(delay);
                gracefulDisconnectContainer.setGrammarEndAllowed(true);
            }
            catch (IntegerDecoderException e) {
                String msg = I18n.err((I18n)I18n.ERR_04036, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                LOG.error(msg);
                throw new DecoderException(msg);
            }
        }
    };
    private GrammarAction storeReferral = new GrammarAction("Stores a referral"){

        public void action(Asn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                LdapURL url = new LdapURL(value.getData());
                gracefulDisconnectContainer.getGracefulDisconnect().addReplicatedContexts(url);
                gracefulDisconnectContainer.setGrammarEndAllowed(true);
                if (IS_DEBUG) {
                    LOG.debug("Stores a referral : {}", (Object)url);
                }
            }
            catch (LdapURLEncodingException e) {
                String msg = "failed to decode the URL '" + Strings.dumpBytes((byte[])value.getData()) + "'";
                LOG.error(msg);
                throw new DecoderException(msg);
            }
        }
    };
    private GrammarAction storeTimeOffline = new GrammarAction("Set Graceful Disconnect time offline"){

        public void action(Asn1Container container) throws DecoderException {
            GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
            Value value = gracefulDisconnectContainer.getCurrentTLV().getValue();
            try {
                int timeOffline = IntegerDecoder.parse((Value)value, (int)0, (int)720);
                if (IS_DEBUG) {
                    LOG.debug("Time Offline = " + timeOffline);
                }
                gracefulDisconnectContainer.getGracefulDisconnect().setTimeOffline(timeOffline);
                gracefulDisconnectContainer.setGrammarEndAllowed(true);
            }
            catch (IntegerDecoderException e) {
                String msg = I18n.err((I18n)I18n.ERR_04037, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                LOG.error(msg);
                throw new DecoderException(msg);
            }
        }
    };

    private GracefulDisconnectGrammar() {
        this.setName(GracefulDisconnectGrammar.class.getName());
        this.transitions = new GrammarTransition[GracefulDisconnectStatesEnum.LAST_GRACEFUL_DISCONNECT_STATE.ordinal()][256];
        this.transitions[GracefulDisconnectStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.START_STATE, (Enum)GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction("Init Graceful Disconnect"){

            public void action(Asn1Container container) {
                GracefulDisconnectContainer gracefulDisconnectContainer = (GracefulDisconnectContainer)container;
                GracefulDisconnect gracefulDisconnect = new GracefulDisconnect();
                gracefulDisconnectContainer.setGracefulDisconnect(gracefulDisconnect);
                gracefulDisconnectContainer.setGrammarEndAllowed(true);
            }
        });
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, (Enum)GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)this.storeTimeOffline);
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, (Enum)GracefulDisconnectStatesEnum.DELAY_STATE, 128, (Action)this.storeDelay);
        this.transitions[GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.GRACEFUL_DISCONNECT_SEQUENCE_STATE, (Enum)GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE.ordinal()][128] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, (Enum)GracefulDisconnectStatesEnum.DELAY_STATE, 128, (Action)this.storeDelay);
        this.transitions[GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.TIME_OFFLINE_STATE, (Enum)GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[GracefulDisconnectStatesEnum.DELAY_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.DELAY_STATE, (Enum)GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.REPLICATED_CONTEXTS_STATE, (Enum)GracefulDisconnectStatesEnum.REFERRAL_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)this.storeReferral);
        this.transitions[GracefulDisconnectStatesEnum.REFERRAL_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)GracefulDisconnectStatesEnum.REFERRAL_STATE, (Enum)GracefulDisconnectStatesEnum.REFERRAL_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)this.storeReferral);
    }

    public static Grammar getInstance() {
        return instance;
    }
}

