/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.shared.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulShutdown;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulShutdownContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.GracefulShutdownStatesEnum;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GracefulShutdownGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(GracefulShutdownGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static Grammar instance = new GracefulShutdownGrammar();

    private GracefulShutdownGrammar() {
        this.setName(GracefulShutdownGrammar.class.getName());
        this.transitions = new GrammarTransition[GracefulShutdownStatesEnum.LAST_GRACEFUL_SHUTDOWN_STATE.ordinal()][256];
        this.transitions[GracefulShutdownStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)GracefulShutdownStatesEnum.START_STATE, (Enum)GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction("Init GracefulShutdown"){

            public void action(Asn1Container container) {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                GracefulShutdown gracefulShutdown = new GracefulShutdown();
                gracefulShutdownContainer.setGracefulShutdown(gracefulShutdown);
                gracefulShutdownContainer.setGrammarEndAllowed(true);
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][UniversalTag.INTEGER.getValue()] = new GrammarTransition((Enum)GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, (Enum)GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, (int)UniversalTag.INTEGER.getValue(), (Action)new GrammarAction("Set Graceful Shutdown time offline"){

            public void action(Asn1Container container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int timeOffline = IntegerDecoder.parse((Value)value, (int)0, (int)720);
                    if (IS_DEBUG) {
                        LOG.debug("Time Offline = " + timeOffline);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setTimeOffline(timeOffline);
                    gracefulShutdownContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04037, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.TIME_OFFLINE_STATE.ordinal()][128] = new GrammarTransition((Enum)GracefulShutdownStatesEnum.TIME_OFFLINE_STATE, (Enum)GracefulShutdownStatesEnum.DELAY_STATE, 128, (Action)new GrammarAction("Set Graceful Shutdown Delay"){

            public void action(Asn1Container container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse((Value)value, (int)0, (int)86400);
                    if (IS_DEBUG) {
                        LOG.debug("Delay = " + delay);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setDelay(delay);
                    gracefulShutdownContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04036, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE.ordinal()][128] = new GrammarTransition((Enum)GracefulShutdownStatesEnum.GRACEFUL_SHUTDOWN_SEQUENCE_STATE, (Enum)GracefulShutdownStatesEnum.DELAY_STATE, 128, (Action)new GrammarAction("Set Graceful Shutdown Delay"){

            public void action(Asn1Container container) throws DecoderException {
                GracefulShutdownContainer gracefulShutdownContainer = (GracefulShutdownContainer)container;
                Value value = gracefulShutdownContainer.getCurrentTLV().getValue();
                try {
                    int delay = IntegerDecoder.parse((Value)value, (int)0, (int)86400);
                    if (IS_DEBUG) {
                        LOG.debug("Delay = " + delay);
                    }
                    gracefulShutdownContainer.getGracefulShutdown().setDelay(delay);
                    gracefulShutdownContainer.setGrammarEndAllowed(true);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err((I18n)I18n.ERR_04036, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())});
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
            }
        });
    }

    public static Grammar getInstance() {
        return instance;
    }
}

