/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.extras.extended.ads_impl;

import org.apache.directory.shared.asn1.DecoderException;
import org.apache.directory.shared.asn1.ber.Asn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.Action;
import org.apache.directory.shared.asn1.ber.grammar.Grammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.UniversalTag;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.StoredProcedure;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.StoredProcedureContainer;
import org.apache.directory.shared.ldap.extras.extended.ads_impl.StoredProcedureStatesEnum;
import org.apache.directory.shared.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StoredProcedureGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(StoredProcedureGrammar.class);
    private static Grammar instance = new StoredProcedureGrammar();

    private StoredProcedureGrammar() {
        this.setName(StoredProcedureGrammar.class.getName());
        this.transitions = new GrammarTransition[StoredProcedureStatesEnum.LAST_STORED_PROCEDURE_STATE.ordinal()][256];
        this.transitions[StoredProcedureStatesEnum.START_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.START_STATE, (Enum)StoredProcedureStatesEnum.STORED_PROCEDURE_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[StoredProcedureStatesEnum.STORED_PROCEDURE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.STORED_PROCEDURE_STATE, (Enum)StoredProcedureStatesEnum.LANGUAGE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction("Stores the language"){

            public void action(Asn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedure storedProcedure = null;
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04038, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                String language = Strings.utf8ToString((byte[])tlv.getValue().getData());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("SP language found: " + language);
                }
                storedProcedure = new StoredProcedure();
                storedProcedure.setLanguage(language);
                storedProcedureContainer.setStoredProcedure(storedProcedure);
            }
        });
        this.transitions[StoredProcedureStatesEnum.LANGUAGE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.LANGUAGE_STATE, (Enum)StoredProcedureStatesEnum.PROCEDURE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction("Stores the procedure"){

            public void action(Asn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedure storedProcedure = storedProcedureContainer.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04039, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] procedure = tlv.getValue().getData();
                storedProcedure.setProcedure(procedure);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Procedure found : " + Strings.utf8ToString((byte[])storedProcedure.getProcedure()));
                }
            }
        });
        this.transitions[StoredProcedureStatesEnum.PROCEDURE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PROCEDURE_STATE, (Enum)StoredProcedureStatesEnum.PARAMETERS_STATE, (int)UniversalTag.SEQUENCE.getValue(), (Action)new GrammarAction("Stores the parameters"){

            public void action(Asn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                storedProcedureContainer.setGrammarEndAllowed(true);
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETERS_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PARAMETERS_STATE, (Enum)StoredProcedureStatesEnum.PARAMETER_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
        this.transitions[StoredProcedureStatesEnum.PARAMETER_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PARAMETER_STATE, (Enum)StoredProcedureStatesEnum.PARAMETER_TYPE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction("Store parameter type"){

            public void action(Asn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedure storedProcedure = storedProcedureContainer.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04040, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                StoredProcedure.StoredProcedureParameter parameter = new StoredProcedure.StoredProcedureParameter();
                byte[] parameterType = tlv.getValue().getData();
                parameter.setType(parameterType);
                storedProcedure.setCurrentParameter(parameter);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Parameter type found : " + Strings.dumpBytes((byte[])parameterType));
                }
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETER_TYPE_STATE.ordinal()][UniversalTag.OCTET_STRING.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PARAMETER_TYPE_STATE, (Enum)StoredProcedureStatesEnum.PARAMETER_VALUE_STATE, (int)UniversalTag.OCTET_STRING.getValue(), (Action)new GrammarAction("Store parameter value"){

            public void action(Asn1Container container) throws DecoderException {
                StoredProcedureContainer storedProcedureContainer = (StoredProcedureContainer)container;
                TLV tlv = storedProcedureContainer.getCurrentTLV();
                StoredProcedure storedProcedure = storedProcedureContainer.getStoredProcedure();
                if (tlv.getLength() == 0) {
                    String msg = I18n.err((I18n)I18n.ERR_04041, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                byte[] parameterValue = tlv.getValue().getData();
                if (parameterValue.length != 0) {
                    StoredProcedure.StoredProcedureParameter parameter = storedProcedure.getCurrentParameter();
                    parameter.setValue(parameterValue);
                    storedProcedure.addParameter(parameter);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Parameter value found : " + Strings.dumpBytes((byte[])parameterValue));
                    }
                } else {
                    String msg = I18n.err((I18n)I18n.ERR_04042, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                container.setGrammarEndAllowed(true);
            }
        });
        this.transitions[StoredProcedureStatesEnum.PARAMETER_VALUE_STATE.ordinal()][UniversalTag.SEQUENCE.getValue()] = new GrammarTransition((Enum)StoredProcedureStatesEnum.PARAMETER_VALUE_STATE, (Enum)StoredProcedureStatesEnum.PARAMETER_STATE, (int)UniversalTag.SEQUENCE.getValue(), null);
    }

    public static Grammar getInstance() {
        return instance;
    }
}

