/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls;

import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.AbstractControl;
import org.apache.directory.shared.ldap.util.StringTools;

public class ControlImpl
extends AbstractControl {
    public ControlImpl(String oid) {
        super(oid);
        this.decoder = null;
    }

    public void setValue(byte[] value) {
        if (value != null) {
            this.value = new byte[value.length];
            System.arraycopy(value, 0, this.value, 0, value.length);
        } else {
            this.value = null;
        }
    }

    public byte[] getValue() {
        if (this.value == null) {
            return StringTools.EMPTY_BYTES;
        }
        byte[] copy = new byte[this.value.length];
        System.arraycopy(this.value, 0, copy, 0, this.value.length);
        return copy;
    }

    public int computeLength() {
        if (this.value != null) {
            return super.computeLength(this.value.length);
        }
        return super.computeLength(0);
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err((String)"ERR_04023", (Object[])new Object[0]));
        }
        super.encode(buffer);
        if (this.value != null) {
            Value.encode((ByteBuffer)buffer, (byte[])this.value);
        }
        return buffer;
    }
}

