/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.message;

import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchParams {
    private static Logger LOG = LoggerFactory.getLogger(SearchParams.class);
    private SearchScope scope = SearchScope.OBJECT;
    private int timeLimit = 0;
    private long sizeLimit = 0L;
    private boolean typesOnly = false;
    private AliasDerefMode aliasDerefMode = AliasDerefMode.DEREF_ALWAYS;
    private Set<String> returningAttributesStr;
    private Set<AttributeTypeOptions> returningAttributes = new HashSet<AttributeTypeOptions>();
    private Set<Control> controls;

    public SearchParams() {
        this.returningAttributesStr = new HashSet<String>();
        this.controls = new HashSet<Control>();
    }

    public SearchScope getScope() {
        return this.scope;
    }

    public void setScope(SearchScope scope) {
        this.scope = scope;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(int timeLimit) {
        this.timeLimit = timeLimit;
    }

    public long getSizeLimit() {
        return this.sizeLimit;
    }

    public void setSizeLimit(long sizeLimit) {
        this.sizeLimit = sizeLimit;
    }

    public boolean isTypesOnly() {
        return this.typesOnly;
    }

    public void setTypesOnly(boolean typesOnly) {
        this.typesOnly = typesOnly;
    }

    public AliasDerefMode getAliasDerefMode() {
        return this.aliasDerefMode;
    }

    public void setAliasDerefMode(AliasDerefMode aliasDerefMode) {
        this.aliasDerefMode = aliasDerefMode;
    }

    public Set<AttributeTypeOptions> getReturningAttributes() {
        return this.returningAttributes;
    }

    public Set<String> getReturningAttributesStr() {
        return this.returningAttributesStr;
    }

    public void normalize(SchemaManager schemaManager) {
        for (String returnAttribute : this.returningAttributesStr) {
            try {
                String id = SchemaUtils.stripOptions(returnAttribute);
                Set<String> options = SchemaUtils.getOptions(returnAttribute);
                AttributeType attributeType = schemaManager.lookupAttributeTypeRegistry(id);
                AttributeTypeOptions attrOptions = new AttributeTypeOptions(attributeType, options);
                this.returningAttributes.add(attrOptions);
            }
            catch (NamingException ne) {
                LOG.warn("Requested attribute {} does not exist in the schema, it will be ignored", (Object)returnAttribute);
            }
        }
    }

    public void setReturningAttributes(String ... returningAttributes) {
        if (returningAttributes != null) {
            for (String returnAttribute : returningAttributes) {
                this.returningAttributesStr.add(returnAttribute);
            }
        }
    }

    public void addReturningAttributes(String returningAttribute) {
        this.returningAttributesStr.add(returningAttribute);
    }

    public Set<Control> getControls() {
        return this.controls;
    }

    public void setControls(Set<Control> controls) {
        this.controls = controls;
    }

    public void addControl(Control control) {
        this.controls.add(control);
    }

    public static SearchParams toSearchParams(SearchControls searchControls, AliasDerefMode aliasDerefMode) {
        SearchParams searchParams = new SearchParams();
        searchParams.setAliasDerefMode(aliasDerefMode);
        searchParams.setTimeLimit(searchControls.getTimeLimit());
        searchParams.setSizeLimit(searchControls.getCountLimit());
        searchParams.setScope(SearchScope.getSearchScope(searchControls.getSearchScope()));
        searchParams.setTypesOnly(searchControls.getReturningObjFlag());
        return searchParams;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Search parameters :\n");
        sb.append("    scope : ").append((Object)this.scope).append("\n");
        sb.append("    Alias dereferencing : ").append((Object)this.aliasDerefMode).append("\n");
        sb.append("    types only : ").append(this.typesOnly).append("\n");
        if (this.returningAttributesStr.size() != 0) {
            sb.append("    returning attributes : ").append(StringTools.setToString(this.returningAttributesStr)).append("\n");
        }
        if (this.timeLimit > 0) {
            sb.append("    timeLimit : ").append(this.timeLimit).append("\n");
        } else {
            sb.append("    no timeLimit\n");
        }
        if (this.timeLimit > 0) {
            sb.append("    sizeLimit : ").append(this.sizeLimit).append("\n");
        } else {
            sb.append("    no sizeLimit\n");
        }
        if (this.controls.size() != 0) {
            for (Control control : this.controls) {
                sb.append("    control : ").append(control.getOid()).append("/").append(control.getClass().getName()).append("\n");
            }
        }
        return sb.toString();
    }
}

