/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryClassUtils {
    private static final Logger LOG = LoggerFactory.getLogger(DirectoryClassUtils.class);

    public static Method getAssignmentCompatibleMethod(Class<?> clazz, String candidateMethodName, Class<?>[] candidateParameterTypes) throws NoSuchMethodException {
        if (LOG.isDebugEnabled()) {
            StringBuilder buf = new StringBuilder();
            buf.append("call to getAssignmentCompatibleMethod(): \n\tclazz = ");
            buf.append(clazz.getName());
            buf.append("\n\tcandidateMethodName = ");
            buf.append(candidateMethodName);
            buf.append("\n\tcandidateParameterTypes = ");
            for (Class<?> argClass : candidateParameterTypes) {
                buf.append("\n\t\t");
                buf.append(argClass.getName());
            }
            LOG.debug(buf.toString());
        }
        try {
            Method exactMethod = clazz.getMethod(candidateMethodName, candidateParameterTypes);
            if (exactMethod != null) {
                return exactMethod;
            }
        }
        catch (Exception e) {
            LOG.info("Could not find accessible exact match for candidateMethod {}", (Object)candidateMethodName, (Object)e);
        }
        Method[] methods = clazz.getMethods();
        for (int mx = 0; mx < methods.length; ++mx) {
            Class<?>[] parameterTypes;
            if (!candidateMethodName.equals(methods[mx].getName()) || (parameterTypes = methods[mx].getParameterTypes()).length != candidateParameterTypes.length) continue;
            for (int px = 0; px < parameterTypes.length && parameterTypes[px].isAssignableFrom(candidateParameterTypes[px]); ++px) {
            }
            return methods[mx];
        }
        throw new NoSuchMethodException(clazz.getName() + "." + candidateMethodName + "(" + Arrays.toString(candidateParameterTypes) + ")");
    }
}

