/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.AttributeValueAssertion;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.codec.LdapResultCodec;
import org.apache.directory.shared.ldap.codec.MessageTypeEnum;
import org.apache.directory.shared.ldap.codec.abandon.AbandonRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddRequestCodec;
import org.apache.directory.shared.ldap.codec.add.AddResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.BindRequestCodec;
import org.apache.directory.shared.ldap.codec.bind.BindResponseCodec;
import org.apache.directory.shared.ldap.codec.bind.LdapAuthentication;
import org.apache.directory.shared.ldap.codec.bind.SaslCredentials;
import org.apache.directory.shared.ldap.codec.bind.SimpleAuthentication;
import org.apache.directory.shared.ldap.codec.compare.CompareRequestCodec;
import org.apache.directory.shared.ldap.codec.compare.CompareResponseCodec;
import org.apache.directory.shared.ldap.codec.del.DelRequestCodec;
import org.apache.directory.shared.ldap.codec.del.DelResponseCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedRequestCodec;
import org.apache.directory.shared.ldap.codec.extended.ExtendedResponseCodec;
import org.apache.directory.shared.ldap.codec.intermediate.IntermediateResponseCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyRequestCodec;
import org.apache.directory.shared.ldap.codec.modify.ModifyResponseCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNRequestCodec;
import org.apache.directory.shared.ldap.codec.modifyDn.ModifyDNResponseCodec;
import org.apache.directory.shared.ldap.codec.search.AndFilter;
import org.apache.directory.shared.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.shared.ldap.codec.search.ConnectorFilter;
import org.apache.directory.shared.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.codec.search.NotFilter;
import org.apache.directory.shared.ldap.codec.search.OrFilter;
import org.apache.directory.shared.ldap.codec.search.PresentFilter;
import org.apache.directory.shared.ldap.codec.search.SearchRequestCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultDoneCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultEntryCodec;
import org.apache.directory.shared.ldap.codec.search.SearchResultReferenceCodec;
import org.apache.directory.shared.ldap.codec.search.SubstringFilter;
import org.apache.directory.shared.ldap.codec.unbind.UnBindRequestCodec;
import org.apache.directory.shared.ldap.codec.util.LdapURLEncodingException;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapInvalidDnException;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.ApproximateNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.EqualityNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.ExtensibleNode;
import org.apache.directory.shared.ldap.filter.GreaterEqNode;
import org.apache.directory.shared.ldap.filter.LeafNode;
import org.apache.directory.shared.ldap.filter.LessEqNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.filter.SimpleNode;
import org.apache.directory.shared.ldap.filter.SubstringNode;
import org.apache.directory.shared.ldap.message.AbandonRequestImpl;
import org.apache.directory.shared.ldap.message.AddRequestImpl;
import org.apache.directory.shared.ldap.message.AddResponseImpl;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.BindRequestImpl;
import org.apache.directory.shared.ldap.message.BindResponseImpl;
import org.apache.directory.shared.ldap.message.CompareRequestImpl;
import org.apache.directory.shared.ldap.message.CompareResponseImpl;
import org.apache.directory.shared.ldap.message.DeleteRequestImpl;
import org.apache.directory.shared.ldap.message.DeleteResponseImpl;
import org.apache.directory.shared.ldap.message.ExtendedRequestImpl;
import org.apache.directory.shared.ldap.message.ExtendedResponseImpl;
import org.apache.directory.shared.ldap.message.IntermediateResponseImpl;
import org.apache.directory.shared.ldap.message.LdapResultImpl;
import org.apache.directory.shared.ldap.message.ModifyDnRequestImpl;
import org.apache.directory.shared.ldap.message.ModifyDnResponseImpl;
import org.apache.directory.shared.ldap.message.ModifyRequestImpl;
import org.apache.directory.shared.ldap.message.ModifyResponseImpl;
import org.apache.directory.shared.ldap.message.ReferralImpl;
import org.apache.directory.shared.ldap.message.SearchRequestImpl;
import org.apache.directory.shared.ldap.message.SearchResponseDoneImpl;
import org.apache.directory.shared.ldap.message.SearchResponseEntryImpl;
import org.apache.directory.shared.ldap.message.SearchResponseReferenceImpl;
import org.apache.directory.shared.ldap.message.UnbindRequestImpl;
import org.apache.directory.shared.ldap.message.control.Control;
import org.apache.directory.shared.ldap.message.extended.GracefulShutdownRequest;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.apache.directory.shared.ldap.message.internal.InternalMessage;
import org.apache.directory.shared.ldap.message.internal.InternalReferral;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LdapTransformer {
    private static Logger LOG = LoggerFactory.getLogger(LdapTransformer.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    private static InternalMessage transformAbandonRequest(AbandonRequestCodec abandonRequest, int messageId) {
        AbandonRequestImpl internalMessage = new AbandonRequestImpl(messageId);
        internalMessage.setAbandoned(abandonRequest.getAbandonedMessageId());
        return internalMessage;
    }

    private static InternalMessage transformAddRequest(AddRequestCodec addRequest, int messageId) {
        AddRequestImpl internalMessage = new AddRequestImpl(messageId);
        internalMessage.setEntry(addRequest.getEntry());
        internalMessage.setEntry(addRequest.getEntry());
        return internalMessage;
    }

    private static InternalMessage transformBindRequest(BindRequestCodec bindRequest, int messageId) {
        BindRequestImpl internalMessage = new BindRequestImpl(messageId);
        internalMessage.setVersion3(bindRequest.isLdapV3());
        internalMessage.setName(bindRequest.getName());
        LdapAuthentication authentication = bindRequest.getAuthentication();
        if (authentication instanceof SimpleAuthentication) {
            internalMessage.setSimple(true);
            internalMessage.setCredentials(((SimpleAuthentication)authentication).getSimple());
        } else {
            internalMessage.setSimple(false);
            internalMessage.setCredentials(((SaslCredentials)authentication).getCredentials());
            internalMessage.setSaslMechanism(((SaslCredentials)authentication).getMechanism());
        }
        return internalMessage;
    }

    private static InternalMessage transformBindResponse(BindResponseCodec bindResponse, int messageId) {
        BindResponseImpl internalMessage = new BindResponseImpl(messageId);
        internalMessage.setServerSaslCreds(bindResponse.getServerSaslCreds());
        LdapTransformer.transformLdapResultCodecToInternal(bindResponse.getLdapResult(), internalMessage.getLdapResult());
        return internalMessage;
    }

    private static void transformLdapResultCodecToInternal(LdapResultCodec codecLdapResult, InternalLdapResult internalLdapResult) {
        internalLdapResult.setErrorMessage(codecLdapResult.getErrorMessage());
        try {
            internalLdapResult.setMatchedDn(new DN(codecLdapResult.getMatchedDN()));
        }
        catch (LdapInvalidDnException e) {
            LOG.error(I18n.err((String)"ERR_04111", (Object[])new Object[]{codecLdapResult.getMatchedDN()}));
            internalLdapResult.setMatchedDn(new DN());
        }
        internalLdapResult.setResultCode(codecLdapResult.getResultCode());
        if (codecLdapResult.getReferrals() != null) {
            ReferralImpl referral = new ReferralImpl();
            for (LdapURL url : codecLdapResult.getReferrals()) {
                referral.addLdapUrl(url.toString());
            }
            internalLdapResult.setReferral(referral);
        }
    }

    private static InternalMessage transformCompareRequest(CompareRequestCodec compareRequest, int messageId) {
        CompareRequestImpl internalMessage = new CompareRequestImpl(messageId);
        internalMessage.setName(compareRequest.getEntry());
        internalMessage.setAttributeId(compareRequest.getAttributeDesc());
        if (compareRequest.getAssertionValue() instanceof String) {
            internalMessage.setAssertionValue((String)compareRequest.getAssertionValue());
        } else {
            internalMessage.setAssertionValue((byte[])compareRequest.getAssertionValue());
        }
        return internalMessage;
    }

    private static InternalMessage transformDelRequest(DelRequestCodec delRequest, int messageId) {
        DeleteRequestImpl internalMessage = new DeleteRequestImpl(messageId);
        internalMessage.setName(delRequest.getEntry());
        return internalMessage;
    }

    private static InternalMessage transformExtendedRequest(ExtendedRequestCodec extendedRequest, int messageId) {
        ExtendedRequestImpl internalMessage = extendedRequest.getRequestName().equals("1.3.6.1.4.1.18060.0.1.3") ? new GracefulShutdownRequest(messageId) : new ExtendedRequestImpl(messageId);
        internalMessage.setOid(extendedRequest.getRequestName());
        internalMessage.setPayload(extendedRequest.getRequestValue());
        return internalMessage;
    }

    private static InternalMessage transformModifyDNRequest(ModifyDNRequestCodec modifyDNRequest, int messageId) {
        ModifyDnRequestImpl internalMessage = new ModifyDnRequestImpl(messageId);
        internalMessage.setName(modifyDNRequest.getEntry());
        internalMessage.setNewRdn(modifyDNRequest.getNewRDN());
        internalMessage.setDeleteOldRdn(modifyDNRequest.isDeleteOldRDN());
        internalMessage.setNewSuperior(modifyDNRequest.getNewSuperior());
        return internalMessage;
    }

    private static InternalMessage transformModifyRequest(ModifyRequestCodec modifyRequest, int messageId) {
        ModifyRequestImpl internalMessage = new ModifyRequestImpl(messageId);
        internalMessage.setName(modifyRequest.getObject());
        if (modifyRequest.getModifications() != null) {
            for (Modification modification : modifyRequest.getModifications()) {
                internalMessage.addModification(modification);
            }
        }
        return internalMessage;
    }

    private static ExprNode transformFilter(Filter codecFilter) {
        if (codecFilter != null) {
            if (codecFilter instanceof ConnectorFilter) {
                BranchNode branch = null;
                if (codecFilter instanceof AndFilter) {
                    branch = new AndNode();
                } else if (codecFilter instanceof OrFilter) {
                    branch = new OrNode();
                } else if (codecFilter instanceof NotFilter) {
                    branch = new NotNode();
                }
                List<Filter> filtersSet = ((ConnectorFilter)codecFilter).getFilterSet();
                if (filtersSet != null) {
                    for (Filter filter : filtersSet) {
                        branch.addNode(LdapTransformer.transformFilter(filter));
                    }
                }
                return branch;
            }
            LeafNode branch = null;
            if (codecFilter instanceof PresentFilter) {
                branch = new PresenceNode(((PresentFilter)codecFilter).getAttributeDescription());
            } else if (codecFilter instanceof AttributeValueAssertionFilter) {
                AttributeValueAssertion ava = ((AttributeValueAssertionFilter)codecFilter).getAssertion();
                switch (((AttributeValueAssertionFilter)codecFilter).getFilterType()) {
                    case 0: {
                        branch = new EqualityNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 1: {
                        branch = new GreaterEqNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 2: {
                        branch = new LessEqNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 3: {
                        branch = new ApproximateNode(ava.getAttributeDesc(), ava.getAssertionValue());
                    }
                }
            } else if (codecFilter instanceof SubstringFilter) {
                SubstringFilter filter = (SubstringFilter)codecFilter;
                String initialString = null;
                String finalString = null;
                ArrayList<String> anyString = null;
                if (filter.getInitialSubstrings() != null) {
                    initialString = filter.getInitialSubstrings();
                }
                if (filter.getFinalSubstrings() != null) {
                    finalString = filter.getFinalSubstrings();
                }
                if (filter.getAnySubstrings() != null) {
                    anyString = new ArrayList<String>();
                    for (String any : filter.getAnySubstrings()) {
                        anyString.add(any);
                    }
                }
                branch = new SubstringNode(anyString, filter.getType(), initialString, finalString);
            } else if (codecFilter instanceof ExtensibleMatchFilter) {
                ExtensibleMatchFilter filter = (ExtensibleMatchFilter)codecFilter;
                String attribute = null;
                String matchingRule = null;
                if (filter.getType() != null) {
                    attribute = filter.getType();
                }
                Value<?> value = filter.getMatchValue();
                if (filter.getMatchingRule() != null) {
                    matchingRule = filter.getMatchingRule();
                }
                branch = new ExtensibleNode(attribute, value, matchingRule, filter.isDnAttributes());
            }
            return branch;
        }
        return null;
    }

    public static Filter transformFilter(ExprNode exprNode) {
        if (exprNode != null) {
            Filter filter = null;
            if (exprNode instanceof BranchNode) {
                if (exprNode instanceof AndNode) {
                    filter = new AndFilter();
                } else if (exprNode instanceof OrNode) {
                    filter = new OrFilter();
                } else if (exprNode instanceof NotNode) {
                    filter = new NotFilter();
                }
                List<ExprNode> children = ((BranchNode)exprNode).getChildren();
                if (children != null) {
                    for (ExprNode child : children) {
                        try {
                            ((ConnectorFilter)filter).addFilter(LdapTransformer.transformFilter(child));
                        }
                        catch (DecoderException de) {
                            LOG.error(I18n.err((String)"ERR_04112", (Object[])new Object[]{de.getLocalizedMessage()}));
                            return null;
                        }
                    }
                }
            } else if (exprNode instanceof PresenceNode) {
                filter = new PresentFilter();
                ((PresentFilter)filter).setAttributeDescription(((PresenceNode)exprNode).getAttribute());
            } else if (exprNode instanceof SimpleNode) {
                if (exprNode instanceof EqualityNode) {
                    filter = new AttributeValueAssertionFilter(0);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAttribute());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof GreaterEqNode) {
                    filter = new AttributeValueAssertionFilter(1);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAttribute());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof LessEqNode) {
                    filter = new AttributeValueAssertionFilter(2);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAttribute());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof ApproximateNode) {
                    filter = new AttributeValueAssertionFilter(3);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAttribute());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                }
            } else if (exprNode instanceof SubstringNode) {
                filter = new SubstringFilter();
                String initialString = ((SubstringNode)exprNode).getInitial();
                String finalString = ((SubstringNode)exprNode).getFinal();
                List<String> anyStrings = ((SubstringNode)exprNode).getAny();
                if (initialString != null) {
                    ((SubstringFilter)filter).setInitialSubstrings(initialString);
                }
                if (finalString != null) {
                    ((SubstringFilter)filter).setFinalSubstrings(finalString);
                }
                if (anyStrings != null) {
                    for (String any : anyStrings) {
                        ((SubstringFilter)filter).addAnySubstrings(any);
                    }
                }
            } else if (exprNode instanceof ExtensibleNode) {
                filter = new ExtensibleMatchFilter();
                String attribute = ((ExtensibleNode)exprNode).getAttribute();
                String matchingRule = ((ExtensibleNode)exprNode).getMatchingRuleId();
                boolean dnAttributes = ((ExtensibleNode)exprNode).hasDnAttributes();
                Value<?> value = ((ExtensibleNode)exprNode).getValue();
                if (attribute != null) {
                    ((ExtensibleMatchFilter)filter).setType(attribute);
                }
                if (matchingRule != null) {
                    ((ExtensibleMatchFilter)filter).setMatchingRule(matchingRule);
                }
                ((ExtensibleMatchFilter)filter).setMatchValue(value);
                ((ExtensibleMatchFilter)filter).setDnAttributes(dnAttributes);
            }
            return filter;
        }
        return null;
    }

    private static InternalMessage transformSearchRequest(SearchRequestCodec searchRequest, int messageId) {
        List<EntryAttribute> attributes;
        SearchRequestImpl internalMessage = new SearchRequestImpl(messageId);
        internalMessage.setBase(searchRequest.getBaseObject());
        internalMessage.setScope(searchRequest.getScope());
        switch (searchRequest.getDerefAliases()) {
            case 3: {
                internalMessage.setDerefAliases(AliasDerefMode.DEREF_ALWAYS);
                break;
            }
            case 2: {
                internalMessage.setDerefAliases(AliasDerefMode.DEREF_FINDING_BASE_OBJ);
                break;
            }
            case 1: {
                internalMessage.setDerefAliases(AliasDerefMode.DEREF_IN_SEARCHING);
                break;
            }
            case 0: {
                internalMessage.setDerefAliases(AliasDerefMode.NEVER_DEREF_ALIASES);
            }
        }
        internalMessage.setSizeLimit(searchRequest.getSizeLimit());
        internalMessage.setTimeLimit(searchRequest.getTimeLimit());
        internalMessage.setTypesOnly(searchRequest.isTypesOnly());
        Filter codecFilter = searchRequest.getFilter();
        internalMessage.setFilter(LdapTransformer.transformFilter(codecFilter));
        if (searchRequest.getAttributes() != null && (attributes = searchRequest.getAttributes()) != null && attributes.size() != 0) {
            for (EntryAttribute attribute : attributes) {
                if (attribute == null) continue;
                internalMessage.addAttribute(attribute.getId());
            }
        }
        return internalMessage;
    }

    private static InternalMessage transformUnBindRequest(LdapMessageCodec codecMessage, int messageId) {
        return new UnbindRequestImpl(messageId);
    }

    public static InternalMessage transform(Object obj) {
        LdapMessageCodec codecMessage = (LdapMessageCodec)((Object)obj);
        int messageId = codecMessage.getMessageId();
        if (IS_DEBUG) {
            LOG.debug("Transforming LdapMessage <" + messageId + ", " + codecMessage.getMessageTypeName() + "> from Codec to nternal.");
        }
        InternalMessage internalMessage = null;
        MessageTypeEnum messageType = codecMessage.getMessageType();
        switch (messageType) {
            case BIND_REQUEST: {
                internalMessage = LdapTransformer.transformBindRequest((BindRequestCodec)codecMessage, messageId);
                break;
            }
            case UNBIND_REQUEST: {
                internalMessage = LdapTransformer.transformUnBindRequest((UnBindRequestCodec)codecMessage, messageId);
                break;
            }
            case SEARCH_REQUEST: {
                internalMessage = LdapTransformer.transformSearchRequest((SearchRequestCodec)codecMessage, messageId);
                break;
            }
            case MODIFY_REQUEST: {
                internalMessage = LdapTransformer.transformModifyRequest((ModifyRequestCodec)codecMessage, messageId);
                break;
            }
            case ADD_REQUEST: {
                internalMessage = LdapTransformer.transformAddRequest((AddRequestCodec)codecMessage, messageId);
                break;
            }
            case DEL_REQUEST: {
                internalMessage = LdapTransformer.transformDelRequest((DelRequestCodec)codecMessage, messageId);
                break;
            }
            case MODIFYDN_REQUEST: {
                internalMessage = LdapTransformer.transformModifyDNRequest((ModifyDNRequestCodec)codecMessage, messageId);
                break;
            }
            case COMPARE_REQUEST: {
                internalMessage = LdapTransformer.transformCompareRequest((CompareRequestCodec)codecMessage, messageId);
                break;
            }
            case ABANDON_REQUEST: {
                internalMessage = LdapTransformer.transformAbandonRequest((AbandonRequestCodec)codecMessage, messageId);
                break;
            }
            case EXTENDED_REQUEST: {
                internalMessage = LdapTransformer.transformExtendedRequest((ExtendedRequestCodec)codecMessage, messageId);
                break;
            }
            case BIND_RESPONSE: {
                internalMessage = LdapTransformer.transformBindResponse((BindResponseCodec)codecMessage, messageId);
                break;
            }
            case SEARCH_RESULT_ENTRY: 
            case SEARCH_RESULT_DONE: 
            case SEARCH_RESULT_REFERENCE: 
            case MODIFY_RESPONSE: 
            case ADD_RESPONSE: 
            case DEL_RESPONSE: 
            case MODIFYDN_RESPONSE: 
            case COMPARE_RESPONSE: 
            case EXTENDED_RESPONSE: 
            case INTERMEDIATE_RESPONSE: {
                break;
            }
            default: {
                throw new IllegalStateException(I18n.err((String)"ERR_04113", (Object[])new Object[0]));
            }
        }
        LdapTransformer.transformControlsCodecToInternal(codecMessage, internalMessage);
        return internalMessage;
    }

    private static LdapResultCodec transformLdapResult(LdapResultImpl internalLdapResult) {
        LdapResultCodec codecLdapResult = new LdapResultCodec();
        codecLdapResult.setResultCode(internalLdapResult.getResultCode());
        String errorMessage = internalLdapResult.getErrorMessage();
        codecLdapResult.setErrorMessage(StringTools.isEmpty(errorMessage) ? "" : errorMessage);
        codecLdapResult.setMatchedDN(internalLdapResult.getMatchedDn());
        ReferralImpl internalReferrals = (ReferralImpl)internalLdapResult.getReferral();
        if (internalReferrals != null) {
            codecLdapResult.initReferrals();
            for (String referral : internalReferrals.getLdapUrls()) {
                try {
                    LdapURL ldapUrl = new LdapURL(referral.getBytes());
                    codecLdapResult.addReferral(ldapUrl);
                }
                catch (LdapURLEncodingException lude) {
                    LOG.warn("The referral " + referral + " is invalid : " + lude.getMessage());
                    codecLdapResult.addReferral(LdapURL.EMPTY_URL);
                }
            }
        }
        return codecLdapResult;
    }

    private static LdapMessageCodec transformAddResponse(InternalMessage internalMessage) {
        AddResponseImpl internalAddResponse = (AddResponseImpl)internalMessage;
        AddResponseCodec addResponse = new AddResponseCodec();
        addResponse.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalAddResponse.getLdapResult()));
        return addResponse;
    }

    private static LdapMessageCodec transformBindResponse(InternalMessage internalMessage) {
        BindResponseImpl internalBindResponse = (BindResponseImpl)internalMessage;
        BindResponseCodec bindResponseCodec = new BindResponseCodec();
        byte[] serverSaslCreds = internalBindResponse.getServerSaslCreds();
        if (serverSaslCreds != null) {
            bindResponseCodec.setServerSaslCreds(serverSaslCreds);
        }
        bindResponseCodec.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalBindResponse.getLdapResult()));
        return bindResponseCodec;
    }

    private static LdapMessageCodec transformBindRequest(InternalMessage internalMessage) {
        BindRequestImpl internalBindRequest = (BindRequestImpl)internalMessage;
        BindRequestCodec bindRequest = new BindRequestCodec();
        if (internalBindRequest.isSimple()) {
            SimpleAuthentication simple = new SimpleAuthentication();
            simple.setSimple(internalBindRequest.getCredentials());
            bindRequest.setAuthentication(simple);
        } else {
            SaslCredentials sasl = new SaslCredentials();
            sasl.setCredentials(internalBindRequest.getCredentials());
            sasl.setMechanism(internalBindRequest.getSaslMechanism());
            bindRequest.setAuthentication(sasl);
        }
        bindRequest.setMessageId(internalBindRequest.getMessageId());
        bindRequest.setName(internalBindRequest.getName());
        bindRequest.setVersion(internalBindRequest.isVersion3() ? 3 : 2);
        return bindRequest;
    }

    private static LdapMessageCodec transformCompareResponse(InternalMessage internalMessage) {
        CompareResponseImpl internalCompareResponse = (CompareResponseImpl)internalMessage;
        CompareResponseCodec compareResponse = new CompareResponseCodec();
        compareResponse.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalCompareResponse.getLdapResult()));
        return compareResponse;
    }

    private static LdapMessageCodec transformDelResponse(InternalMessage internalMessage) {
        DeleteResponseImpl internalDelResponse = (DeleteResponseImpl)internalMessage;
        DelResponseCodec delResponse = new DelResponseCodec();
        delResponse.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalDelResponse.getLdapResult()));
        return delResponse;
    }

    private static LdapMessageCodec transformExtendedResponse(InternalMessage internalMessage) {
        ExtendedResponseImpl internalExtendedResponse = (ExtendedResponseImpl)internalMessage;
        ExtendedResponseCodec extendedResponse = new ExtendedResponseCodec();
        try {
            extendedResponse.setResponseName(new OID(internalExtendedResponse.getResponseName()));
        }
        catch (DecoderException de) {
            LOG.warn("The OID " + internalExtendedResponse.getResponseName() + " is invalid : " + de.getMessage());
            extendedResponse.setResponseName(null);
        }
        extendedResponse.setResponse(internalExtendedResponse.getResponse());
        extendedResponse.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalExtendedResponse.getLdapResult()));
        return extendedResponse;
    }

    private static LdapMessageCodec transformIntermediateResponse(InternalMessage internalMessage) {
        IntermediateResponseImpl internalIntermediateResponse = (IntermediateResponseImpl)internalMessage;
        IntermediateResponseCodec intermediateResponse = new IntermediateResponseCodec();
        try {
            intermediateResponse.setResponseName(new OID(internalIntermediateResponse.getResponseName()));
        }
        catch (DecoderException de) {
            LOG.warn("The OID " + internalIntermediateResponse.getResponseName() + " is invalid : " + de.getMessage());
            intermediateResponse.setResponseName(null);
        }
        intermediateResponse.setResponseValue(internalIntermediateResponse.getResponseValue());
        intermediateResponse.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalIntermediateResponse.getLdapResult()));
        return intermediateResponse;
    }

    private static LdapMessageCodec transformModifyResponse(InternalMessage internalMessage) {
        ModifyResponseImpl internalModifyResponse = (ModifyResponseImpl)internalMessage;
        ModifyResponseCodec modifyResponse = new ModifyResponseCodec();
        modifyResponse.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalModifyResponse.getLdapResult()));
        return modifyResponse;
    }

    private static LdapMessageCodec transformModifyDNResponse(InternalMessage internalMessage) {
        ModifyDnResponseImpl internalModifyDNResponse = (ModifyDnResponseImpl)internalMessage;
        ModifyDNResponseCodec modifyDNResponse = new ModifyDNResponseCodec();
        modifyDNResponse.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalModifyDNResponse.getLdapResult()));
        return modifyDNResponse;
    }

    private static LdapMessageCodec transformSearchResultDone(InternalMessage internalMessage) {
        SearchResponseDoneImpl internalSearchResponseDone = (SearchResponseDoneImpl)internalMessage;
        SearchResultDoneCodec searchResultDone = new SearchResultDoneCodec();
        searchResultDone.setLdapResult(LdapTransformer.transformLdapResult((LdapResultImpl)internalSearchResponseDone.getLdapResult()));
        return searchResultDone;
    }

    private static LdapMessageCodec transformSearchResultEntry(InternalMessage internalMessage) {
        SearchResponseEntryImpl internalSearchResultResponse = (SearchResponseEntryImpl)internalMessage;
        SearchResultEntryCodec searchResultEntry = new SearchResultEntryCodec();
        searchResultEntry.setObjectName(internalSearchResultResponse.getObjectName());
        searchResultEntry.setEntry(internalSearchResultResponse.getEntry());
        return searchResultEntry;
    }

    private static LdapMessageCodec transformSearchResultReference(InternalMessage internalMessage) {
        Collection<String> urls;
        SearchResponseReferenceImpl internalSearchResponseReference = (SearchResponseReferenceImpl)internalMessage;
        SearchResultReferenceCodec searchResultReference = new SearchResultReferenceCodec();
        InternalReferral referrals = internalSearchResponseReference.getReferral();
        if (referrals != null && (urls = referrals.getLdapUrls()) != null) {
            for (String url : urls) {
                try {
                    searchResultReference.addSearchResultReference(new LdapURL(url));
                }
                catch (LdapURLEncodingException luee) {
                    LOG.warn("The LdapURL " + url + " is incorrect : " + luee.getMessage());
                }
            }
        }
        return searchResultReference;
    }

    public static Object transform(InternalMessage msg) {
        if (IS_DEBUG) {
            LOG.debug("Transforming message type " + (Object)((Object)msg.getType()));
        }
        LdapMessageCodec codecMessage = null;
        switch (msg.getType()) {
            case SEARCH_RESULT_ENTRY: {
                codecMessage = LdapTransformer.transformSearchResultEntry(msg);
                break;
            }
            case SEARCH_RESULT_DONE: {
                codecMessage = LdapTransformer.transformSearchResultDone(msg);
                break;
            }
            case SEARCH_RESULT_REFERENCE: {
                codecMessage = LdapTransformer.transformSearchResultReference(msg);
                break;
            }
            case BIND_RESPONSE: {
                codecMessage = LdapTransformer.transformBindResponse(msg);
                break;
            }
            case BIND_REQUEST: {
                codecMessage = LdapTransformer.transformBindRequest(msg);
                break;
            }
            case ADD_RESPONSE: {
                codecMessage = LdapTransformer.transformAddResponse(msg);
                break;
            }
            case COMPARE_RESPONSE: {
                codecMessage = LdapTransformer.transformCompareResponse(msg);
                break;
            }
            case DEL_RESPONSE: {
                codecMessage = LdapTransformer.transformDelResponse(msg);
                break;
            }
            case MODIFY_RESPONSE: {
                codecMessage = LdapTransformer.transformModifyResponse(msg);
                break;
            }
            case MODIFYDN_RESPONSE: {
                codecMessage = LdapTransformer.transformModifyDNResponse(msg);
                break;
            }
            case EXTENDED_RESPONSE: {
                codecMessage = LdapTransformer.transformExtendedResponse(msg);
                break;
            }
            case INTERMEDIATE_RESPONSE: {
                codecMessage = LdapTransformer.transformIntermediateResponse(msg);
            }
        }
        codecMessage.setMessageId(msg.getMessageId());
        if (!msg.getControls().isEmpty()) {
            LdapTransformer.transformControlsInternalToCodec(codecMessage, msg);
        }
        if (IS_DEBUG) {
            LOG.debug("Transformed message : " + (Object)((Object)codecMessage));
        }
        return codecMessage;
    }

    private static void transformControlsCodecToInternal(LdapMessageCodec codecMessage, InternalMessage internalMessage) {
        if (codecMessage.getControls() == null) {
            return;
        }
        for (Control codecControl : codecMessage.getControls()) {
            internalMessage.add(codecControl);
        }
    }

    private static void transformControlsInternalToCodec(LdapMessageCodec codecMessage, InternalMessage internalMessage) {
        if (internalMessage.getControls() == null) {
            return;
        }
        for (Control control : internalMessage.getControls().values()) {
            codecMessage.addControl(control);
        }
    }
}

