/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SchemaObjectType {
    ATTRIBUTE_TYPE(0),
    COMPARATOR(1),
    DIT_CONTENT_RULE(2),
    DIT_STRUCTURE_RULE(3),
    LDAP_SYNTAX(4),
    MATCHING_RULE(5),
    MATCHING_RULE_USE(6),
    NAME_FORM(7),
    NORMALIZER(8),
    OBJECT_CLASS(9),
    SYNTAX_CHECKER(10);

    private int value;

    private SchemaObjectType(int value) {
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public String getRdn() {
        String schemaObjectPath = null;
        switch (this) {
            case ATTRIBUTE_TYPE: {
                schemaObjectPath = "ou=attributetypes";
                break;
            }
            case COMPARATOR: {
                schemaObjectPath = "ou=comparators";
                break;
            }
            case DIT_CONTENT_RULE: {
                schemaObjectPath = "ou=ditcontentrules";
                break;
            }
            case DIT_STRUCTURE_RULE: {
                schemaObjectPath = "ou=ditstructurerules";
                break;
            }
            case LDAP_SYNTAX: {
                schemaObjectPath = "ou=syntaxes";
                break;
            }
            case MATCHING_RULE: {
                schemaObjectPath = "ou=matchingrules";
                break;
            }
            case MATCHING_RULE_USE: {
                schemaObjectPath = "ou=matchingruleuse";
                break;
            }
            case NAME_FORM: {
                schemaObjectPath = "ou=nameforms";
                break;
            }
            case NORMALIZER: {
                schemaObjectPath = "ou=normalizers";
                break;
            }
            case OBJECT_CLASS: {
                schemaObjectPath = "ou=objectclasses";
                break;
            }
            case SYNTAX_CHECKER: {
                schemaObjectPath = "ou=syntaxcheckers";
            }
        }
        return schemaObjectPath;
    }
}

