
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.drill.exec.expr.fn.impl;

import org.apache.drill.common.FunctionNames;
import org.apache.drill.exec.expr.DrillSimpleFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.fn.FunctionGenerationHelper;
import org.apache.drill.exec.expr.fn.impl.ByteFunctionHelpers;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.record.RecordBatch;
import javax.inject.Inject;
import io.netty.buffer.DrillBuf;

/*
 * This class is generated using freemarker and the ComparisonFunctions.java template.
 */

@SuppressWarnings("unused")
public class GCompareIntervalVsInterval {



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareIntervalVsIntervalNullHigh implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param IntervalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareIntervalVsIntervalNullLow implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param IntervalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareIntervalVsNullableIntervalNullHigh implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param NullableIntervalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = -1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareIntervalVsNullableIntervalNullLow implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param NullableIntervalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

      if ( right.isSet == 0 ) {
        out.value = 1;
        break outside;
      }

    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableIntervalVsIntervalNullHigh implements DrillSimpleFunc {

    @Param NullableIntervalHolder left;
    @Param IntervalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableIntervalVsIntervalNullLow implements DrillSimpleFunc {

    @Param NullableIntervalHolder left;
    @Param IntervalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
    }
  }



  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_HIGH,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableIntervalVsNullableIntervalNullHigh implements DrillSimpleFunc {

    @Param NullableIntervalHolder left;
    @Param NullableIntervalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = 1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = -1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
    }
  }

  @FunctionTemplate(name = FunctionGenerationHelper.COMPARE_TO_NULLS_LOW,
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.INTERNAL)
  public static class GCompareNullableIntervalVsNullableIntervalNullLow implements DrillSimpleFunc {

    @Param NullableIntervalHolder left;
    @Param NullableIntervalHolder right;
    @Output IntHolder out;

    public void setup() {}

    public void eval() {
     outside:
      {

        if ( left.isSet == 0 ) {
          if ( right.isSet == 0 ) {
            out.value = 0;
            break outside;
          } else {
            out.value = -1;
            break outside;
          }
        } else if ( right.isSet == 0 ) {
          out.value = 1;
          break outside;
        }

    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        out.value = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
    }
  }

   @FunctionTemplate(names = {FunctionNames.LT, "<"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanIntervalVsInterval implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param IntervalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {

      int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
      out.value = cmp == -1 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {FunctionNames.LE, "<="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class LessThanEqIntervalVsInterval implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param IntervalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {

      int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
      out.value = cmp < 1 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {FunctionNames.GT, ">"},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanIntervalVsInterval implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param IntervalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {

      int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
      out.value = cmp == 1 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {FunctionNames.GE, ">="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class GreaterThanEqIntervalVsInterval implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param IntervalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {

      int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
      out.value = cmp > -1 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {FunctionNames.EQ, "==", "="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class EqualsIntervalVsInterval implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param IntervalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {

      int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
      out.value = cmp == 0 ? 1 : 0;
    }
  }

  @FunctionTemplate(names = {FunctionNames.NE, "<>", "!="},
                    scope = FunctionTemplate.FunctionScope.SIMPLE,
                    nulls = NullHandling.NULL_IF_NULL)
  public static class NotEqualsIntervalVsInterval implements DrillSimpleFunc {

    @Param IntervalHolder left;
    @Param IntervalHolder right;
    @Output BitHolder out;

    public void setup() {}

    public void eval() {

      int cmp;
     outside:
      {


    // NaN is the biggest possible value, and NaN == NaN

        org.joda.time.MutableDateTime leftDate  =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);
        org.joda.time.MutableDateTime rightDate =
            new org.joda.time.MutableDateTime(1970, 1, 1, 0, 0, 0, 0, org.joda.time.DateTimeZone.UTC);

        // Left and right date have the same starting point (epoch), add the interval period and compare the two
        leftDate.addMonths(left.months);
        leftDate.addDays(left.days);
        leftDate.add(left.milliseconds);

        rightDate.addMonths(right.months);
        rightDate.addDays(right.days);
        rightDate.add(right.milliseconds);

        long leftMS  = leftDate.getMillis();
        long rightMS = rightDate.getMillis();

        cmp = leftMS < rightMS ? -1 : (leftMS > rightMS ? 1 : 0);


      } // outside
        out.value = cmp == 0 ? 0 : 1;
    }
  }
}
 


