
/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * This class is generated using freemarker and the MedianFunctions.java template.
 */


package org.apache.drill.exec.expr.fn.impl.gaggr;

import org.apache.drill.exec.expr.DrillAggFunc;
import org.apache.drill.exec.expr.annotations.FunctionTemplate;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.NullHandling;
import org.apache.drill.exec.expr.annotations.FunctionTemplate.FunctionScope;
import org.apache.drill.exec.expr.annotations.Output;
import org.apache.drill.exec.expr.annotations.Param;
import org.apache.drill.exec.expr.annotations.Workspace;
import org.apache.drill.exec.expr.holders.*;
import org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper;
import org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper;
import org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper;

@SuppressWarnings("unused")

public class MedianFunctions {
  static final org.slf4j.Logger logger = org.slf4j.LoggerFactory.getLogger(MedianFunctions.class);


  @FunctionTemplate(name = "median", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

  public static class IntMedian implements DrillAggFunc {

    @Param IntHolder input;
    @Output NullableBigIntHolder median;
    @Workspace ObjectHolder utils;

    public void setup() {
      // Initialize the ObjectHolder
      utils = new ObjectHolder();
      utils.obj = new org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper();
    }

    @Override
    public void add() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      medianHelper.addNextNumber(input.value);

    }

    @Override
    public void output() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      median.value = medianHelper.getMedian();
      median.isSet = 1;
    }

    @Override
    public void reset() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      medianHelper.reset();
    }
  }



  @FunctionTemplate(name = "median", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

  public static class BigIntMedian implements DrillAggFunc {

    @Param BigIntHolder input;
    @Output NullableBigIntHolder median;
    @Workspace ObjectHolder utils;

    public void setup() {
      // Initialize the ObjectHolder
      utils = new ObjectHolder();
      utils.obj = new org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper();
    }

    @Override
    public void add() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      medianHelper.addNextNumber(input.value);

    }

    @Override
    public void output() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      median.value = medianHelper.getMedian();
      median.isSet = 1;
    }

    @Override
    public void reset() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      medianHelper.reset();
    }
  }



  @FunctionTemplate(name = "median", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

  public static class NullableIntMedian implements DrillAggFunc {

    @Param NullableIntHolder input;
    @Output NullableBigIntHolder median;
    @Workspace ObjectHolder utils;

    public void setup() {
      // Initialize the ObjectHolder
      utils = new ObjectHolder();
      utils.obj = new org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper();
    }

    @Override
    public void add() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
          sout: {
      if (input.isSet == 0) {
        // processing nullable input and the value is null, so don't do anything...
        break sout;
      }
      medianHelper.addNextNumber(input.value);

      } // end of sout block
    }

    @Override
    public void output() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      median.value = medianHelper.getMedian();
      median.isSet = 1;
    }

    @Override
    public void reset() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      medianHelper.reset();
    }
  }



  @FunctionTemplate(name = "median", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

  public static class NullableBigIntMedian implements DrillAggFunc {

    @Param NullableBigIntHolder input;
    @Output NullableBigIntHolder median;
    @Workspace ObjectHolder utils;

    public void setup() {
      // Initialize the ObjectHolder
      utils = new ObjectHolder();
      utils.obj = new org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper();
    }

    @Override
    public void add() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
          sout: {
      if (input.isSet == 0) {
        // processing nullable input and the value is null, so don't do anything...
        break sout;
      }
      medianHelper.addNextNumber(input.value);

      } // end of sout block
    }

    @Override
    public void output() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      median.value = medianHelper.getMedian();
      median.isSet = 1;
    }

    @Override
    public void reset() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingIntMedianHelper) utils.obj;
      medianHelper.reset();
    }
  }



  @FunctionTemplate(name = "median", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

  public static class Float4Median implements DrillAggFunc {

    @Param Float4Holder input;
    @Output NullableFloat8Holder median;
    @Workspace ObjectHolder utils;

    public void setup() {
      // Initialize the ObjectHolder
      utils = new ObjectHolder();
      utils.obj = new org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper();
    }

    @Override
    public void add() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      medianHelper.addNextNumber(input.value);

    }

    @Override
    public void output() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      median.value = medianHelper.getMedian();
      median.isSet = 1;
    }

    @Override
    public void reset() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      medianHelper.reset();
    }
  }



  @FunctionTemplate(name = "median", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

  public static class Float8Median implements DrillAggFunc {

    @Param Float8Holder input;
    @Output NullableFloat8Holder median;
    @Workspace ObjectHolder utils;

    public void setup() {
      // Initialize the ObjectHolder
      utils = new ObjectHolder();
      utils.obj = new org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper();
    }

    @Override
    public void add() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      medianHelper.addNextNumber(input.value);

    }

    @Override
    public void output() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      median.value = medianHelper.getMedian();
      median.isSet = 1;
    }

    @Override
    public void reset() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      medianHelper.reset();
    }
  }



  @FunctionTemplate(name = "median", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

  public static class NullableFloat4Median implements DrillAggFunc {

    @Param NullableFloat4Holder input;
    @Output NullableFloat8Holder median;
    @Workspace ObjectHolder utils;

    public void setup() {
      // Initialize the ObjectHolder
      utils = new ObjectHolder();
      utils.obj = new org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper();
    }

    @Override
    public void add() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
          sout: {
      if (input.isSet == 0) {
        // processing nullable input and the value is null, so don't do anything...
        break sout;
      }
      medianHelper.addNextNumber(input.value);

      } // end of sout block
    }

    @Override
    public void output() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      median.value = medianHelper.getMedian();
      median.isSet = 1;
    }

    @Override
    public void reset() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      medianHelper.reset();
    }
  }



  @FunctionTemplate(name = "median", scope = FunctionTemplate.FunctionScope.POINT_AGGREGATE)

  public static class NullableFloat8Median implements DrillAggFunc {

    @Param NullableFloat8Holder input;
    @Output NullableFloat8Holder median;
    @Workspace ObjectHolder utils;

    public void setup() {
      // Initialize the ObjectHolder
      utils = new ObjectHolder();
      utils.obj = new org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper();
    }

    @Override
    public void add() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
          sout: {
      if (input.isSet == 0) {
        // processing nullable input and the value is null, so don't do anything...
        break sout;
      }
      medianHelper.addNextNumber(input.value);

      } // end of sout block
    }

    @Override
    public void output() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      median.value = medianHelper.getMedian();
      median.isSet = 1;
    }

    @Override
    public void reset() {
      org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingMedianHelper medianHelper = (org.apache.drill.exec.expr.fn.impl.StreamingMedianHelpers.StreamingDoubleMedianHelper) utils.obj;
      medianHelper.reset();
    }
  }


}
