/*
 * Decompiled with CFR 0.152.
 */
package oadd.com.fasterxml.jackson.databind.ext;

import java.io.Serializable;
import oadd.com.fasterxml.jackson.databind.BeanDescription;
import oadd.com.fasterxml.jackson.databind.DeserializationConfig;
import oadd.com.fasterxml.jackson.databind.JavaType;
import oadd.com.fasterxml.jackson.databind.JsonDeserializer;
import oadd.com.fasterxml.jackson.databind.JsonMappingException;
import oadd.com.fasterxml.jackson.databind.JsonSerializer;
import oadd.com.fasterxml.jackson.databind.SerializationConfig;
import oadd.com.fasterxml.jackson.databind.deser.Deserializers;
import oadd.com.fasterxml.jackson.databind.ser.Serializers;
import oadd.com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class OptionalHandlerFactory
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String PACKAGE_PREFIX_JAVAX_XML = "javax.xml.";
    private static final String SERIALIZERS_FOR_JAVAX_XML = "oadd.com.fasterxml.jackson.databind.ext.CoreXMLSerializers";
    private static final String DESERIALIZERS_FOR_JAVAX_XML = "oadd.com.fasterxml.jackson.databind.ext.CoreXMLDeserializers";
    private static final String SERIALIZER_FOR_DOM_NODE = "oadd.com.fasterxml.jackson.databind.ext.DOMSerializer";
    private static final String DESERIALIZER_FOR_DOM_DOCUMENT = "oadd.com.fasterxml.jackson.databind.ext.DOMDeserializer$DocumentDeserializer";
    private static final String DESERIALIZER_FOR_DOM_NODE = "oadd.com.fasterxml.jackson.databind.ext.DOMDeserializer$NodeDeserializer";
    private static final String DESERIALIZER_FOR_PATH = "oadd.com.fasterxml.jackson.databind.ext.PathDeserializer";
    private static final Class<?> CLASS_DOM_NODE;
    private static final Class<?> CLASS_DOM_DOCUMENT;
    private static final Class<?> CLASS_JAVA7_PATH;
    public static final OptionalHandlerFactory instance;

    protected OptionalHandlerFactory() {
    }

    public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
        Class<?> rawType = type.getRawClass();
        if (CLASS_JAVA7_PATH != null && CLASS_JAVA7_PATH.isAssignableFrom(rawType)) {
            return ToStringSerializer.instance;
        }
        if (CLASS_DOM_NODE != null && CLASS_DOM_NODE.isAssignableFrom(rawType)) {
            return (JsonSerializer)this.instantiate(SERIALIZER_FOR_DOM_NODE);
        }
        String className = rawType.getName();
        if (!className.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        String factoryName = SERIALIZERS_FOR_JAVAX_XML;
        Object ob = this.instantiate(factoryName);
        if (ob == null) {
            return null;
        }
        return ((Serializers)ob).findSerializer(config, type, beanDesc);
    }

    public JsonDeserializer<?> findDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
        Class<?> rawType = type.getRawClass();
        if (CLASS_JAVA7_PATH != null && CLASS_JAVA7_PATH.isAssignableFrom(rawType)) {
            return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_PATH);
        }
        if (CLASS_DOM_NODE != null && CLASS_DOM_NODE.isAssignableFrom(rawType)) {
            return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_NODE);
        }
        if (CLASS_DOM_DOCUMENT != null && CLASS_DOM_DOCUMENT.isAssignableFrom(rawType)) {
            return (JsonDeserializer)this.instantiate(DESERIALIZER_FOR_DOM_DOCUMENT);
        }
        String className = rawType.getName();
        if (!className.startsWith(PACKAGE_PREFIX_JAVAX_XML) && !this.hasSuperClassStartingWith(rawType, PACKAGE_PREFIX_JAVAX_XML)) {
            return null;
        }
        String factoryName = DESERIALIZERS_FOR_JAVAX_XML;
        Object ob = this.instantiate(factoryName);
        if (ob == null) {
            return null;
        }
        return ((Deserializers)ob).findBeanDeserializer(type, config, beanDesc);
    }

    private Object instantiate(String className) {
        try {
            return Class.forName(className).newInstance();
        }
        catch (LinkageError e) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private boolean hasSuperClassStartingWith(Class<?> rawType, String prefix) {
        for (Class<?> supertype = rawType.getSuperclass(); supertype != null; supertype = supertype.getSuperclass()) {
            if (supertype == Object.class) {
                return false;
            }
            if (!supertype.getName().startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    static {
        Class<Document> doc = null;
        Class<Node> node = null;
        try {
            node = Node.class;
            doc = Document.class;
        }
        catch (Exception e) {
            System.err.println("WARNING: could not load DOM Node and/or Document classes");
        }
        CLASS_DOM_NODE = node;
        CLASS_DOM_DOCUMENT = doc;
        Class<?> cls = null;
        try {
            cls = Class.forName("java.nio.file.Path");
        }
        catch (Exception e) {
            System.err.println("WARNING: could not load Java7 Path class");
        }
        CLASS_JAVA7_PATH = cls;
        instance = new OptionalHandlerFactory();
    }
}

